/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.recharge;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.recharge.RechargeClient;
import com.yeepay.yop.sdk.service.recharge.request.BankAccountQueryRequest;
import com.yeepay.yop.sdk.service.recharge.request.BankAccountQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.recharge.response.BankAccountQueryResponse;

public class RechargeClientImpl
implements RechargeClient {
    private final ClientHandler clientHandler;

    RechargeClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public BankAccountQueryResponse bankAccountQuery(BankAccountQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getBankCode() == null) {
            throw new YopClientException("request.bankCode is required.");
        }
        if (request.getAccountNo() == null) {
            throw new YopClientException("request.accountNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        BankAccountQueryRequestMarshaller requestMarshaller = BankAccountQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(BankAccountQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (BankAccountQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

