/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.mer.request.QualificationSupplementaryRequest;
import java.util.Map;
import java.util.UUID;

public class QualificationSupplementaryRequestMarshaller
implements RequestMarshaller<QualificationSupplementaryRequest> {
    private final String serviceName = "Mer";
    private final String resourcePath = "/rest/v1.0/mer/qualification/supplementary";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<QualificationSupplementaryRequest> marshall(QualificationSupplementaryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Mer");
        internalRequest.setResourcePath("/rest/v1.0/mer/qualification/supplementary");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getRegistAddress() != null) {
            internalRequest.addParameter("registAddress", PrimitiveMarshallerUtils.marshalling((Object)request.getRegistAddress(), (String)"String"));
        }
        if (request.getManageSection() != null) {
            internalRequest.addParameter("manageSection", PrimitiveMarshallerUtils.marshalling((Object)request.getManageSection(), (String)"String"));
        }
        if (request.getCorporationFrontUrl() != null) {
            internalRequest.addParameter("corporationFrontUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCorporationFrontUrl(), (String)"String"));
        }
        if (request.getCorporationBackUrl() != null) {
            internalRequest.addParameter("corporationBackUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCorporationBackUrl(), (String)"String"));
        }
        if (request.getCorporationExpiryDate() != null) {
            internalRequest.addParameter("corporationExpiryDate", PrimitiveMarshallerUtils.marshalling((Object)request.getCorporationExpiryDate(), (String)"String"));
        }
        if (request.getQualificationUrl() != null) {
            internalRequest.addParameter("qualificationUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getQualificationUrl(), (String)"String"));
        }
        if (request.getQualificationExpiryDate() != null) {
            internalRequest.addParameter("qualificationExpiryDate", PrimitiveMarshallerUtils.marshalling((Object)request.getQualificationExpiryDate(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static QualificationSupplementaryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static QualificationSupplementaryRequestMarshaller INSTANCE = new QualificationSupplementaryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

