/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.settle;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.model.yos.YosDownloadResponse;
import com.yeepay.yop.sdk.service.settle.SettleClient;
import com.yeepay.yop.sdk.service.settle.request.BalanceQueryRequest;
import com.yeepay.yop.sdk.service.settle.request.BalanceQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.FileGetRequest;
import com.yeepay.yop.sdk.service.settle.request.FileGetRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.RecordsQueryRequest;
import com.yeepay.yop.sdk.service.settle.request.RecordsQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.SelfSettleApplyRequest;
import com.yeepay.yop.sdk.service.settle.request.SelfSettleApplyRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.SettleCardAddRequest;
import com.yeepay.yop.sdk.service.settle.request.SettleCardAddRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.SettleCardModifyRequest;
import com.yeepay.yop.sdk.service.settle.request.SettleCardModifyRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.SettleWayModifyRatioRequest;
import com.yeepay.yop.sdk.service.settle.request.SettleWayModifyRatioRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.request.SettleWayQueryRequest;
import com.yeepay.yop.sdk.service.settle.request.SettleWayQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.settle.response.BalanceQueryResponse;
import com.yeepay.yop.sdk.service.settle.response.RecordsQueryResponse;
import com.yeepay.yop.sdk.service.settle.response.SelfSettleApplyResponse;
import com.yeepay.yop.sdk.service.settle.response.SettleCardAddResponse;
import com.yeepay.yop.sdk.service.settle.response.SettleCardModifyResponse;
import com.yeepay.yop.sdk.service.settle.response.SettleWayModifyRatioResponse;
import com.yeepay.yop.sdk.service.settle.response.SettleWayQueryResponse;

public class SettleClientImpl
implements SettleClient {
    private final ClientHandler clientHandler;

    SettleClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public BalanceQueryResponse balanceQuery(BalanceQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getOperatePeriod() == null) {
            throw new YopClientException("request.operatePeriod is required.");
        }
        BalanceQueryRequestMarshaller requestMarshaller = BalanceQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(BalanceQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (BalanceQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public YosDownloadResponse fileGet(FileGetRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        FileGetRequestMarshaller requestMarshaller = FileGetRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(YosDownloadResponse.class, HttpResponseAnalyzerSupport.getYosDownloadAnalyzerChain());
        return (YosDownloadResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RecordsQueryResponse recordsQuery(RecordsQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        RecordsQueryRequestMarshaller requestMarshaller = RecordsQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RecordsQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RecordsQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public SelfSettleApplyResponse selfSettleApply(SelfSettleApplyRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        SelfSettleApplyRequestMarshaller requestMarshaller = SelfSettleApplyRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(SelfSettleApplyResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (SelfSettleApplyResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public SettleCardAddResponse settleCardAdd(SettleCardAddRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        SettleCardAddRequestMarshaller requestMarshaller = SettleCardAddRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(SettleCardAddResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (SettleCardAddResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public SettleCardModifyResponse settleCardModify(SettleCardModifyRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        SettleCardModifyRequestMarshaller requestMarshaller = SettleCardModifyRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(SettleCardModifyResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (SettleCardModifyResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public SettleWayModifyRatioResponse settleWayModifyRatio(SettleWayModifyRatioRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getBody() == null) {
            throw new YopClientException("request.body is required.");
        }
        SettleWayModifyRatioRequestMarshaller requestMarshaller = SettleWayModifyRatioRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(SettleWayModifyRatioResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (SettleWayModifyRatioResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public SettleWayQueryResponse settleWayQuery(SettleWayQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        SettleWayQueryRequestMarshaller requestMarshaller = SettleWayQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(SettleWayQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (SettleWayQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

