/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.trade;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.trade.TradeClient;
import com.yeepay.yop.sdk.service.trade.request.OrderCloseRequest;
import com.yeepay.yop.sdk.service.trade.request.OrderCloseRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.OrderCombineQueryRequest;
import com.yeepay.yop.sdk.service.trade.request.OrderCombineQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.OrderQueryRequest;
import com.yeepay.yop.sdk.service.trade.request.OrderQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.OrderRequest;
import com.yeepay.yop.sdk.service.trade.request.OrderRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.ReceiptDownloadRequest;
import com.yeepay.yop.sdk.service.trade.request.ReceiptDownloadRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.RefundEndRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundEndRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.RefundFastRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundFastRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.RefundQueryRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.RefundReceiptDownloadRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundReceiptDownloadRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.RefundRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.request.RefundSupplyRequest;
import com.yeepay.yop.sdk.service.trade.request.RefundSupplyRequestMarshaller;
import com.yeepay.yop.sdk.service.trade.response.OrderCloseResponse;
import com.yeepay.yop.sdk.service.trade.response.OrderCombineQueryResponse;
import com.yeepay.yop.sdk.service.trade.response.OrderQueryResponse;
import com.yeepay.yop.sdk.service.trade.response.OrderResponse;
import com.yeepay.yop.sdk.service.trade.response.ReceiptDownloadResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundEndResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundFastResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundQueryResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundReceiptDownloadResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundResponse;
import com.yeepay.yop.sdk.service.trade.response.RefundSupplyResponse;

public class TradeClientImpl
implements TradeClient {
    private final ClientHandler clientHandler;

    TradeClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public OrderResponse order(OrderRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        OrderRequestMarshaller requestMarshaller = OrderRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OrderResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OrderResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public OrderCloseResponse orderClose(OrderCloseRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        OrderCloseRequestMarshaller requestMarshaller = OrderCloseRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OrderCloseResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OrderCloseResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public OrderCombineQueryResponse orderCombineQuery(OrderCombineQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getOrderId() == null) {
            throw new YopClientException("request.orderId is required.");
        }
        OrderCombineQueryRequestMarshaller requestMarshaller = OrderCombineQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OrderCombineQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OrderCombineQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public OrderQueryResponse orderQuery(OrderQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getOrderId() == null) {
            throw new YopClientException("request.orderId is required.");
        }
        OrderQueryRequestMarshaller requestMarshaller = OrderQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(OrderQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (OrderQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public ReceiptDownloadResponse receiptDownload(ReceiptDownloadRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getOrderId() == null) {
            throw new YopClientException("request.orderId is required.");
        }
        ReceiptDownloadRequestMarshaller requestMarshaller = ReceiptDownloadRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(ReceiptDownloadResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (ReceiptDownloadResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RefundResponse refund(RefundRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RefundRequestMarshaller requestMarshaller = RefundRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RefundResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RefundResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RefundEndResponse refundEnd(RefundEndRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RefundEndRequestMarshaller requestMarshaller = RefundEndRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RefundEndResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RefundEndResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RefundFastResponse refundFast(RefundFastRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RefundFastRequestMarshaller requestMarshaller = RefundFastRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RefundFastResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RefundFastResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RefundQueryResponse refundQuery(RefundQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getOrderId() == null) {
            throw new YopClientException("request.orderId is required.");
        }
        if (request.getRefundRequestId() == null) {
            throw new YopClientException("request.refundRequestId is required.");
        }
        RefundQueryRequestMarshaller requestMarshaller = RefundQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RefundQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RefundQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RefundReceiptDownloadResponse refundReceiptDownload(RefundReceiptDownloadRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getOrderId() == null) {
            throw new YopClientException("request.orderId is required.");
        }
        if (request.getRefundRequestId() == null) {
            throw new YopClientException("request.refundRequestId is required.");
        }
        RefundReceiptDownloadRequestMarshaller requestMarshaller = RefundReceiptDownloadRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RefundReceiptDownloadResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RefundReceiptDownloadResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RefundSupplyResponse refundSupply(RefundSupplyRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        RefundSupplyRequestMarshaller requestMarshaller = RefundSupplyRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RefundSupplyResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RefundSupplyResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

