/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.frontcashier.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.frontcashier.request.BindpayRequestRequest;
import java.util.Map;
import java.util.UUID;

public class BindpayRequestRequestMarshaller
implements RequestMarshaller<BindpayRequestRequest> {
    private final String serviceName = "Frontcashier";
    private final String resourcePath = "/rest/v1.0/frontcashier/bindpay/request";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<BindpayRequestRequest> marshall(BindpayRequestRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Frontcashier");
        internalRequest.setResourcePath("/rest/v1.0/frontcashier/bindpay/request");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getToken() != null) {
            internalRequest.addParameter("token", PrimitiveMarshallerUtils.marshalling((Object)request.getToken(), (String)"String"));
        }
        if (request.getBindId() != null) {
            internalRequest.addParameter("bindId", PrimitiveMarshallerUtils.marshalling((Object)request.getBindId(), (String)"String"));
        }
        if (request.getUserNo() != null) {
            internalRequest.addParameter("userNo", PrimitiveMarshallerUtils.marshalling((Object)request.getUserNo(), (String)"String"));
        }
        if (request.getUserType() != null) {
            internalRequest.addParameter("userType", PrimitiveMarshallerUtils.marshalling((Object)request.getUserType(), (String)"String"));
        }
        if (request.getUserIp() != null) {
            internalRequest.addParameter("userIp", PrimitiveMarshallerUtils.marshalling((Object)request.getUserIp(), (String)"String"));
        }
        if (request.getVersion() != null) {
            internalRequest.addParameter("version", PrimitiveMarshallerUtils.marshalling((Object)request.getVersion(), (String)"String"));
        }
        if (request.getExtParamMap() != null) {
            internalRequest.addParameter("extParamMap", PrimitiveMarshallerUtils.marshalling((Object)request.getExtParamMap(), (String)"String"));
        }
        if (request.getPayMerchantNo() != null) {
            internalRequest.addParameter("payMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BindpayRequestRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BindpayRequestRequestMarshaller INSTANCE = new BindpayRequestRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

