/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.mer.request.BankAccountOpenRequest;
import java.util.Map;
import java.util.UUID;

public class BankAccountOpenRequestMarshaller
implements RequestMarshaller<BankAccountOpenRequest> {
    private final String serviceName = "Mer";
    private final String resourcePath = "/rest/v1.0/mer/bank-account/open";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<BankAccountOpenRequest> marshall(BankAccountOpenRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Mer");
        internalRequest.setResourcePath("/rest/v1.0/mer/bank-account/open");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getBusinessPlacePhoto() != null) {
            internalRequest.addParameter("businessPlacePhoto", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessPlacePhoto(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getDeviceip() != null) {
            internalRequest.addParameter("deviceip", PrimitiveMarshallerUtils.marshalling((Object)request.getDeviceip(), (String)"String"));
        }
        if (request.getToken() != null) {
            internalRequest.addParameter("token", PrimitiveMarshallerUtils.marshalling((Object)request.getToken(), (String)"String"));
        }
        if (request.getMerchantSubjectInfo() != null) {
            internalRequest.addParameter("merchantSubjectInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantSubjectInfo(), (String)"String"));
        }
        if (request.getSettlementAccountInfo() != null) {
            internalRequest.addParameter("settlementAccountInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getSettlementAccountInfo(), (String)"String"));
        }
        if (request.getMerchantCorporationInfo() != null) {
            internalRequest.addParameter("merchantCorporationInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantCorporationInfo(), (String)"String"));
        }
        if (request.getMerchantContactInfo() != null) {
            internalRequest.addParameter("merchantContactInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantContactInfo(), (String)"String"));
        }
        if (request.getShareholdersInfo() != null) {
            internalRequest.addParameter("shareholdersInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getShareholdersInfo(), (String)"String"));
        }
        if (request.getBeneficiaryInfo() != null) {
            internalRequest.addParameter("beneficiaryInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getBeneficiaryInfo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BankAccountOpenRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BankAccountOpenRequestMarshaller INSTANCE = new BankAccountOpenRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

