/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.EnterpriseTokenPayOrderRequest;
import java.util.Map;
import java.util.UUID;

public class EnterpriseTokenPayOrderRequestMarshaller
implements RequestMarshaller<EnterpriseTokenPayOrderRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/enterprise/token-pay/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<EnterpriseTokenPayOrderRequest> marshall(EnterpriseTokenPayOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/enterprise/token-pay/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getToken() != null) {
            internalRequest.addParameter("token", PrimitiveMarshallerUtils.marshalling((Object)request.getToken(), (String)"String"));
        }
        if (request.getPayerMerchantNo() != null) {
            internalRequest.addParameter("payerMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static EnterpriseTokenPayOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static EnterpriseTokenPayOrderRequestMarshaller INSTANCE = new EnterpriseTokenPayOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

