/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.PaySystemQueryRequest;
import java.util.Map;
import java.util.UUID;

public class PaySystemQueryRequestMarshaller
implements RequestMarshaller<PaySystemQueryRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/pay/system/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<PaySystemQueryRequest> marshall(PaySystemQueryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/pay/system/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getOrderNo() != null) {
            internalRequest.addParameter("orderNo", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static PaySystemQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static PaySystemQueryRequestMarshaller INSTANCE = new PaySystemQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

