/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.TransferWechatOrderRequest;
import java.util.Map;
import java.util.UUID;

public class TransferWechatOrderRequestMarshaller
implements RequestMarshaller<TransferWechatOrderRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/transfer/wechat/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<TransferWechatOrderRequest> marshall(TransferWechatOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/transfer/wechat/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getAmount() != null) {
            internalRequest.addParameter("amount", PrimitiveMarshallerUtils.marshalling((Object)request.getAmount(), (String)"BigDecimal"));
        }
        if (request.getAppId() != null) {
            internalRequest.addParameter("appId", PrimitiveMarshallerUtils.marshalling((Object)request.getAppId(), (String)"String"));
        }
        if (request.getScene() != null) {
            internalRequest.addParameter("scene", PrimitiveMarshallerUtils.marshalling((Object)request.getScene(), (String)"String"));
        }
        if (request.getOpenId() != null) {
            internalRequest.addParameter("openId", PrimitiveMarshallerUtils.marshalling((Object)request.getOpenId(), (String)"String"));
        }
        if (request.getUserName() != null) {
            internalRequest.addParameter("userName", PrimitiveMarshallerUtils.marshalling((Object)request.getUserName(), (String)"String"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling((Object)request.getRemark(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static TransferWechatOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static TransferWechatOrderRequestMarshaller INSTANCE = new TransferWechatOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

