/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.account.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.account.request.WithdrawOrderRequest;
import java.util.Map;
import java.util.UUID;

public class WithdrawOrderRequestMarshaller
implements RequestMarshaller<WithdrawOrderRequest> {
    private final String serviceName = "Account";
    private final String resourcePath = "/rest/v1.0/account/withdraw/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<WithdrawOrderRequest> marshall(WithdrawOrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Account");
        internalRequest.setResourcePath("/rest/v1.0/account/withdraw/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getBankCardId() != null) {
            internalRequest.addParameter("bankCardId", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCardId(), (String)"String"));
        }
        if (request.getBankAccountNo() != null) {
            internalRequest.addParameter("bankAccountNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBankAccountNo(), (String)"String"));
        }
        if (request.getReceiveType() != null) {
            internalRequest.addParameter("receiveType", PrimitiveMarshallerUtils.marshalling((Object)request.getReceiveType(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getRemark() != null) {
            internalRequest.addParameter("remark", PrimitiveMarshallerUtils.marshalling((Object)request.getRemark(), (String)"String"));
        }
        if (request.getTerminalType() != null) {
            internalRequest.addParameter("terminalType", PrimitiveMarshallerUtils.marshalling((Object)request.getTerminalType(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static WithdrawOrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static WithdrawOrderRequestMarshaller INSTANCE = new WithdrawOrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

