/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.frontcashier.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.frontcashier.request.BindcardConfirmRequest;
import java.util.Map;
import java.util.UUID;

public class BindcardConfirmRequestMarshaller
implements RequestMarshaller<BindcardConfirmRequest> {
    private final String serviceName = "Frontcashier";
    private final String resourcePath = "/rest/v1.0/frontcashier/bindcard/confirm";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<BindcardConfirmRequest> marshall(BindcardConfirmRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Frontcashier");
        internalRequest.setResourcePath("/rest/v1.0/frontcashier/bindcard/confirm");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getMerchantFlowId() != null) {
            internalRequest.addParameter("merchantFlowId", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantFlowId(), (String)"String"));
        }
        if (request.getEmpower() != null) {
            internalRequest.addParameter("empower", PrimitiveMarshallerUtils.marshalling((Object)request.getEmpower(), (String)"Boolean"));
        }
        if (request.getSmsCode() != null) {
            internalRequest.addParameter("smsCode", PrimitiveMarshallerUtils.marshalling((Object)request.getSmsCode(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BindcardConfirmRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BindcardConfirmRequestMarshaller INSTANCE = new BindcardConfirmRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

