/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.invoice;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.invoice.InvoiceClient;
import com.yeepay.yop.sdk.service.invoice.request.ApplyRequest;
import com.yeepay.yop.sdk.service.invoice.request.ApplyRequestMarshaller;
import com.yeepay.yop.sdk.service.invoice.request.FeeQueryRequest;
import com.yeepay.yop.sdk.service.invoice.request.FeeQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.invoice.request.InfoModifyRequest;
import com.yeepay.yop.sdk.service.invoice.request.InfoModifyRequestMarshaller;
import com.yeepay.yop.sdk.service.invoice.request.InfoQueryRequest;
import com.yeepay.yop.sdk.service.invoice.request.InfoQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.invoice.request.RecordQueryRequest;
import com.yeepay.yop.sdk.service.invoice.request.RecordQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.invoice.response.ApplyResponse;
import com.yeepay.yop.sdk.service.invoice.response.FeeQueryResponse;
import com.yeepay.yop.sdk.service.invoice.response.InfoModifyResponse;
import com.yeepay.yop.sdk.service.invoice.response.InfoQueryResponse;
import com.yeepay.yop.sdk.service.invoice.response.RecordQueryResponse;

public class InvoiceClientImpl
implements InvoiceClient {
    private final ClientHandler clientHandler;

    InvoiceClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public ApplyResponse apply(ApplyRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        ApplyRequestMarshaller requestMarshaller = ApplyRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(ApplyResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (ApplyResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public FeeQueryResponse feeQuery(FeeQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getChargingDateStart() == null) {
            throw new YopClientException("request.chargingDateStart is required.");
        }
        if (request.getChargingDateEnd() == null) {
            throw new YopClientException("request.chargingDateEnd is required.");
        }
        FeeQueryRequestMarshaller requestMarshaller = FeeQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(FeeQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (FeeQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public InfoModifyResponse infoModify(InfoModifyRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        InfoModifyRequestMarshaller requestMarshaller = InfoModifyRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(InfoModifyResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (InfoModifyResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public InfoQueryResponse infoQuery(InfoQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        InfoQueryRequestMarshaller requestMarshaller = InfoQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(InfoQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (InfoQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public RecordQueryResponse recordQuery(RecordQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        RecordQueryRequestMarshaller requestMarshaller = RecordQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(RecordQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (RecordQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

