/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.m_wallet.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.m_wallet.request.TransferB2cQueryRequest;
import java.util.Map;
import java.util.UUID;

public class TransferB2cQueryRequestMarshaller
implements RequestMarshaller<TransferB2cQueryRequest> {
    private final String serviceName = "MWallet";
    private final String resourcePath = "/rest/v1.0/m-wallet/transfer/b2c/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<TransferB2cQueryRequest> marshall(TransferB2cQueryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "MWallet");
        internalRequest.setResourcePath("/rest/v1.0/m-wallet/transfer/b2c/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getFromMerchantNo() != null) {
            internalRequest.addParameter("fromMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getFromMerchantNo(), (String)"String"));
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getBusinessNo() != null) {
            internalRequest.addParameter("businessNo", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static TransferB2cQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static TransferB2cQueryRequestMarshaller INSTANCE = new TransferB2cQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

