/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.mer.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.mer.request.MerchantInfoModifyRequest;
import java.util.Map;
import java.util.UUID;

public class MerchantInfoModifyRequestMarshaller
implements RequestMarshaller<MerchantInfoModifyRequest> {
    private final String serviceName = "Mer";
    private final String resourcePath = "/rest/v1.0/mer/merchant/info/modify";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<MerchantInfoModifyRequest> marshall(MerchantInfoModifyRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Mer");
        internalRequest.setResourcePath("/rest/v1.0/mer/merchant/info/modify");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getRequestNo() != null) {
            internalRequest.addParameter("requestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getMerchantSubjectInfo() != null) {
            internalRequest.addParameter("merchantSubjectInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantSubjectInfo(), (String)"String"));
        }
        if (request.getMerchantCorporationInfo() != null) {
            internalRequest.addParameter("merchantCorporationInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantCorporationInfo(), (String)"String"));
        }
        if (request.getMerchantContactInfo() != null) {
            internalRequest.addParameter("merchantContactInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantContactInfo(), (String)"String"));
        }
        if (request.getBusinessAddressInfo() != null) {
            internalRequest.addParameter("businessAddressInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessAddressInfo(), (String)"String"));
        }
        if (request.getAccountInfo() != null) {
            internalRequest.addParameter("accountInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getAccountInfo(), (String)"String"));
        }
        if (request.getBankToken() != null) {
            internalRequest.addParameter("bankToken", PrimitiveMarshallerUtils.marshalling((Object)request.getBankToken(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static MerchantInfoModifyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static MerchantInfoModifyRequestMarshaller INSTANCE = new MerchantInfoModifyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

