/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.p2f;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.p2f.P2fClient;
import com.yeepay.yop.sdk.service.p2f.request.ZzdfOrderRequest;
import com.yeepay.yop.sdk.service.p2f.request.ZzdfOrderRequestMarshaller;
import com.yeepay.yop.sdk.service.p2f.request.ZzdfQueryRequest;
import com.yeepay.yop.sdk.service.p2f.request.ZzdfQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.p2f.response.ZzdfOrderResponse;
import com.yeepay.yop.sdk.service.p2f.response.ZzdfQueryResponse;

public class P2fClientImpl
implements P2fClient {
    private final ClientHandler clientHandler;

    P2fClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public ZzdfOrderResponse zzdfOrder(ZzdfOrderRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        ZzdfOrderRequestMarshaller requestMarshaller = ZzdfOrderRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(ZzdfOrderResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (ZzdfOrderResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public ZzdfQueryResponse zzdfQuery(ZzdfQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        ZzdfQueryRequestMarshaller requestMarshaller = ZzdfQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(ZzdfQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (ZzdfQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

