/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.recharge.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.recharge.request.BankAccountQueryRequest;
import java.util.Map;
import java.util.UUID;

public class BankAccountQueryRequestMarshaller
implements RequestMarshaller<BankAccountQueryRequest> {
    private final String serviceName = "Recharge";
    private final String resourcePath = "/rest/v1.0/recharge/bank-account/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<BankAccountQueryRequest> marshall(BankAccountQueryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Recharge");
        internalRequest.setResourcePath("/rest/v1.0/recharge/bank-account/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getBankCode() != null) {
            internalRequest.addParameter("bankCode", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCode(), (String)"String"));
        }
        if (request.getAccountNo() != null) {
            internalRequest.addParameter("accountNo", PrimitiveMarshallerUtils.marshalling((Object)request.getAccountNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BankAccountQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BankAccountQueryRequestMarshaller INSTANCE = new BankAccountQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

