/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.reprocess;

import com.yeepay.yop.sdk.client.ClientExecutionParams;
import com.yeepay.yop.sdk.client.ClientHandler;
import com.yeepay.yop.sdk.client.ClientHandlerImpl;
import com.yeepay.yop.sdk.client.ClientHandlerParams;
import com.yeepay.yop.sdk.client.ClientParams;
import com.yeepay.yop.sdk.exception.YopClientException;
import com.yeepay.yop.sdk.http.HttpResponseAnalyzerSupport;
import com.yeepay.yop.sdk.http.HttpResponseHandler;
import com.yeepay.yop.sdk.http.handler.DefaultHttpResponseHandler;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.reprocess.ReprocessClient;
import com.yeepay.yop.sdk.service.reprocess.request.MigrateBankOrderRequest;
import com.yeepay.yop.sdk.service.reprocess.request.MigrateBankOrderRequestMarshaller;
import com.yeepay.yop.sdk.service.reprocess.request.MigrateBankQueryRequest;
import com.yeepay.yop.sdk.service.reprocess.request.MigrateBankQueryRequestMarshaller;
import com.yeepay.yop.sdk.service.reprocess.response.MigrateBankOrderResponse;
import com.yeepay.yop.sdk.service.reprocess.response.MigrateBankQueryResponse;

public class ReprocessClientImpl
implements ReprocessClient {
    private final ClientHandler clientHandler;

    ReprocessClientImpl(ClientParams clientParams) {
        this.clientHandler = new ClientHandlerImpl(new ClientHandlerParams().withClientParams(clientParams));
    }

    @Override
    public MigrateBankOrderResponse migrateBankOrder(MigrateBankOrderRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        MigrateBankOrderRequestMarshaller requestMarshaller = MigrateBankOrderRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(MigrateBankOrderResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (MigrateBankOrderResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public MigrateBankQueryResponse migrateBankQuery(MigrateBankQueryRequest request) throws YopClientException {
        if (request == null) {
            throw new YopClientException("request is required.");
        }
        if (request.getMigrateRequestId() == null) {
            throw new YopClientException("request.migrateRequestId is required.");
        }
        if (request.getParentMerchantNo() == null) {
            throw new YopClientException("request.parentMerchantNo is required.");
        }
        if (request.getMerchantNo() == null) {
            throw new YopClientException("request.merchantNo is required.");
        }
        MigrateBankQueryRequestMarshaller requestMarshaller = MigrateBankQueryRequestMarshaller.getInstance();
        DefaultHttpResponseHandler responseHandler = new DefaultHttpResponseHandler(MigrateBankQueryResponse.class, HttpResponseAnalyzerSupport.getAnalyzerChain());
        return (MigrateBankQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withInput((BaseRequest)request).withRequestMarshaller((RequestMarshaller)requestMarshaller).withResponseHandler((HttpResponseHandler)responseHandler));
    }

    @Override
    public void shutdown() {
        this.clientHandler.shutdown();
    }
}

