/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.settle.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.settle.request.BalanceQueryRequest;
import java.util.Map;
import java.util.UUID;

public class BalanceQueryRequestMarshaller
implements RequestMarshaller<BalanceQueryRequest> {
    private final String serviceName = "Settle";
    private final String resourcePath = "/rest/v1.0/settle/balance/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<BalanceQueryRequest> marshall(BalanceQueryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Settle");
        internalRequest.setResourcePath("/rest/v1.0/settle/balance/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOperatePeriod() != null) {
            internalRequest.addParameter("operatePeriod", PrimitiveMarshallerUtils.marshalling((Object)request.getOperatePeriod(), (String)"String"));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", PrimitiveMarshallerUtils.marshalling((Object)request.getEndTime(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static BalanceQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static BalanceQueryRequestMarshaller INSTANCE = new BalanceQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

