/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.settle.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.settle.request.SelfSettleApplyRequest;
import java.util.Map;
import java.util.UUID;

public class SelfSettleApplyRequestMarshaller
implements RequestMarshaller<SelfSettleApplyRequest> {
    private final String serviceName = "Settle";
    private final String resourcePath = "/rest/v1.0/settle/self-settle/apply";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<SelfSettleApplyRequest> marshall(SelfSettleApplyRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Settle");
        internalRequest.setResourcePath("/rest/v1.0/settle/self-settle/apply");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getSettleRequestNo() != null) {
            internalRequest.addParameter("settleRequestNo", PrimitiveMarshallerUtils.marshalling((Object)request.getSettleRequestNo(), (String)"String"));
        }
        if (request.getOperatePeriod() != null) {
            internalRequest.addParameter("operatePeriod", PrimitiveMarshallerUtils.marshalling((Object)request.getOperatePeriod(), (String)"String"));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", PrimitiveMarshallerUtils.marshalling((Object)request.getEndTime(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getBankRemark() != null) {
            internalRequest.addParameter("bankRemark", PrimitiveMarshallerUtils.marshalling((Object)request.getBankRemark(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static SelfSettleApplyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static SelfSettleApplyRequestMarshaller INSTANCE = new SelfSettleApplyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

