/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.sys.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.service.sys.request.MerchantQualUploadRequest;
import java.util.Map;
import java.util.UUID;

public class MerchantQualUploadRequestMarshaller
implements RequestMarshaller<MerchantQualUploadRequest> {
    private final String serviceName = "Sys";
    private final String resourcePath = "/yos/v1.0/sys/merchant/qual/upload";
    private final String contentType = "multipart/form-data";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<MerchantQualUploadRequest> marshall(MerchantQualUploadRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Sys");
        internalRequest.setResourcePath("/yos/v1.0/sys/merchant/qual/upload");
        internalRequest.setHttpMethod(this.httpMethodName);
        internalRequest.assignYos();
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getMerQual() != null) {
            internalRequest.addMultiPartFile("merQual", request.getMerQual());
        }
        internalRequest.setContentType(YopContentType.MULTIPART_FORM);
        return internalRequest;
    }

    public static MerchantQualUploadRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static MerchantQualUploadRequestMarshaller INSTANCE = new MerchantQualUploadRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

