/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.tel_pay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.tel_pay.request.QrcodeBatchGenerateRequest;
import java.util.Map;
import java.util.UUID;

public class QrcodeBatchGenerateRequestMarshaller
implements RequestMarshaller<QrcodeBatchGenerateRequest> {
    private final String serviceName = "TelPay";
    private final String resourcePath = "/rest/v1.0/tel-pay/qrcode/batch-generate";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<QrcodeBatchGenerateRequest> marshall(QrcodeBatchGenerateRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "TelPay");
        internalRequest.setResourcePath("/rest/v1.0/tel-pay/qrcode/batch-generate");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getRequestId() != null) {
            internalRequest.addParameter("requestId", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestId(), (String)"String"));
        }
        if (request.getQrCodeInfo() != null) {
            internalRequest.addParameter("qrCodeInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getQrCodeInfo(), (String)"String"));
        }
        if (request.getDistrictCode() != null) {
            internalRequest.addParameter("districtCode", PrimitiveMarshallerUtils.marshalling((Object)request.getDistrictCode(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static QrcodeBatchGenerateRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static QrcodeBatchGenerateRequestMarshaller INSTANCE = new QrcodeBatchGenerateRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

