/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.trade.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.trade.request.OrderRequest;
import java.util.Map;
import java.util.UUID;

public class OrderRequestMarshaller
implements RequestMarshaller<OrderRequest> {
    private final String serviceName = "Trade";
    private final String resourcePath = "/rest/v1.0/trade/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<OrderRequest> marshall(OrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Trade");
        internalRequest.setResourcePath("/rest/v1.0/trade/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getSubOrderDetail() != null) {
            internalRequest.addParameter("subOrderDetail", PrimitiveMarshallerUtils.marshalling((Object)request.getSubOrderDetail(), (String)"String"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpiredTime(), (String)"String"));
        }
        if (request.getRedirectUrl() != null) {
            internalRequest.addParameter("redirectUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getRedirectUrl(), (String)"String"));
        }
        if (request.getCsUrl() != null) {
            internalRequest.addParameter("csUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsUrl(), (String)"String"));
        }
        if (request.getBusinessInfo() != null) {
            internalRequest.addParameter("businessInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessInfo(), (String)"String"));
        }
        if (request.getTerminalInfo() != null) {
            internalRequest.addParameter("terminalInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getTerminalInfo(), (String)"String"));
        }
        if (request.getYpPromotionInfo() != null) {
            internalRequest.addParameter("ypPromotionInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getYpPromotionInfo(), (String)"String"));
        }
        if (request.getPayerInfo() != null) {
            internalRequest.addParameter("payerInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerInfo(), (String)"String"));
        }
        if (request.getPayMerchantNo() != null) {
            internalRequest.addParameter("payMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayMerchantNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static OrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static OrderRequestMarshaller INSTANCE = new OrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

