/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.yop.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.yop.request.Oauth2ReportKeyRequest;
import java.util.Map;
import java.util.UUID;

public class Oauth2ReportKeyRequestMarshaller
implements RequestMarshaller<Oauth2ReportKeyRequest> {
    private final String serviceName = "Yop";
    private final String resourcePath = "/rest/v1.0/yop/oauth2/report-key";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<Oauth2ReportKeyRequest> marshall(Oauth2ReportKeyRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Yop");
        internalRequest.setResourcePath("/rest/v1.0/yop/oauth2/report-key");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getKeyType() != null) {
            internalRequest.addParameter("keyType", PrimitiveMarshallerUtils.marshalling((Object)request.getKeyType(), (String)"String"));
        }
        if (request.getKey() != null) {
            internalRequest.addParameter("key", PrimitiveMarshallerUtils.marshalling((Object)request.getKey(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static Oauth2ReportKeyRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static Oauth2ReportKeyRequestMarshaller INSTANCE = new Oauth2ReportKeyRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

