/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.aggpay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.aggpay.request.PayLinkRequest;
import java.util.Map;
import java.util.UUID;

public class PayLinkRequestMarshaller
implements RequestMarshaller<PayLinkRequest> {
    private final String serviceName = "Aggpay";
    private final String resourcePath = "/rest/v1.0/aggpay/pay-link";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<PayLinkRequest> marshall(PayLinkRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Aggpay");
        internalRequest.setResourcePath("/rest/v1.0/aggpay/pay-link");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpiredTime(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getScene() != null) {
            internalRequest.addParameter("scene", PrimitiveMarshallerUtils.marshalling((Object)request.getScene(), (String)"String"));
        }
        if (request.getAppId() != null) {
            internalRequest.addParameter("appId", PrimitiveMarshallerUtils.marshalling((Object)request.getAppId(), (String)"String"));
        }
        if (request.getChannelSpecifiedInfo() != null) {
            internalRequest.addParameter("channelSpecifiedInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getChannelSpecifiedInfo(), (String)"String"));
        }
        if (request.getChannelPromotionInfo() != null) {
            internalRequest.addParameter("channelPromotionInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getChannelPromotionInfo(), (String)"String"));
        }
        if (request.getIdentityInfo() != null) {
            internalRequest.addParameter("identityInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getIdentityInfo(), (String)"String"));
        }
        if (request.getLimitCredit() != null) {
            internalRequest.addParameter("limitCredit", PrimitiveMarshallerUtils.marshalling((Object)request.getLimitCredit(), (String)"String"));
        }
        if (request.getCsUrl() != null) {
            internalRequest.addParameter("csUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsUrl(), (String)"String"));
        }
        if (request.getYpPromotionInfo() != null) {
            internalRequest.addParameter("ypPromotionInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getYpPromotionInfo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static PayLinkRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static PayLinkRequestMarshaller INSTANCE = new PayLinkRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

