/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.netpay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.netpay.request.OrderRequest;
import java.util.Map;
import java.util.UUID;

public class OrderRequestMarshaller
implements RequestMarshaller<OrderRequest> {
    private final String serviceName = "Netpay";
    private final String resourcePath = "/rest/v1.0/netpay/order";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.POST;

    public Request<OrderRequest> marshall(OrderRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "Netpay");
        internalRequest.setResourcePath("/rest/v1.0/netpay/order");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getOrderId() != null) {
            internalRequest.addParameter("orderId", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderId(), (String)"String"));
        }
        if (request.getOrderAmount() != null) {
            internalRequest.addParameter("orderAmount", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderAmount(), (String)"BigDecimal"));
        }
        if (request.getExpiredTime() != null) {
            internalRequest.addParameter("expiredTime", PrimitiveMarshallerUtils.marshalling((Object)request.getExpiredTime(), (String)"String"));
        }
        if (request.getNotifyUrl() != null) {
            internalRequest.addParameter("notifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getNotifyUrl(), (String)"String"));
        }
        if (request.getMemo() != null) {
            internalRequest.addParameter("memo", PrimitiveMarshallerUtils.marshalling((Object)request.getMemo(), (String)"String"));
        }
        if (request.getGoodsName() != null) {
            internalRequest.addParameter("goodsName", PrimitiveMarshallerUtils.marshalling((Object)request.getGoodsName(), (String)"String"));
        }
        if (request.getFundProcessType() != null) {
            internalRequest.addParameter("fundProcessType", PrimitiveMarshallerUtils.marshalling((Object)request.getFundProcessType(), (String)"String"));
        }
        if (request.getCardType() != null) {
            internalRequest.addParameter("cardType", PrimitiveMarshallerUtils.marshalling((Object)request.getCardType(), (String)"String"));
        }
        if (request.getBankAccountType() != null) {
            internalRequest.addParameter("bankAccountType", PrimitiveMarshallerUtils.marshalling((Object)request.getBankAccountType(), (String)"String"));
        }
        if (request.getBankCode() != null) {
            internalRequest.addParameter("bankCode", PrimitiveMarshallerUtils.marshalling((Object)request.getBankCode(), (String)"String"));
        }
        if (request.getTerminalType() != null) {
            internalRequest.addParameter("terminalType", PrimitiveMarshallerUtils.marshalling((Object)request.getTerminalType(), (String)"String"));
        }
        if (request.getPayerIp() != null) {
            internalRequest.addParameter("payerIp", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerIp(), (String)"String"));
        }
        if (request.getCsNotifyUrl() != null) {
            internalRequest.addParameter("csNotifyUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getCsNotifyUrl(), (String)"String"));
        }
        if (request.getBusinessInfo() != null) {
            internalRequest.addParameter("businessInfo", PrimitiveMarshallerUtils.marshalling((Object)request.getBusinessInfo(), (String)"String"));
        }
        if (request.getRedirectUrl() != null) {
            internalRequest.addParameter("redirectUrl", PrimitiveMarshallerUtils.marshalling((Object)request.getRedirectUrl(), (String)"String"));
        }
        if (request.getOrderType() != null) {
            internalRequest.addParameter("orderType", PrimitiveMarshallerUtils.marshalling((Object)request.getOrderType(), (String)"String"));
        }
        if (request.getPayerAccountName() != null) {
            internalRequest.addParameter("payerAccountName", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerAccountName(), (String)"String"));
        }
        if (request.getPayerAccountNo() != null) {
            internalRequest.addParameter("payerAccountNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPayerAccountNo(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static OrderRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static OrderRequestMarshaller INSTANCE = new OrderRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

