/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.yop.sdk.service.tel_pay.request;

import com.yeepay.yop.sdk.http.HttpMethodName;
import com.yeepay.yop.sdk.http.YopContentType;
import com.yeepay.yop.sdk.internal.DefaultRequest;
import com.yeepay.yop.sdk.internal.Request;
import com.yeepay.yop.sdk.model.BaseRequest;
import com.yeepay.yop.sdk.model.transform.RequestMarshaller;
import com.yeepay.yop.sdk.protocol.marshaller.PrimitiveMarshallerUtils;
import com.yeepay.yop.sdk.service.tel_pay.request.QrcodeQueryRequest;
import java.util.Map;
import java.util.UUID;

public class QrcodeQueryRequestMarshaller
implements RequestMarshaller<QrcodeQueryRequest> {
    private final String serviceName = "TelPay";
    private final String resourcePath = "/rest/v1.0/tel-pay/qrcode/query";
    private final String contentType = "application/x-www-form-urlencoded";
    private final HttpMethodName httpMethodName = HttpMethodName.GET;

    public Request<QrcodeQueryRequest> marshall(QrcodeQueryRequest request) {
        Map customerHeaders;
        DefaultRequest internalRequest = new DefaultRequest((BaseRequest)request, "TelPay");
        internalRequest.setResourcePath("/rest/v1.0/tel-pay/qrcode/query");
        internalRequest.setHttpMethod(this.httpMethodName);
        if (!internalRequest.getHeaders().containsKey("x-yop-request-id")) {
            String requestId = UUID.randomUUID().toString();
            internalRequest.addHeader("x-yop-request-id", requestId);
        }
        if ((customerHeaders = request.getHeaders()) != null) {
            for (String key : customerHeaders.keySet()) {
                internalRequest.addHeader(key, (String)customerHeaders.get(key));
            }
        }
        if (request.getParentMerchantNo() != null) {
            internalRequest.addParameter("parentMerchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getParentMerchantNo(), (String)"String"));
        }
        if (request.getMerchantNo() != null) {
            internalRequest.addParameter("merchantNo", PrimitiveMarshallerUtils.marshalling((Object)request.getMerchantNo(), (String)"String"));
        }
        if (request.getRequestId() != null) {
            internalRequest.addParameter("requestId", PrimitiveMarshallerUtils.marshalling((Object)request.getRequestId(), (String)"String"));
        }
        if (request.getPageSize() != null) {
            internalRequest.addParameter("pageSize", PrimitiveMarshallerUtils.marshalling((Object)request.getPageSize(), (String)"Integer"));
        }
        if (request.getPageNo() != null) {
            internalRequest.addParameter("pageNo", PrimitiveMarshallerUtils.marshalling((Object)request.getPageNo(), (String)"Integer"));
        }
        if (request.getQrId() != null) {
            internalRequest.addParameter("qrId", PrimitiveMarshallerUtils.marshalling((Object)request.getQrId(), (String)"String"));
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", PrimitiveMarshallerUtils.marshalling((Object)request.getStartTime(), (String)"String"));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", PrimitiveMarshallerUtils.marshalling((Object)request.getEndTime(), (String)"String"));
        }
        if (request.getQrStatus() != null) {
            internalRequest.addParameter("qrStatus", PrimitiveMarshallerUtils.marshalling((Object)request.getQrStatus(), (String)"String"));
        }
        internalRequest.setContentType(YopContentType.FORM_URL_ENCODE);
        internalRequest.addHeader("Content-Type", internalRequest.getContentType().getValue());
        return internalRequest;
    }

    public static QrcodeQueryRequestMarshaller getInstance() {
        return CacheInstanceHolder.INSTANCE;
    }

    private static class CacheInstanceHolder {
        public static QrcodeQueryRequestMarshaller INSTANCE = new QrcodeQueryRequestMarshaller();

        private CacheInstanceHolder() {
        }
    }
}

