/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.icbc.util;

import com.tydic.payment.pay.icbc.IcbcApiException;
import com.tydic.payment.pay.icbc.RSA;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IcbcSignature {
    private static final Log logger = LogFactory.getLog(IcbcSignature.class);

    public static String sign(String content, String signType, String privateKey, String charset) throws IcbcApiException {
        return IcbcSignature.sign(content, signType, privateKey, charset, null);
    }

    public static String sign(String content, String signType, String privateKey, String charset, String password) throws IcbcApiException {
        try {
            byte[] contentBytes = content.getBytes(charset);
            if (signType.equals("RSA")) {
                return RSA.sign(contentBytes, Base64.decodeBase64((String)privateKey), "SHA1WithRSA");
            }
            if (signType.equals("RSA2")) {
                return RSA.sign(contentBytes, Base64.decodeBase64((String)privateKey), "SHA256WithRSA");
            }
            logger.error((Object)"not support signType.");
            throw new IcbcApiException("not support signType.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("get content charset exception. content: " + content + " charset: " + charset), (Throwable)e);
            throw new IcbcApiException("get content charset exception. content: " + content + " charset: " + charset, e);
        }
        catch (Exception e) {
            logger.error((Object)"sign exception.", (Throwable)e);
            throw new IcbcApiException("sign exception.", e);
        }
    }

    public static boolean verify(String content, String signType, String publicKey, String charset, String sign) throws IcbcApiException {
        try {
            byte[] contentBytes = content.getBytes(charset);
            if (signType.equals("RSA")) {
                return RSA.verify(contentBytes, Base64.decodeBase64((String)publicKey), sign, "SHA1WithRSA");
            }
            if (signType.equals("RSA2")) {
                return RSA.verify(contentBytes, Base64.decodeBase64((String)publicKey), sign, "SHA256WithRSA");
            }
            logger.error((Object)"not support signType.");
            throw new IcbcApiException("not support signType.");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("get content charset exception. content: " + content + " charset: " + charset), (Throwable)e);
            throw new IcbcApiException("get content charset exception. content: " + content + " charset: " + charset, e);
        }
        catch (Exception e) {
            logger.error((Object)"sign verify exception.", (Throwable)e);
            throw new IcbcApiException("sign verify exception.", e);
        }
    }
}

