/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.rsa.util;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class RsaEncodeUtil {
    private static final String KEY_ALGORITHM = "RSA";
    private static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static Random random = new Random();

    public static Map<String, String> generateRSAKeys() throws NoSuchAlgorithmException {
        HashMap<String, String> map = new HashMap<String, String>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(1024);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        byte[] pk = publicKey.getEncoded();
        byte[] privk = privateKey.getEncoded();
        String strpk = new String(Base64.encodeBase64((byte[])pk));
        String strprivk = new String(Base64.encodeBase64((byte[])privk));
        map.put("public", strpk);
        map.put("private", strprivk);
        return map;
    }

    public static Map<String, String> generateRSAKeysForWopay() throws NoSuchAlgorithmException {
        HashMap<String, String> map = new HashMap<String, String>();
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGen.initialize(2048);
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        byte[] pk = publicKey.getEncoded();
        byte[] privk = privateKey.getEncoded();
        String strpk = new String(Base64.encodeBase64((byte[])pk));
        String strprivk = new String(Base64.encodeBase64((byte[])privk));
        map.put("public", strpk);
        map.put("private", strprivk);
        return map;
    }

    public static PublicKey restorePublicKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base64.decodeBase64((String)key));
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        PublicKey publicKey = factory.generatePublic(x509EncodedKeySpec);
        return publicKey;
    }

    public static PrivateKey restorePrivateKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)key));
        KeyFactory factory = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey privateKey = factory.generatePrivate(pkcs8EncodedKeySpec);
        return privateKey;
    }

    public static byte[] rsaPublicEncode(PublicKey key, byte[] encodeData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, key);
        int inputLen = encodeData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(encodeData, offSet, 117) : cipher.doFinal(encodeData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] decryptedData = out.toByteArray();
        return decryptedData;
    }

    public static byte[] rsaPrivateEncode(PrivateKey key, byte[] encodeData) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(1, key);
        int inputLen = encodeData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(encodeData, offSet, 117) : cipher.doFinal(encodeData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 117;
        }
        byte[] decryptedData = out.toByteArray();
        return decryptedData;
    }

    public static byte[] rsaPrivateDecode(PrivateKey key, byte[] encryptedData) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, key);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static byte[] rsaPublicDecode(PublicKey key, byte[] encryptedData) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, IOException {
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, key);
        int inputLen = encryptedData.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = 0;
        int i = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(encryptedData, offSet, 128) : cipher.doFinal(encryptedData, offSet, inputLen - offSet);
            out.write(cache, 0, cache.length);
            offSet = ++i * 128;
        }
        byte[] decryptedData = out.toByteArray();
        out.close();
        return decryptedData;
    }

    public static String sha1Sign(Map<String, Object> map, String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("".equals(entry.getValue()) || entry.getValue().toString().startsWith("{\"") && entry.getValue().toString().endsWith("\"}") || entry.getValue().toString().startsWith("[{\"") && entry.getValue().toString().endsWith("\"}]")) continue;
            list.add(entry.getKey() + "=" + entry.getValue() + "&");
        }
        int size = list.size();
        String[] arrayToSort = list.toArray(new String[size]);
        Arrays.sort(arrayToSort, String.CASE_INSENSITIVE_ORDER);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(arrayToSort[i]);
        }
        String result = sb.toString();
        result = result + "key=" + key;
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        digest.update(result.getBytes("UTF-8"));
        byte[] messageDigest = digest.digest();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexString.append(0);
            }
            hexString.append(shaHex);
        }
        return hexString.toString().toUpperCase();
    }

    public static String sha1Sign(String data, String privateKey) throws Exception {
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKey));
        KeyFactory keyf = KeyFactory.getInstance(KEY_ALGORITHM);
        PrivateKey priKey = keyf.generatePrivate(priPKCS8);
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initSign(priKey);
        signature.update(data.getBytes("GBK"));
        byte[] messageDigest = signature.sign();
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < messageDigest.length; ++i) {
            String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexString.append(0);
            }
            hexString.append(shaHex);
        }
        return hexString.toString().toUpperCase();
    }

    public static String getRandomStringByLength(int length) {
        String base = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static Map<String, Object> getMapFromXML(String xmlString) throws ParserConfigurationException, IOException, DocumentException {
        if (!xmlString.startsWith("<xml")) {
            xmlString = "<xml>" + xmlString + "</xml>";
        }
        Document document = DocumentHelper.parseText((String)xmlString);
        Element root = document.getRootElement();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator rootItor = root.elementIterator();
        while (rootItor.hasNext()) {
            Element tmpElement = (Element)rootItor.next();
            String name = tmpElement.getName();
            String text = tmpElement.getTextTrim();
            map.put(name, text);
        }
        return map;
    }

    public static InputStream getStringStream(String sInputString) throws UnsupportedEncodingException {
        ByteArrayInputStream tInputStringStream = null;
        if (sInputString != null && !sInputString.trim().equals("")) {
            tInputStringStream = new ByteArrayInputStream(sInputString.getBytes("UTF-8"));
        }
        return tInputStringStream;
    }

    public static String getXmlFromMap(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String key : map.keySet()) {
            builder.append("<" + key + "><![CDATA[" + map.get(key) + "]]>" + "</" + key + ">");
        }
        return builder.toString();
    }

    public static Map<String, Object> getMapFromJson(String json) {
        return RsaEncodeUtil.getMapFromJsonByFastJson(json);
    }

    public static String getJsonFromMap(Map<String, Object> map) {
        return RsaEncodeUtil.getJsonFromMapByFastJson(map);
    }

    private static String getJsonFromMapByFastJson(Map<String, Object> map) {
        return JSONObject.toJSONString(map);
    }

    private static Map<String, Object> getMapFromJsonByFastJson(String json) {
        return (Map)JSONObject.parseObject((String)json, Map.class);
    }
}

