/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.controller.notify;

import com.tydic.payment.pay.comb.PayProProcessNoticeCombService;
import com.tydic.payment.pay.comb.PayProProcessRefundNotifyCombService;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProProcessNoticeCombRspBo;
import com.tydic.payment.pay.comb.bo.PayProProcessRefundNotifyCombReqBo;
import com.tydic.payment.pay.comb.bo.PayProProcessRefundNotifyCombRspBo;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay/rest"})
public class PayProCnncNotifyController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PayProProcessNoticeCombService payProProcessNoticeCombService;
    @Autowired
    private PayProProcessRefundNotifyCombService payProProcessRefundNotifyCombService;
    @Value(value="${project_name:PayCN}")
    private String projectName;

    @RequestMapping(value={"/dealCnncIssNotify"}, method={RequestMethod.POST})
    @ResponseBody
    public void dealCnncIssNotify(HttpServletRequest request, HttpServletResponse response) {
        this.LOGGER.info("====================================CNNC\u8d22\u4f01\u901a\u56de\u8c03====================================");
        try {
            String resultStr;
            String respCode;
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            if (null != request) {
                Set paramsKey = request.getParameterMap().keySet();
                for (String key : paramsKey) {
                    String value = URLDecoder.decode(request.getParameter(key), "GBK");
                    paramMap.put(key, value);
                }
            }
            String notifyInfo = (String)paramMap.get("_USER_REQUEST_DATA");
            this.LOGGER.info("CNNC\u8d22\u4f01\u901a\u56de\u8c03\u4fe1\u606f\uff1a" + notifyInfo);
            String refundOrderIdPrefix = this.projectName + 'R';
            String realPayOrderIdPrefix = this.projectName + 'T';
            if (notifyInfo.contains(refundOrderIdPrefix)) {
                this.LOGGER.info("=========\u672c\u6b21\u8d22\u4f01\u901a\u7684\u56de\u8c03\u7c7b\u578b\u4e3a:\u9000\u6b3e\u6307\u4ee4\u56de\u8c03=========");
                PayProProcessRefundNotifyCombReqBo refundNotifyCombReqBo = new PayProProcessRefundNotifyCombReqBo();
                refundNotifyCombReqBo.setPayMethod(Long.valueOf(160L));
                refundNotifyCombReqBo.setContent(notifyInfo);
                PayProProcessRefundNotifyCombRspBo refundNotifyCombRetBo = this.payProProcessRefundNotifyCombService.processNotice(refundNotifyCombReqBo);
                respCode = refundNotifyCombRetBo.getRespCode();
                resultStr = refundNotifyCombRetBo.getResult();
                this.LOGGER.info("\u5904\u7406CNNC\u8d22\u4f01\u901a\u9000\u6b3e\u6307\u4ee4\u56de\u8c03\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)respCode);
                this.LOGGER.info("CNNC\u8d22\u4f01\u901a\u56de\u8c03\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a{}", (Object)resultStr);
            } else if (notifyInfo.contains(realPayOrderIdPrefix)) {
                this.LOGGER.info("=========\u672c\u6b21\u8d22\u4f01\u901a\u7684\u56de\u8c03\u7c7b\u578b\u4e3a\uff1a\u5b9e\u4ed8\u6307\u4ee4\u56de\u8c03=========");
                PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
                noticeCombBo.setPayMethod(Long.valueOf(161L));
                noticeCombBo.setReqData(notifyInfo);
                PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
                respCode = noticeRetBo.getRespCode();
                resultStr = noticeRetBo.getResult();
                this.LOGGER.info("\u5904\u7406CNNC\u8d22\u4f01\u901a\u652f\u4ed8\u6307\u4ee4\u56de\u8c03\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)respCode);
                this.LOGGER.info("CNNC\u8d22\u4f01\u901a\u56de\u8c03\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a{}", (Object)resultStr);
            } else {
                this.LOGGER.info("=========\u672c\u6b21\u8d22\u4f01\u901a\u7684\u56de\u8c03\u7c7b\u578b\u4e3a\uff1a\u652f\u4ed8\u6307\u4ee4\u56de\u8c03=========");
                PayProProcessNoticeCombReqBo noticeCombBo = new PayProProcessNoticeCombReqBo();
                noticeCombBo.setPayMethod(Long.valueOf(160L));
                noticeCombBo.setReqData(notifyInfo);
                PayProProcessNoticeCombRspBo noticeRetBo = this.payProProcessNoticeCombService.processNotice(noticeCombBo);
                respCode = noticeRetBo.getRespCode();
                resultStr = noticeRetBo.getResult();
                this.LOGGER.info("\u5904\u7406CNNC\u8d22\u4f01\u901a\u652f\u4ed8\u6307\u4ee4\u56de\u8c03\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)respCode);
                this.LOGGER.info("CNNC\u8d22\u4f01\u901a\u56de\u8c03\u7684\u54cd\u5e94\u62a5\u6587\u4e3a\uff1a{}", (Object)resultStr);
            }
            if ("0000".equals(respCode)) {
                response.setStatus(HttpStatus.OK.value());
                response.getWriter().write(resultStr);
            } else {
                response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
            }
            response.setCharacterEncoding("GBK");
            this.LOGGER.info("====================================CNNC\u8d22\u4f01\u901a\u5904\u7406\u7ed3\u675f====================================");
        }
        catch (Exception e) {
            this.LOGGER.error("CNNC\u8d22\u4f01\u901a\u56de\u8c03\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff1a" + e);
        }
    }
}

