/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.authority.service.domainservice.AuthCreateLoginLogService;
import com.tydic.dyc.authority.service.user.AuthGetLoginCustListService;
import com.tydic.dyc.authority.service.user.AuthGetUserInfoListService;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.service.LoginTimeServcie;
import com.tydic.umc.security.service.bo.LoginExpTimeReqBO;
import com.tydic.umc.security.service.bo.LoginExpTimeRspBO;
import com.tydic.umc.security.utils.LoginPasswordUtils;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LoginTimeServcieImpl
implements LoginTimeServcie {
    private static final Logger log = LoggerFactory.getLogger(LoginTimeServcieImpl.class);
    @Value(value="${login.vfType:1}")
    private String vfType;
    @Value(value="${login.defaultVfFlag:true}")
    private Boolean defaultVfFlag;
    @Value(value="${login.defaultVfCode:1111}")
    private String defaultVfCode;
    @Value(value="${login.loginNum:3}")
    private Integer loginNum;
    @Value(value="${login.lockTime:86400}")
    private int loginLockTime;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.refreshTime:10}")
    private int refreshTime;
    @Value(value="${login.uniqueLoginFlag:false}")
    private Boolean uniqueLoginFlag;
    private static final int OFFSET = 4;
    @Autowired
    private LoginPasswordUtils passwordUtils;
    @Autowired
    private CacheClient cacheService;
    @Autowired
    private AuthGetLoginCustListService authGetLoginCustListService;
    @Autowired
    private AuthGetUserInfoListService authGetUserInfoListService;
    @Autowired
    private AuthCreateLoginLogService authCreateLoginLogService;

    @Override
    public LoginExpTimeRspBO getLoginExpTime(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        rspBO.setExpTime((Long)this.cacheService.get(reqBO.getToken() + "LoginExpTime"));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public LoginExpTimeRspBO updateLoginExpTime(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        Long newExpTime = System.currentTimeMillis() + (long)(this.expTime * 1000);
        Long expDate = (Long)this.cacheService.get(reqBO.getToken() + "LoginExpTime");
        if (expDate == null) {
            expDate = 0L;
        }
        log.debug("\u5230\u671f\u65f6\u95f4{},\u65b0\u5230\u671f\u65f6\u95f4{}", (Object)expDate, (Object)newExpTime);
        long diff = (newExpTime - expDate) / 1000L / 60L;
        if (diff > (long)this.refreshTime) {
            this.cacheService.set(reqBO.getToken() + "LoginExpTime", (Object)newExpTime, this.expTime);
            this.cacheService.set("USER_ID_TOKEN_PREFIX_" + reqBO.getUserId() + reqBO.getToken(), (Object)reqBO.getToken(), this.expTime);
            this.cacheService.expire(reqBO.getToken(), this.expTime);
            if (this.uniqueLoginFlag.booleanValue()) {
                String uniqueLoginStr = "UniqueLogin_" + reqBO.getLoginSource() + "_" + reqBO.getUserId();
                this.cacheService.set(uniqueLoginStr, (Object)reqBO.getToken(), this.expTime);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setExpTime((long)this.expTime * 1000L);
        return rspBO;
    }

    @Override
    public LoginExpTimeRspBO logOut(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        this.cacheService.delete(reqBO.getToken() + "LoginExpTime");
        this.cacheService.delete(reqBO.getToken() + "loginSource");
        String tokenMsg = (String)this.cacheService.get(reqBO.getToken());
        UmcMemInfoBO umcMemInfoBO = (UmcMemInfoBO)JSONObject.parseObject((String)tokenMsg, UmcMemInfoBO.class);
        log.debug("umcMemInfoBO:{}", (Object)JSON.toJSONString((Object)umcMemInfoBO));
        if (null != umcMemInfoBO && null != umcMemInfoBO.getUserId()) {
            this.cacheService.delete("USER_ID_TOKEN_PREFIX_" + umcMemInfoBO.getUserId() + reqBO.getToken());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public LoginExpTimeRspBO uniqueLogin(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        if (reqBO.getUserId() != null && this.uniqueLoginFlag.booleanValue()) {
            String uniqueLoginStr = "UniqueLogin_" + reqBO.getLoginSource() + "_" + reqBO.getUserId();
            String token = (String)this.cacheService.get(uniqueLoginStr);
            if (!StringUtils.isEmpty((Object)token) && !token.equals(reqBO.getToken())) {
                this.cacheService.delete(token + "LoginExpTime");
            }
            this.cacheService.set(uniqueLoginStr, (Object)reqBO.getToken(), this.expTime);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public LoginExpTimeRspBO userOffline(LoginExpTimeReqBO reqBO) {
        LoginExpTimeRspBO rspBO = new LoginExpTimeRspBO();
        if (null != reqBO.getUserId()) {
            Set tokens = this.cacheService.getkeys("USER_ID_TOKEN_PREFIX_" + reqBO.getUserId() + "*");
            tokens.forEach(token -> {
                LoginExpTimeReqBO logOutReqBo = new LoginExpTimeReqBO();
                logOutReqBo.setToken((String)token);
                this.logOut(logOutReqBo);
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

