/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.base.utils;

import com.tydic.umc.security.utils.EncryptUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PasswordUtils {
    private static final Logger log = LoggerFactory.getLogger(PasswordUtils.class);
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Autowired
    private EncryptUtils encryptUtils;

    public boolean verifyPassword(String passwordIn, String passwordDb, String salt) {
        if (this.encryptType.equals("SM2") || this.encryptType.equals("SM4ECB") || this.encryptType.equals("SM4CBC")) {
            String decryptFirst = this.encryptUtils.decryptByType(passwordDb, this.encryptType);
            log.info("\u7b2c\u4e00\u6b21\u89e3\u5bc6\uff1a" + decryptFirst);
            decryptFirst.substring(0, decryptFirst.length() - salt.length());
            log.info("\u53bb\u6389\u76d0\u503c\uff1a" + decryptFirst.substring(0, decryptFirst.length() - salt.length()));
            String decryptSecond = this.encryptUtils.decryptByType(decryptFirst.substring(0, decryptFirst.length() - salt.length()), "SM2");
            log.info("\u7b2c\u4e8c\u6b21\u89e3\u5bc6\uff1adecryptSecond = {},password = {}", (Object)decryptSecond, (Object)passwordIn);
            if (passwordDb != null && decryptSecond.equals(passwordIn)) {
                log.info("\u5339\u914d\u6210\u529f", (Object)decryptSecond, (Object)passwordIn);
                return true;
            }
            return false;
        }
        String inputPwd = this.encryptUtils.encryptByType(passwordIn, this.encryptType);
        log.info("\u7b2c\u4e00\u6b21\u52a0\u5bc6\uff1a" + inputPwd);
        log.debug("\u83b7\u53d6\u52a0\u5bc6\u76d0\uff1a" + salt);
        log.debug("inputPwd + salt\uff1a" + inputPwd + salt);
        String digPwd = inputPwd + salt;
        log.debug("digPwd:" + digPwd);
        String encrypt = this.encryptUtils.encryptByType(digPwd, this.encryptType);
        log.info("\u7b2c\u4e8c\u6b21\u52a0\u5bc6\uff1a" + encrypt);
        return passwordDb != null && encrypt.equals(passwordDb);
    }

    public String buildPassword(String passwordIn, String salt) {
        String inputPwd = this.encryptUtils.encryptByType(passwordIn, this.encryptType);
        log.info("\u7b2c\u4e00\u6b21\u52a0\u5bc6\uff1a" + inputPwd);
        log.debug("\u83b7\u53d6\u52a0\u5bc6\u76d0\uff1a" + salt);
        log.debug("inputPwd + salt\uff1a" + inputPwd + salt);
        String digPwd = inputPwd + salt;
        log.debug("digPwd:" + digPwd);
        String encrypt = this.encryptUtils.encryptByType(digPwd, this.encryptType);
        log.info("\u7b2c\u4e8c\u6b21\u52a0\u5bc6\uff1a" + encrypt);
        return encrypt;
    }
}

