/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.order.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.order.api.DycUocOrderPayFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocOrderPayFunctionReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocOrderPayFunctionRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.fsc.common.ability.api.FscCreditDeductAbilityService;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscCreditDeductOrderInfo;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocOrderPayFunctionImpl
implements DycUocOrderPayFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderPayFunctionImpl.class);
    @Autowired
    private FscCreditDeductAbilityService fscCreditDeductAbilityService;
    @Value(value="${uoc.deduct.credit.enable:true}")
    private boolean creditEnable;

    @Override
    public DycUocOrderPayFunctionRspBO orderPay(DycUocOrderPayFunctionReqBO reqBO) {
        this.verifyParam(reqBO);
        if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(Integer.valueOf(reqBO.getPayType())) && this.creditEnable) {
            FscCreditDeductAbilityReqBO fscCreditDeductAbilityReqBO = new FscCreditDeductAbilityReqBO();
            fscCreditDeductAbilityReqBO.setAmount(reqBO.getPayFee());
            fscCreditDeductAbilityReqBO.setCreditOrgId(reqBO.getCreditOrgId());
            fscCreditDeductAbilityReqBO.setSupId(Long.valueOf(reqBO.getSupplierId()));
            ArrayList<FscCreditDeductOrderInfo> fscCreditDeductOrderInfos = new ArrayList<FscCreditDeductOrderInfo>();
            FscCreditDeductOrderInfo fscCreditDeductOrderInfo = new FscCreditDeductOrderInfo();
            fscCreditDeductOrderInfo.setOrderId(reqBO.getOrderId().longValue());
            fscCreditDeductOrderInfos.add(fscCreditDeductOrderInfo);
            fscCreditDeductAbilityReqBO.setOrderInfoList(fscCreditDeductOrderInfos);
            FscCreditDeductAbilityRspBO fscCreditDeductAbilityRspBO = this.fscCreditDeductAbilityService.dealAccountDeduct(fscCreditDeductAbilityReqBO);
            if (!"0000".equals(fscCreditDeductAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u6388\u4fe1\u6263\u51cf\u5931\u8d25\uff1a" + fscCreditDeductAbilityRspBO.getRespDesc());
            }
        }
        DycUocOrderPayFunctionRspBO rspBO = new DycUocOrderPayFunctionRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u8ba2\u5355\u652f\u4ed8\u6210\u529f");
        return rspBO;
    }

    private void verifyParam(DycUocOrderPayFunctionReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getCreditOrgId()) {
            throw new ZTBusinessException("\u91c7\u8d2d\u5355\u4f4did\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayFee()) {
            throw new ZTBusinessException("\u652f\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getPayType())) {
            throw new ZTBusinessException("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

