/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.order.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.order.api.DycUocRefundPayFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocRefundPayFunctionRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocGetAfOrderDetailService;
import com.tydic.dyc.oc.service.domainservice.UocQryShipOrderDetailsService;
import com.tydic.dyc.oc.service.domainservice.UocQryShouldPayOrderListService;
import com.tydic.dyc.oc.service.domainservice.UocSaleOrderPayConfQryService;
import com.tydic.dyc.oc.service.domainservice.UocSaleOrderStakeholderQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfOrderCommodityItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetAfOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShipOrderDetailsRspDetailItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShouldPayOrderListServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryShouldPayOrderListServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderPayConfQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderPayConfQryServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderPayConfQryServiceRspConfBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderStakeholderQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderStakeholderQryServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayOrderBo;
import com.tydic.dyc.oc.service.order.UocQryOrderProcessInstanceListService;
import com.tydic.dyc.oc.service.order.bo.UocGetOrderTheProcessInstanceServiceRspProcInsBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderProcessInstanceListServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOrderProcessInstanceListServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderSingleQryService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderSingleQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderSingleQryServiceRspBo;
import com.tydic.fsc.pay.ability.api.FscCreatePayBackAbilityService;
import com.tydic.fsc.pay.ability.bo.FscCreatePayBackAbilityServiceReqBO;
import com.tydic.fsc.pay.ability.bo.FscCreatePayBackAbilityServiceRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycUocRefundPayFunctionImpl
implements DycUocRefundPayFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocRefundPayFunctionImpl.class);
    public static final String EC_DQRFK = "E0004";
    public static final String AGR_DQRFK = "A0007";
    public static final String NO_AGR_DQRFK = "N0005";
    @Autowired
    private UocSaleOrderPayConfQryService uocSaleOrderPayConfQryService;
    @Autowired
    private UocSaleOrderStakeholderQryService uocSaleOrderStakeholderQryService;
    @Autowired
    private UocQryShouldPayOrderListService uocQryShouldPayOrderListService;
    @Autowired
    private UocQryOrderProcessInstanceListService uocQryOrderProcessInstanceListService;
    @Autowired
    private FscCreatePayBackAbilityService fscCreatePayBackAbilityService;
    @Autowired
    private UocSaleOrderSingleQryService uocSaleOrderSingleQryService;
    @Autowired
    private UocQryShipOrderDetailsService uocQryShipOrderDetailsService;
    @Autowired
    private UocGetAfOrderDetailService uocGetAfOrderDetailService;

    @Override
    public DycUocRefundPayFunctionRspBO refundPay(DycUocRefundPayFunctionReqBO reqBO) {
        DycUocRefundPayFunctionRspBO rspBO = new DycUocRefundPayFunctionRspBO();
        this.verifyParam(reqBO);
        switch (reqBO.getReturnNode()) {
            case "1": {
                this.doCancelReturn(reqBO);
                break;
            }
            case "2": {
                this.doCancelApplyReturn(reqBO);
                break;
            }
            case "3": {
                this.doRejectReturn(reqBO);
                break;
            }
            case "4": {
                this.doGoodsReturn(reqBO);
                break;
            }
            default: {
                throw new ZTBusinessException("\u672a\u77e5\u7684\u56de\u9000\u8282\u70b9\uff01");
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void doGoodsReturn(DycUocRefundPayFunctionReqBO reqBO) {
        UocGetAfOrderDetailServiceReqBo uocGetAfOrderDetailServiceReqBo = new UocGetAfOrderDetailServiceReqBo();
        uocGetAfOrderDetailServiceReqBo.setAfOrderId(reqBO.getAfOrderId());
        uocGetAfOrderDetailServiceReqBo.setOrderId(reqBO.getOrderId());
        UocGetAfOrderDetailServiceRspBo uocGetAfOrderDetailServiceRspBo = this.uocGetAfOrderDetailService.qryAfOrderDetails(uocGetAfOrderDetailServiceReqBo);
        if (null == uocGetAfOrderDetailServiceRspBo.getServInfo() || CollectionUtils.isEmpty((Collection)uocGetAfOrderDetailServiceRspBo.getCommodityInfo())) {
            throw new ZTBusinessException("\u67e5\u8be2\u9a8c\u6536\u5355\u8be6\u60c5\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getSaleOrderId()) {
            reqBO.setSaleOrderId(((UocAfOrderCommodityItemBo)uocGetAfOrderDetailServiceRspBo.getCommodityInfo().get(0)).getSaleOrderId());
        }
        UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo = this.qrySaleOrderInfo(reqBO);
        if (!UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(uocGetAfOrderDetailServiceRspBo.getServInfo().getServType())) {
            return;
        }
        UocSaleOrderPayConfQryServiceRspConfBo uocSaleOrderPayConfQryServiceRspConfBo = this.getPurSalePayConf(reqBO);
        if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType())) {
            Map<Long, List<UocAfOrderCommodityItemBo>> afCommodityByShipMap = uocGetAfOrderDetailServiceRspBo.getCommodityInfo().stream().collect(Collectors.groupingBy(UocAfOrderCommodityItemBo::getShipOrderId));
            for (Map.Entry<Long, List<UocAfOrderCommodityItemBo>> entry : afCommodityByShipMap.entrySet()) {
                reqBO.setPayBackAmount(entry.getValue().stream().map(UocAfOrderCommodityItemBo::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
                UocShouldPayOrderBo uocShouldPayOrderBo = this.doQryShouldPay(reqBO.getOrderId(), entry.getKey(), uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId(), UocDicConstant.PAY_TYPE.PAY_BY_PERIOD, UocDicConstant.OBJ_TYPE.SHIP);
                this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.PAY_BY_PERIOD, uocShouldPayOrderBo.getFscShouldPayId(), uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, reqBO.getAfOrderId(), 3);
            }
        } else if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType())) {
            reqBO.setPayBackAmount(uocGetAfOrderDetailServiceRspBo.getCommodityInfo().stream().map(UocAfOrderCommodityItemBo::getRetSaleFee).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
            UocShouldPayOrderBo uocShouldPayOrderBo = this.doQryShouldPay(reqBO.getOrderId(), reqBO.getSaleOrderId(), uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId(), UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, UocDicConstant.OBJ_TYPE.SALE);
            this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, uocShouldPayOrderBo.getFscShouldPayId(), uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, reqBO.getAfOrderId(), 3);
        }
    }

    private void doRejectReturn(DycUocRefundPayFunctionReqBO reqBO) {
        UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo = this.qrySaleOrderInfo(reqBO);
        for (Long shipOrderId : reqBO.getShipOrderIds()) {
            UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo;
            UocQryShipOrderDetailsReqBo uocQryShipOrderDetailsReqBo = new UocQryShipOrderDetailsReqBo();
            uocQryShipOrderDetailsReqBo.setOrderId(reqBO.getOrderId());
            uocQryShipOrderDetailsReqBo.setShipOrderId(shipOrderId);
            UocQryShipOrderDetailsRspBo uocQryShipOrderDetailsRspBo = this.uocQryShipOrderDetailsService.qryShipOrderDetails(uocQryShipOrderDetailsReqBo);
            BigDecimal shipPayBackAmount = new BigDecimal(0);
            for (UocQryShipOrderDetailsRspDetailItemBo bo2 : uocQryShipOrderDetailsRspBo.getShipOrderInfo().getShipOrderItemBoList()) {
                shipPayBackAmount = shipPayBackAmount.add(bo2.getRefuseCount().multiply(bo2.getSalePrice()));
            }
            reqBO.setPayBackAmount(shipPayBackAmount);
            UocSaleOrderPayConfQryServiceRspConfBo uocSaleOrderPayConfQryServiceRspConfBo = this.getPurSalePayConf(reqBO);
            if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType())) {
                uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
                this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.PAY_BY_PERIOD, null, uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, null, null);
                continue;
            }
            if (!UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType())) continue;
            uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
            UocShouldPayOrderBo uocShouldPayOrderBo = this.doQryShouldPay(reqBO.getOrderId(), reqBO.getSaleOrderId(), uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId(), UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, UocDicConstant.OBJ_TYPE.SALE);
            this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, uocShouldPayOrderBo.getFscShouldPayId(), uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, shipOrderId, 2);
        }
    }

    private void doCancelApplyReturn(DycUocRefundPayFunctionReqBO reqBO) {
        UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo = this.qrySaleOrderInfo(reqBO);
        reqBO.setPayBackAmount(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getTotalSaleFee());
        UocSaleOrderPayConfQryServiceRspConfBo uocSaleOrderPayConfQryServiceRspConfBo = this.getPurSalePayConf(reqBO);
        if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType())) {
            UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
            this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.PAY_BY_PERIOD, null, uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, null, null);
        } else if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType())) {
            UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
            UocShouldPayOrderBo uocShouldPayOrderBo = this.doQryShouldPay(reqBO.getOrderId(), reqBO.getSaleOrderId(), uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId(), UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, UocDicConstant.OBJ_TYPE.SALE);
            this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, uocShouldPayOrderBo.getFscShouldPayId(), uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, reqBO.getSaleOrderId(), 1);
        }
    }

    private void doCancelReturn(DycUocRefundPayFunctionReqBO reqBO) {
        UocGetOrderTheProcessInstanceServiceRspProcInsBo nowSaleOrderTaskProc;
        UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo = this.qrySaleOrderInfo(reqBO);
        reqBO.setPayBackAmount(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getTotalSaleFee());
        UocSaleOrderPayConfQryServiceRspConfBo uocSaleOrderPayConfQryServiceRspConfBo = this.getPurSalePayConf(reqBO);
        if (!UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType()) && UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(uocSaleOrderPayConfQryServiceRspConfBo.getPayType()) && (EC_DQRFK.equals((nowSaleOrderTaskProc = this.getTaskProc(reqBO)).getProcState()) || AGR_DQRFK.equals(nowSaleOrderTaskProc.getProcState()) || NO_AGR_DQRFK.equals(nowSaleOrderTaskProc.getProcState()))) {
            reqBO.setPayBackAmount(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getTotalSaleFee());
            UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo = this.doQryThirdInfo(reqBO, uocSaleOrderSingleQryServiceRspBo);
            UocShouldPayOrderBo uocShouldPayOrderBo = this.doQryShouldPay(reqBO.getOrderId(), reqBO.getSaleOrderId(), uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId(), UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, UocDicConstant.OBJ_TYPE.SALE);
            this.doDealPayBack(reqBO, UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED, uocShouldPayOrderBo.getFscShouldPayId(), uocSaleOrderPayConfQryServiceRspConfBo, uocSaleOrderStakeholderQryServiceRspBo, uocSaleOrderSingleQryServiceRspBo, null, null);
        }
    }

    private UocSaleOrderSingleQryServiceRspBo qrySaleOrderInfo(DycUocRefundPayFunctionReqBO reqBO) {
        UocSaleOrderSingleQryServiceReqBo uocSaleOrderSingleQryServiceReqBo = new UocSaleOrderSingleQryServiceReqBo();
        uocSaleOrderSingleQryServiceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
        uocSaleOrderSingleQryServiceReqBo.setOrderId(reqBO.getOrderId());
        UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo = this.uocSaleOrderSingleQryService.qrySaleOrder(uocSaleOrderSingleQryServiceReqBo);
        if (!"0000".equals(uocSaleOrderSingleQryServiceRspBo.getRespCode()) || null == uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo()) {
            throw new ZTBusinessException("\u8be5\u9500\u552e\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        return uocSaleOrderSingleQryServiceRspBo;
    }

    private void doDealPayBack(DycUocRefundPayFunctionReqBO reqBO, Integer payType, Long shouldPayId, UocSaleOrderPayConfQryServiceRspConfBo uocSaleOrderPayConfQryServiceRspConfBo, UocSaleOrderStakeholderQryServiceRspBo uocSaleOrderStakeholderQryServiceRspBo, UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo, Long refundObjId, Integer refundObjType) {
        FscCreatePayBackAbilityServiceReqBO fscCreatePayBackAbilityServiceReqBO = new FscCreatePayBackAbilityServiceReqBO();
        fscCreatePayBackAbilityServiceReqBO.setPayType(payType);
        fscCreatePayBackAbilityServiceReqBO.setShouldPayId(shouldPayId);
        fscCreatePayBackAbilityServiceReqBO.setSaleOrderId(reqBO.getSaleOrderId());
        fscCreatePayBackAbilityServiceReqBO.setSaleOrderNo(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getSaleOrderNo());
        fscCreatePayBackAbilityServiceReqBO.setPayNodeRule(uocSaleOrderPayConfQryServiceRspConfBo.getPayNodeRule());
        fscCreatePayBackAbilityServiceReqBO.setPayRule(uocSaleOrderPayConfQryServiceRspConfBo.getPayRule());
        fscCreatePayBackAbilityServiceReqBO.setPayAccountDayRule(uocSaleOrderPayConfQryServiceRspConfBo.getPayAccountDayRule());
        fscCreatePayBackAbilityServiceReqBO.setPayBackAmount(reqBO.getPayBackAmount());
        if (UocDicConstant.MODEL_SETTLE.MATCH.equals(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getModelSettle())) {
            if (null != uocSaleOrderStakeholderQryServiceRspBo.getSupId()) {
                fscCreatePayBackAbilityServiceReqBO.setPayBackOrgId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getSupId()));
            }
        } else if (UocDicConstant.MODEL_SETTLE.TRADE.equals(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getModelSettle()) && null != uocSaleOrderStakeholderQryServiceRspBo.getProId()) {
            fscCreatePayBackAbilityServiceReqBO.setPayBackOrgId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getProId()));
        }
        if (null != uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId()) {
            fscCreatePayBackAbilityServiceReqBO.setReceiverOrgId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId()));
        }
        if (null != uocSaleOrderStakeholderQryServiceRspBo.getPurUserId()) {
            fscCreatePayBackAbilityServiceReqBO.setCreateOperId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getPurUserId()));
        }
        fscCreatePayBackAbilityServiceReqBO.setCreateOperName(uocSaleOrderStakeholderQryServiceRspBo.getPurName());
        if (null != uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId()) {
            fscCreatePayBackAbilityServiceReqBO.setCreateOrgId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getPurOrgId()));
        }
        fscCreatePayBackAbilityServiceReqBO.setCreateOrgName(uocSaleOrderStakeholderQryServiceRspBo.getPurOrgName());
        if (null != uocSaleOrderStakeholderQryServiceRspBo.getPurCompanyId()) {
            fscCreatePayBackAbilityServiceReqBO.setCreateCompanyId(Long.valueOf(uocSaleOrderStakeholderQryServiceRspBo.getPurCompanyId()));
        }
        fscCreatePayBackAbilityServiceReqBO.setCreateCompanyName(uocSaleOrderStakeholderQryServiceRspBo.getPurCompanyName());
        fscCreatePayBackAbilityServiceReqBO.setRefundObjId(refundObjId);
        fscCreatePayBackAbilityServiceReqBO.setRefundObjType(refundObjType);
        log.debug("\u8c03\u7528\u7ed3\u7b97\u9000\u6b3e\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)fscCreatePayBackAbilityServiceReqBO));
        FscCreatePayBackAbilityServiceRspBO fscCreatePayBackAbilityServiceRspBO = this.fscCreatePayBackAbilityService.dealPayBack(fscCreatePayBackAbilityServiceReqBO);
        log.debug("\u8c03\u7528\u7ed3\u7b97\u9000\u6b3e\u63a5\u53e3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)fscCreatePayBackAbilityServiceRspBO));
        if (!"0000".equals(fscCreatePayBackAbilityServiceRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u7ed3\u7b97\u7684\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff1a" + fscCreatePayBackAbilityServiceRspBO.getRespDesc());
        }
    }

    private UocShouldPayOrderBo doQryShouldPay(Long orderId, Long objectId, String purOrgId, Integer payType, Integer objectType) {
        UocQryShouldPayOrderListServiceReqBo uocQryShouldPayOrderListServiceReqBo = new UocQryShouldPayOrderListServiceReqBo();
        uocQryShouldPayOrderListServiceReqBo.setOrderId(orderId);
        uocQryShouldPayOrderListServiceReqBo.setObjectId(objectId);
        uocQryShouldPayOrderListServiceReqBo.setObjectType(objectType);
        UocQryShouldPayOrderListServiceRspBo uocQryShouldPayOrderListServiceRspBo = this.uocQryShouldPayOrderListService.qryShouldPayOrderList(uocQryShouldPayOrderListServiceReqBo);
        if (!CollectionUtils.isEmpty((Collection)uocQryShouldPayOrderListServiceRspBo.getShouldPayOrderList())) {
            List shouldPayOrderList = uocQryShouldPayOrderListServiceRspBo.getShouldPayOrderList().stream().filter(bo -> purOrgId.equals(bo.getPayerId().toString())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(shouldPayOrderList)) {
                if (UocDicConstant.PAY_TYPE.PAY_BY_PERIOD.equals(payType)) {
                    return new UocShouldPayOrderBo();
                }
                throw new ZTBusinessException("\u91c7\u8d2d\u65b9\u9500\u552e\u5355\u5e94\u4ed8\u5355\u4e3a\u7a7a\uff01");
            }
            if (shouldPayOrderList.size() != 1) {
                throw new ZTBusinessException("\u91c7\u8d2d\u65b9\u9500\u552e\u5355\u5e94\u4ed8\u5355\u5b58\u5728\u591a\u6761\uff01");
            }
            return (UocShouldPayOrderBo)shouldPayOrderList.get(0);
        }
        return new UocShouldPayOrderBo();
    }

    private UocGetOrderTheProcessInstanceServiceRspProcInsBo getTaskProc(DycUocRefundPayFunctionReqBO reqBO) {
        UocQryOrderProcessInstanceListServiceReqBo uocQryOrderProcessInstanceListServiceReqBo = new UocQryOrderProcessInstanceListServiceReqBo();
        uocQryOrderProcessInstanceListServiceReqBo.setOrderId(reqBO.getOrderId());
        uocQryOrderProcessInstanceListServiceReqBo.setObjId(reqBO.getSaleOrderId().toString());
        uocQryOrderProcessInstanceListServiceReqBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocQryOrderProcessInstanceListServiceReqBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        UocQryOrderProcessInstanceListServiceRspBo uocQryOrderProcessInstanceListServiceRspBo = this.uocQryOrderProcessInstanceListService.qryOrderProcessInstanceList(uocQryOrderProcessInstanceListServiceReqBo);
        if (CollectionUtils.isEmpty((Collection)uocQryOrderProcessInstanceListServiceRspBo.getDataList())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u9500\u552e\u5355\u73af\u8282\u4e3a\u7a7a\uff01");
        }
        if (uocQryOrderProcessInstanceListServiceRspBo.getDataList().size() != 1) {
            throw new ZTBusinessException("\u5f53\u524d\u9500\u552e\u5355\u672a\u5b8c\u6210\u73af\u8282\u5b58\u5728\u591a\u6761\uff01");
        }
        return (UocGetOrderTheProcessInstanceServiceRspProcInsBo)uocQryOrderProcessInstanceListServiceRspBo.getDataList().get(0);
    }

    private UocSaleOrderPayConfQryServiceRspConfBo getPurSalePayConf(DycUocRefundPayFunctionReqBO reqBO) {
        UocSaleOrderPayConfQryServiceReqBo uocSaleOrderPayConfQryServiceReqBo = new UocSaleOrderPayConfQryServiceReqBo();
        uocSaleOrderPayConfQryServiceReqBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderPayConfQryServiceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocSaleOrderPayConfQryServiceRspBo uocSaleOrderPayConfQryServiceRspBo = this.uocSaleOrderPayConfQryService.qrySaleOrderPayConf(uocSaleOrderPayConfQryServiceReqBo);
        if (CollectionUtils.isEmpty((Collection)uocSaleOrderPayConfQryServiceRspBo.getPayConfList())) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u5355\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
        List purPayConfList = uocSaleOrderPayConfQryServiceRspBo.getPayConfList().stream().filter(bo -> UocDicConstant.USE_TYPE.PUR.equals(bo.getUserType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(purPayConfList)) {
            throw new ZTBusinessException("\u91c7\u8d2d\u65b9\u9500\u552e\u5355\u652f\u4ed8\u914d\u7f6e\u4e3a\u7a7a\uff01");
        }
        if (purPayConfList.size() != 1) {
            throw new ZTBusinessException("\u91c7\u8d2d\u65b9\u9500\u552e\u5355\u652f\u4ed8\u914d\u7f6e\u5b58\u5728\u591a\u6761\uff01");
        }
        return (UocSaleOrderPayConfQryServiceRspConfBo)purPayConfList.get(0);
    }

    private UocSaleOrderStakeholderQryServiceRspBo doQryThirdInfo(DycUocRefundPayFunctionReqBO reqBO, UocSaleOrderSingleQryServiceRspBo uocSaleOrderSingleQryServiceRspBo) {
        UocSaleOrderStakeholderQryServiceReqBo uocSaleOrderStakeholderQryServiceReqBo = new UocSaleOrderStakeholderQryServiceReqBo();
        uocSaleOrderStakeholderQryServiceReqBo.setStakeholderId(uocSaleOrderSingleQryServiceRspBo.getSaleOrderBo().getStakeholderId());
        uocSaleOrderStakeholderQryServiceReqBo.setOrderId(reqBO.getOrderId());
        return this.uocSaleOrderStakeholderQryService.qrySaleOrderStakeholder(uocSaleOrderStakeholderQryServiceReqBo);
    }

    private void verifyParam(DycUocRefundPayFunctionReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u652f\u4ed8\u9000\u6b3e\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReturnNode())) {
            throw new ZTBusinessException("returnNode\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

