/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.busicommon.api.DycBuriedPointCallFunction;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncReqBo;
import com.tydic.dyc.atom.busicommon.bo.DycBuriedPointCallFuncRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycBuriedPointCallFunctionImpl
implements DycBuriedPointCallFunction {
    private static final Logger log = LoggerFactory.getLogger(DycBuriedPointCallFunctionImpl.class);
    @Value(value="${uoc.buriedpoint.url:http://192.168.0.15/ability}")
    private String abilityUrl;

    @Override
    public DycBuriedPointCallFuncRspBo callAbility(DycBuriedPointCallFuncReqBo reqBo) {
        DycBuriedPointCallFuncRspBo rspBo = new DycBuriedPointCallFuncRspBo();
        String httpRspStr = null;
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnable()) && !reqBo.getEnable().booleanValue()) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u57cb\u70b9\u8bbe\u7f6e\u4e3a\u4e0d\u8fdb\u884c\u63a5\u53e3\u8c03\u7528!");
            return rspBo;
        }
        try {
            log.info("\u4e1a\u52a1\u4e2d\u5fc3:{}\u57cb\u70b9\u8c03\u7528\u8bf7\u6c42url: {}", (Object)this.abilityUrl);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("busiList", reqBo.getBusiList());
            log.info("\u57cb\u70b9\u8c03\u7528\u8bf7\u6c42\u65e5\u5fd7: {}", (Object)jsonObject.toJSONString());
            httpRspStr = DycEsbUtil.doPostReuest((String)this.abilityUrl, (String)jsonObject.toJSONString());
            log.info("\u57cb\u70b9\u8c03\u7528\u8fd4\u56de\u65e5\u5fd7: {}", (Object)httpRspStr);
        }
        catch (ZTBusinessException e) {
            log.error("\u57cb\u70b9\u8c03\u7528\u63a5\u53e3\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return this.resolveRsp(httpRspStr);
    }

    private DycBuriedPointCallFuncRspBo resolveRsp(String returnString) {
        log.debug("\u57cb\u70b9\u8c03\u7528\u8fd4\u56de\u6570\u636e\uff1a" + returnString);
        DycBuriedPointCallFuncRspBo rspBO = new DycBuriedPointCallFuncRspBo();
        if (returnString.contains("9998") || returnString.contains("9999")) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u80fd\u529b\u5e73\u53f0\u5185\u90e8\u670d\u52a1\u8c03\u7528\u8be6\u60c5\u63a5\u53e3\u62a5\u9519!\u6216\u8005\u80fd\u529b\u5e73\u53f0\u51fa\u9519!");
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u57cb\u70b9\u8c03\u7528\u6210\u529f!");
        }
        return rspBO;
    }
}

