/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.eva.api.DycEvaQryTemplateDetailFunction;
import com.tydic.dyc.atom.busicommon.eva.api.DycEvaQryTemplateListFunction;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaConfItemLevelFuncBO;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaConfStarItemFuncBO;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaQryTemplateDetailFuncReqBO;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaQryTemplateDetailFuncRspBO;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaQryTemplateListFuncReqBO;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaQryTemplateListFuncRspBO;
import com.tydic.dyc.atom.busicommon.eva.bo.DycEvaTemplateFuncBO;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncRspBO;
import com.tydic.dyc.base.constants.UocConstant;
import com.tydic.dyc.busicommon.ics.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.busicommon.ics.bo.DycUocSaleOrderInfoBO;
import com.tydic.dyc.busicommon.order.api.DycUocAutoEvaTaskService;
import com.tydic.dyc.busicommon.order.bo.DycComSaleOrderEvaStarLevelBO;
import com.tydic.dyc.busicommon.order.bo.DycUocAutoEvaTaskServiceReqBo;
import com.tydic.dyc.busicommon.order.bo.DycUocAutoEvaTaskServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.UocEvaluateDealService;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.order.UocProOrderEvaluatePageQueryService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluatePageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluatePageQueryRspBo;
import com.tydic.uec.ability.UecEvaluateCreateAbilityService;
import com.tydic.uec.ability.bo.UecEvaluateCreateAbilityReqBO;
import com.tydic.uec.common.bo.eva.EvaBaseInfoBO;
import com.tydic.uec.common.bo.eva.EvaObjInfoBO;
import com.tydic.uec.common.bo.eva.EvaStarLevelBO;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycUocAutoEvaTaskService"})
public class DycUocAutoEvaTaskServiceImpl
implements DycUocAutoEvaTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycUocAutoEvaTaskServiceImpl.class);
    @Autowired
    private UocProOrderEvaluatePageQueryService uocProOrderEvaluatePageQueryService;
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    @Autowired
    private DycEvaQryTemplateDetailFunction dycEvaQryTemplateDetailFunction;
    @Autowired
    private DycEvaQryTemplateListFunction dycEvaQryTemplateListFunction;
    @Autowired
    private UecEvaluateCreateAbilityService evaluateCreateAbilityService;
    @Autowired
    private UocEvaluateDealService uocEvaluateDealService;
    private static final String SALE_ORDER_CODE = "951184533233897472";
    private static final String TO_EVA = "0";
    private static final String INSP_STATE = "XS_YS_YS";
    private static final String ECOM_MENU_CODE = "lcpEcMyOrder";
    private static final Integer ECOM_SALE_ORDER_DEAL_TAB = 30403;
    private static final Integer SYSTEM_AUTOMATIC_PRAISE = 1;
    private static final List<String> EVA_ITEM_LIST = Arrays.asList("shop_logis", "shop_desc", "shop_service", "product_eva");

    @Override
    @PostMapping(value={"dealAutoEva"})
    public DycUocAutoEvaTaskServiceRspBo dealAutoEva(@RequestBody DycUocAutoEvaTaskServiceReqBo reqBo) {
        JSONObject reqObj = new JSONObject();
        reqObj.put("code", (Object)SALE_ORDER_CODE);
        reqObj.put("pageNo", (Object)1);
        reqObj.put("pageSize", (Object)100);
        reqObj.put("evaluateStateList", Collections.singletonList(TO_EVA));
        reqObj.put("saleOrdTacheStateList", Collections.singletonList(INSP_STATE));
        this.setTabConf(reqObj);
        DycUocSalOrderListQryRspBO rspBO = this.getOrderList(reqObj);
        log.info("\u9700\u8981\u81ea\u52a8\u597d\u8bc4\u7684\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBO)));
        if (CollectionUtils.isNotEmpty(rspBO.getRows())) {
            Map<String, UocProOrderEvaluateInfoBo> evaConf = this.getEvaConf();
            log.info("\u8bc4\u4ef7\u914d\u7f6e\uff1a{}", (Object)JSON.toJSONString(evaConf));
            if (MapUtils.isNotEmpty(evaConf)) {
                DycEvaQryTemplateDetailFuncRspBO evaTemplate = this.getEvaTemplateList();
                List<DycComSaleOrderEvaStarLevelBO> dycSaleOrderEvaStarLevelBOS = this.createDefaultStar(evaTemplate);
                this.dealEva(evaTemplate, dycSaleOrderEvaStarLevelBOS, rspBO.getRows(), evaConf, reqBo);
                if (rspBO.getRecordsTotal() > 100) {
                    for (int i = 2; i <= rspBO.getTotal(); ++i) {
                        reqObj.put("pageNo", (Object)i);
                        reqObj.put("pageSize", (Object)100);
                        DycUocSalOrderListQryRspBO orders = this.getOrderList(reqObj);
                        log.info("\u9700\u8981\u81ea\u52a8\u597d\u8bc4\u7684\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString((Object)((Object)rspBO)));
                        if (!CollectionUtils.isNotEmpty(orders.getRows())) continue;
                        this.dealEva(evaTemplate, dycSaleOrderEvaStarLevelBOS, orders.getRows(), evaConf, reqBo);
                    }
                }
            }
        }
        return new DycUocAutoEvaTaskServiceRspBo();
    }

    private void dealEva(DycEvaQryTemplateDetailFuncRspBO evaTemplate, List<DycComSaleOrderEvaStarLevelBO> dycSaleOrderEvaStarLevelBOS, List<DycUocSaleOrderInfoBO> rows, Map<String, UocProOrderEvaluateInfoBo> evaConf, DycUocAutoEvaTaskServiceReqBo reqBo) {
        for (DycUocSaleOrderInfoBO row : rows) {
            UocProOrderEvaluateInfoBo conf = this.getConf(evaConf, row.getPurchaseOrgId());
            if (!SYSTEM_AUTOMATIC_PRAISE.equals(conf.getSystemAutomaticPraise())) continue;
            Long evaluationDeadline = conf.getEvaluationDeadline();
            if (!CollectionUtils.isNotEmpty(row.getInspTimeList())) continue;
            Date lastInspTime = (Date)row.getInspTimeList().stream().sorted(Comparator.reverseOrder()).collect(Collectors.toList()).get(0);
            log.info("\u5f53\u524d\u65f6\u95f4\uff1a{}\uff0c \u6700\u665a\u9a8c\u6536\u65f6\u95f4\uff1a{}\uff0c\u8bc4\u4ef7\u65f6\u9650\uff1a{}\uff0c\u5e94\u7528\u5355\u4f4d\uff1a{}\uff0c \u8ba2\u5355\uff1a{}", new Object[]{System.currentTimeMillis(), lastInspTime.getTime(), evaluationDeadline, row.getPurchaseOrgId(), row.getSaleOrderNo()});
            if (System.currentTimeMillis() <= lastInspTime.getTime() + evaluationDeadline) continue;
            try {
                UecEvaluateCreateAbilityReqBO uecEvaluateCreateAbilityReqBO = this.createEva(evaTemplate, row, dycSaleOrderEvaStarLevelBOS);
                this.evaluateCreateAbilityService.createEvaluate(uecEvaluateCreateAbilityReqBO);
            }
            catch (Exception e) {
                continue;
            }
            UocEvaluateDealServiceReqBo uocEvaluateDealServiceReqBo = new UocEvaluateDealServiceReqBo();
            uocEvaluateDealServiceReqBo.setOrderId(row.getOrderId());
            uocEvaluateDealServiceReqBo.setSaleOrderId(row.getSaleOrderId());
            uocEvaluateDealServiceReqBo.setUserId(Long.valueOf(1L));
            uocEvaluateDealServiceReqBo.setEvaluateState(UocConstant.EvaState.EVALUATED_CAN_REVIEWED);
            uocEvaluateDealServiceReqBo.setTraceId(reqBo.getTraceId());
            this.uocEvaluateDealService.dealEvaluate(uocEvaluateDealServiceReqBo);
        }
    }

    private UocProOrderEvaluateInfoBo getConf(Map<String, UocProOrderEvaluateInfoBo> evaConf, String purId) {
        log.info(" evaConf.get(purId) :{}", (Object)evaConf.get(purId));
        if (null == evaConf.get(purId)) {
            return evaConf.get(TO_EVA);
        }
        return evaConf.get(purId);
    }

    private DycUocSalOrderListQryRspBO getOrderList(JSONObject reqObj) {
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        return (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
    }

    private List<DycComSaleOrderEvaStarLevelBO> createDefaultStar(DycEvaQryTemplateDetailFuncRspBO evaTemplate) {
        return evaTemplate.getBaseFieldList().stream().filter(dycEvaConfBaseFieldFuncBO -> EVA_ITEM_LIST.contains(dycEvaConfBaseFieldFuncBO.getFieldCode())).map(dycEvaConfBaseFieldFuncBO -> {
            DycEvaConfStarItemFuncBO starItemFuncBO = (DycEvaConfStarItemFuncBO)dycEvaConfBaseFieldFuncBO.getStarItemList().get(0);
            DycComSaleOrderEvaStarLevelBO dycSaleOrderEvaStarLevelBO = new DycComSaleOrderEvaStarLevelBO();
            dycSaleOrderEvaStarLevelBO.setItemCode(starItemFuncBO.getItemCode());
            dycSaleOrderEvaStarLevelBO.setItemName(starItemFuncBO.getItemName());
            for (DycEvaConfItemLevelFuncBO dycEvaConfItemLevelFuncBO : starItemFuncBO.getItemLevelList()) {
                if (1 != dycEvaConfItemLevelFuncBO.getIsDefault()) continue;
                dycSaleOrderEvaStarLevelBO.setIsDefault(1);
                dycSaleOrderEvaStarLevelBO.setLevelValue(dycEvaConfItemLevelFuncBO.getLevelValue());
            }
            return dycSaleOrderEvaStarLevelBO;
        }).collect(Collectors.toList());
    }

    private UecEvaluateCreateAbilityReqBO createEva(DycEvaQryTemplateDetailFuncRspBO evaTemplate, DycUocSaleOrderInfoBO row, List<DycComSaleOrderEvaStarLevelBO> dycSaleOrderEvaStarLevelBOS) {
        DycEvaTemplateFuncBO templateInfo = evaTemplate.getTemplateInfo();
        EvaBaseInfoBO evaBaseInfoBO = (EvaBaseInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)templateInfo), EvaBaseInfoBO.class);
        evaBaseInfoBO.setBusiSn(row.getSaleOrderNo());
        evaBaseInfoBO.setEvaAct(Integer.valueOf(1));
        List objInfoBOS = row.getCommodityInfos().stream().map(dycUocSaleOrderCommodityInfoBO -> {
            EvaObjInfoBO evaObjInfoBO = new EvaObjInfoBO();
            evaObjInfoBO.setEvaContent("\u7cfb\u7edf\u81ea\u52a8\u597d\u8bc4");
            evaObjInfoBO.setObjId(dycUocSaleOrderCommodityInfoBO.getSkuId());
            evaObjInfoBO.setObjName(dycUocSaleOrderCommodityInfoBO.getSkuName());
            evaObjInfoBO.setObjType(Integer.valueOf(1));
            evaObjInfoBO.setStarLevelList(JSONObject.parseArray((String)JSONObject.toJSONString((Object)dycSaleOrderEvaStarLevelBOS), EvaStarLevelBO.class));
            return evaObjInfoBO;
        }).collect(Collectors.toList());
        UecEvaluateCreateAbilityReqBO uecEvaluateCreateAbilityReqBO = new UecEvaluateCreateAbilityReqBO();
        uecEvaluateCreateAbilityReqBO.setEvaBaseInfo(evaBaseInfoBO);
        uecEvaluateCreateAbilityReqBO.getEvaBaseInfo().setOrderId(Convert.toStr((Object)row.getOrderId()));
        uecEvaluateCreateAbilityReqBO.setObjInfoList(objInfoBOS);
        uecEvaluateCreateAbilityReqBO.setNeedAudit(Boolean.valueOf(false));
        return uecEvaluateCreateAbilityReqBO;
    }

    private DycEvaQryTemplateDetailFuncRspBO getEvaTemplateList() {
        DycEvaQryTemplateListFuncReqBO dycEvaQryTemplateListFuncReqBO = new DycEvaQryTemplateListFuncReqBO();
        dycEvaQryTemplateListFuncReqBO.setState(Integer.valueOf(1));
        dycEvaQryTemplateListFuncReqBO.setSysCode("PEB");
        dycEvaQryTemplateListFuncReqBO.setTypeCode("EVA");
        DycEvaQryTemplateListFuncRspBO dycEvaQryTemplateListFuncRspBO = this.dycEvaQryTemplateListFunction.qryTemplateList(dycEvaQryTemplateListFuncReqBO);
        if (!"0000".equals(dycEvaQryTemplateListFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8bc4\u4ef7\u6a21\u677f\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + dycEvaQryTemplateListFuncRspBO.getRespCode() + "\u3011," + dycEvaQryTemplateListFuncRspBO.getRespDesc());
        }
        DycEvaTemplateFuncBO dycEvaTemplateFuncBO = (DycEvaTemplateFuncBO)dycEvaQryTemplateListFuncRspBO.getRows().get(0);
        DycEvaQryTemplateDetailFuncReqBO dycEvaQryTemplateDetailFuncReqBO = new DycEvaQryTemplateDetailFuncReqBO();
        dycEvaQryTemplateDetailFuncReqBO.setModId(dycEvaTemplateFuncBO.getModId());
        dycEvaQryTemplateDetailFuncReqBO.setTypeCode("EVA");
        DycEvaQryTemplateDetailFuncRspBO dycEvaQryTemplateDetailFuncRspBO = this.dycEvaQryTemplateDetailFunction.qryTemplateDetail(dycEvaQryTemplateDetailFuncReqBO);
        if (!"0000".equals(dycEvaQryTemplateDetailFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8bc4\u4ef7\u6a21\u677f\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + dycEvaQryTemplateDetailFuncRspBO.getRespCode() + "\u3011," + dycEvaQryTemplateDetailFuncRspBO.getRespDesc());
        }
        return dycEvaQryTemplateDetailFuncRspBO;
    }

    private Map<String, UocProOrderEvaluateInfoBo> getEvaConf() {
        UocProOrderEvaluatePageQueryReqBo dycUocProOrderEvaluatePageQueryFuncReqBO = new UocProOrderEvaluatePageQueryReqBo();
        UocProOrderEvaluatePageQueryRspBo dycUocProOrderEvaluatePageQueryFuncRspBO = this.uocProOrderEvaluatePageQueryService.queryOrderEvaluatePage(dycUocProOrderEvaluatePageQueryFuncReqBO);
        if (!"0000".equals(dycUocProOrderEvaluatePageQueryFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8bc4\u4ef7\u914d\u7f6e\u67e5\u8be2\u5f02\u5e38,\u5f02\u5e38\u7f16\u7801\u3010" + dycUocProOrderEvaluatePageQueryFuncRspBO.getRespCode() + "\u3011," + dycUocProOrderEvaluatePageQueryFuncRspBO.getRespDesc());
        }
        List rows = dycUocProOrderEvaluatePageQueryFuncRspBO.getRows();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            return rows.stream().collect(Collectors.toMap(UocProOrderEvaluateInfoBo::getApplicationUnitNo, o -> o));
        }
        return new HashMap<String, UocProOrderEvaluateInfoBo>();
    }

    private void setTabConf(JSONObject reqJsonObj) {
        DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO;
        List<DycTabTacheCodeInfoFuncBO> dycTabTacheCodeInfoFuncBOList = this.qryTab();
        if (CollectionUtils.isEmpty(dycTabTacheCodeInfoFuncBOList)) {
            return;
        }
        ConcurrentMap<Integer, List<DycTabTacheCodeInfoFuncBO>> tabTachCodeMap = dycTabTacheCodeInfoFuncBOList.stream().collect(Collectors.groupingByConcurrent(DycTabTacheCodeInfoFuncBO::getTabId));
        List dycTabTacheCodeInfoFuncBOS = (List)tabTachCodeMap.get(ECOM_SALE_ORDER_DEAL_TAB);
        if (!CollectionUtils.isEmpty((Collection)dycTabTacheCodeInfoFuncBOS) && StringUtils.isNotBlank((CharSequence)(dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)dycTabTacheCodeInfoFuncBOS.get(0)).getParamJson())) {
            JSONObject paramJsonObj = JSON.parseObject((String)dycTabTacheCodeInfoFuncBO.getParamJson());
            reqJsonObj.putAll((Map)paramJsonObj);
        }
        JSONArray tabQueryCountBos = new JSONArray();
        tabTachCodeMap.forEach((key, value) -> {
            if (!CollectionUtils.isEmpty((Collection)value)) {
                DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)value.get(0);
                JSONObject dycUocTabQueryCountBO = new JSONObject();
                dycUocTabQueryCountBO.put("tabId", (Object)key.longValue());
                dycUocTabQueryCountBO.put("tabName", (Object)dycTabTacheCodeInfoFuncBO.getTabName());
                dycUocTabQueryCountBO.put("tabCodes", (Object)dycTabTacheCodeInfoFuncBO.getTacheCodes());
                dycUocTabQueryCountBO.put("tabStatus", (Object)dycTabTacheCodeInfoFuncBO.getTabStatusList());
                dycUocTabQueryCountBO.put("tabSubCodes", (Object)dycTabTacheCodeInfoFuncBO.getSubTacheCodes());
                dycUocTabQueryCountBO.put("tabDoneSubCodes", (Object)dycTabTacheCodeInfoFuncBO.getDoneTacheCodeList());
                dycUocTabQueryCountBO.put("paramJson", (Object)dycTabTacheCodeInfoFuncBO.getParamJson());
                dycUocTabQueryCountBO.put("sort", (Object)dycTabTacheCodeInfoFuncBO.getSort());
                tabQueryCountBos.add((Object)dycUocTabQueryCountBO);
            }
        });
        reqJsonObj.put("tabQueryCountBos", (Object)tabQueryCountBos);
    }

    private List<DycTabTacheCodeInfoFuncBO> qryTab() {
        DycTabTacheCodeQryFuncReqBO dycTabTacheCodeQryFuncReqBO = new DycTabTacheCodeQryFuncReqBO();
        dycTabTacheCodeQryFuncReqBO.setMenuCode(ECOM_MENU_CODE);
        DycTabTacheCodeQryFuncRspBO dycTabTacheCodeQryFuncRspBO = this.dycTabTacheCodeQryFunction.qryTabTacheCode(dycTabTacheCodeQryFuncReqBO);
        return dycTabTacheCodeQryFuncRspBO.getRows();
    }
}

