/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycUocDelMsgPushFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocGetMsgPushFunction;
import com.tydic.dyc.atom.busicommon.api.DycUocInsertOutMsgPoolFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocDelMsgPushFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocDelMsgPushFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetMsgPushFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetMsgPushFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocGetMsgPushResultBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocInsertOutMsgPoolFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocInsertOutMsgPoolFuncRspBO;
import com.tydic.dyc.busicommon.order.api.DycUocQryOutPushMsgService;
import com.tydic.dyc.busicommon.order.bo.DycUocQryOutPushMsgReqBO;
import com.tydic.dyc.busicommon.order.bo.DycUocQryOutPushMsgRspBO;
import com.tydic.dyc.oc.service.common.UocQryConfSupplierService;
import com.tydic.dyc.oc.service.common.bo.UocQryConfSupplierReqBO;
import com.tydic.dyc.oc.service.common.bo.UocQryConfSupplierRspBO;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycUocQryOutPushMsgService"})
public class DycUocQryOutPushMsgServiceImpl
implements DycUocQryOutPushMsgService {
    private static final Logger log = LoggerFactory.getLogger(DycUocQryOutPushMsgServiceImpl.class);
    @Autowired
    private UocQryConfSupplierService uocQryConfSupplierService;
    @Autowired
    private DycUocGetMsgPushFunction dycUocGetMsgPushFunction;
    @Autowired
    private DycUocInsertOutMsgPoolFunction dycUocInsertOutMsgPoolFunction;
    @Autowired
    private DycUocDelMsgPushFunction dycUocDelMsgPushFunction;
    @Value(value="${isOpenDelPushMsg}")
    private boolean isOpenDelPushMsg;

    @Override
    @PostMapping(value={"createAndQryOutPushMsg"})
    public DycUocQryOutPushMsgRspBO createAndQryOutPushMsg(@RequestBody DycUocQryOutPushMsgReqBO reqBO) {
        String[] dealTypes;
        log.info("\u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6\u6d88\u606f\u6c60\u6d88\u606f\u5e76\u5165\u5e93\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        this.validateArg(reqBO);
        UocQryConfSupplierReqBO funcReqBO = new UocQryConfSupplierReqBO();
        funcReqBO.setGoodsSupplierNo(reqBO.getShardingParameter());
        UocQryConfSupplierRspBO funcRspBO = this.uocQryConfSupplierService.qryConfSupplier(funcReqBO);
        if (!"0000".equals(funcRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u4f9b\u5e94\u5546\u914d\u7f6e\u5f02\u5e38\uff1a" + funcRspBO.getRespDesc());
        }
        String supNo = reqBO.getShardingParameter();
        if (ObjectUtil.isEmpty((Object)funcRspBO.getDealType())) {
            throw new ZTBusinessException("\u6ca1\u6709\u67e5\u5230\u4f9b\u5e94\u5546[" + funcReqBO.getGoodsSupplierNo() + "]\u5bf9\u5e94\u7684\u6d88\u606f\u5904\u7406\u7c7b\u578b");
        }
        for (String dealType : dealTypes = funcRspBO.getDealType().split(",")) {
            Boolean isAnalysis = this.defineAnalysisType(dealType);
            if (!isAnalysis.booleanValue()) {
                dealType = dealType.substring(0, dealType.length() - 1);
            }
            DycUocGetMsgPushFuncRspBO qryMsgRsp = null;
            try {
                qryMsgRsp = this.qryPushMsg(Long.valueOf(supNo), dealType, isAnalysis);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                continue;
            }
            if (null == qryMsgRsp || null == qryMsgRsp.getResult() || qryMsgRsp.getResult().isEmpty()) continue;
            List resultVOlist = qryMsgRsp.getResult();
            DycUocInsertOutMsgPoolFuncReqBO msgPoolFuncReqBO = new DycUocInsertOutMsgPoolFuncReqBO();
            msgPoolFuncReqBO.setGoodsSupplierId(Long.valueOf(supNo));
            msgPoolFuncReqBO.setResultVOlist(resultVOlist);
            msgPoolFuncReqBO.setIsAnalysis(isAnalysis);
            msgPoolFuncReqBO.setType(dealType);
            DycUocInsertOutMsgPoolFuncRspBO rspBO = this.dycUocInsertOutMsgPoolFunction.createAndQryOutPushMsg(msgPoolFuncReqBO);
            if (!"0000".equals(rspBO.getRespCode()) || CollectionUtils.isEmpty((Collection)rspBO.getList())) continue;
            for (String msgId : rspBO.getList()) {
                try {
                    this.deletePushMsg(msgId, Long.valueOf(supNo));
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
        }
        DycUocQryOutPushMsgRspBO rspBO = new DycUocQryOutPushMsgRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u63a8\u9001\u6d88\u606f\u5904\u7406\u6210\u529f");
        return rspBO;
    }

    private void validateArg(DycUocQryOutPushMsgReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getShardingParameter())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[shardingParameter]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean defineAnalysisType(String dealType) {
        boolean isAnalysis = true;
        String endWithUpper = "F";
        String endWithLower = "f";
        if (dealType.endsWith(endWithUpper) || dealType.endsWith(endWithLower)) {
            isAnalysis = false;
        }
        return isAnalysis;
    }

    private DycUocGetMsgPushFuncRspBO qryPushMsg(Long supNo, String dealType, Boolean isAnalysis) {
        DycUocGetMsgPushFuncReqBO busiGetMsgReq = new DycUocGetMsgPushFuncReqBO();
        busiGetMsgReq.setSupplierId(supNo);
        busiGetMsgReq.setType(Integer.valueOf(dealType));
        busiGetMsgReq.setIsAnalysis(isAnalysis);
        DycUocGetMsgPushFuncRspBO qryMsgRsp = this.dycUocGetMsgPushFunction.getMsg(busiGetMsgReq);
        if (qryMsgRsp == null || !qryMsgRsp.isSuccess()) {
            log.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u5931\u8d25");
            return null;
        }
        List resultVOlist = qryMsgRsp.getResult();
        if (null == resultVOlist) {
            log.error("\u6267\u884c\u67e5\u8be2\u5916\u90e8\u63a8\u9001\u6d88\u606f\u4e1a\u52a1\u5f02\u5e38\uff1a\u5916\u90e8\u670d\u52a1\u672a\u8fd4\u56de\u5904\u7406\u6d88\u606f");
            return null;
        }
        for (DycUocGetMsgPushResultBO resultVO : resultVOlist) {
            log.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2resultVO\uff1a" + resultVO.toString());
            if (null == resultVO.getResult()) continue;
            log.debug("\u8c03\u7528\u63a8\u9001\u6d88\u606f\u51fa\u53c2Result: " + resultVO.getResult().toString());
        }
        return qryMsgRsp;
    }

    private void deletePushMsg(String msgId, Long supplierId) {
        if (this.isOpenDelPushMsg) {
            DycUocDelMsgPushFuncReqBO busiDelMsgReq = new DycUocDelMsgPushFuncReqBO();
            busiDelMsgReq.setId(msgId);
            busiDelMsgReq.setSupplierId(supplierId);
            DycUocDelMsgPushFuncRspBO usiDelMsgRsp = this.dycUocDelMsgPushFunction.delMsgPush(busiDelMsgReq);
            if (!"0000".equals(usiDelMsgRsp.getRespCode())) {
                log.error("\u63a8\u9001\u6d88\u606f\u5165\u5e93\u65f6\u672a\u6210\u529f\u5220\u9664\u6570\u636e\u5e93\u4e2d\u672a\u5b58\u5728\u7684\u5916\u90e8\u8ba2\u5355\u7684\u63a8\u9001\u6d88\u606f!" + usiDelMsgRsp.getRespDesc());
            }
        }
    }
}

