/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.venus.extension.Extension;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.busicommon.order.api.DycUocRefuseSaleOrderService;
import com.tydic.dyc.busicommon.order.bo.DycUocRefuseSaleOrderServiceReqBO;
import com.tydic.dyc.busicommon.order.bo.DycUocRefuseSaleOrderServiceRspBO;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetCommodityInfoBO;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtReqBo;
import com.tydic.dyc.saas.uoc.bo.DycUocOrderTakeUpBudgetServiceExtRspBo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycUocRefuseSaleOrderService"})
public class DycUocRefuseSaleOrderServiceImpl
implements DycUocRefuseSaleOrderService {
    private static final Logger log = LoggerFactory.getLogger(DycUocRefuseSaleOrderServiceImpl.class);
    @Autowired
    private UocSaleOrderRefuseService uocSaleOrderRefuseService;
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Extension
    @Autowired
    private DycUocOrderTakeUpBudgetServiceExtPt dycUocOrderTakeUpBudgetServiceExtPt;
    @Value(value="${releaseBudget:false}")
    private boolean releaseBudget;

    @Override
    @PostMapping(value={"refuseOrder"})
    public DycUocRefuseSaleOrderServiceRspBO refuseOrder(@RequestBody DycUocRefuseSaleOrderServiceReqBO refuseSaleOrderServiceReqBO) {
        UocSaleOrderRefuseReqBo uocSaleOrderRefuseReqBo = (UocSaleOrderRefuseReqBo)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)refuseSaleOrderServiceReqBO)), UocSaleOrderRefuseReqBo.class);
        uocSaleOrderRefuseReqBo.setConfirmResult(UocConstant.CONFIRM_RESULT.PUR_REFUSE);
        this.uocSaleOrderRefuseService.dealSaleOrderRefuse(uocSaleOrderRefuseReqBo);
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(refuseSaleOrderServiceReqBO.getTaskId());
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
        if (this.releaseBudget) {
            log.info("\u62d2\u6536\u534f\u8bae\u8ba2\u5355\u91ca\u653e\u9884\u7b97");
            UocGetSaleOrderDetailServiceReqBo detailServiceRspBo = (UocGetSaleOrderDetailServiceReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)refuseSaleOrderServiceReqBO)), UocGetSaleOrderDetailServiceReqBo.class);
            UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(detailServiceRspBo);
            if (!"0000".equals(saleOrderDetail.getRespCode())) {
                throw new ZTBusinessException(saleOrderDetail.getRespDesc());
            }
            DycUocOrderTakeUpBudgetServiceExtReqBo extReqBo = (DycUocOrderTakeUpBudgetServiceExtReqBo)JSON.parseObject((String)JSON.toJSONString((Object)saleOrderDetail), DycUocOrderTakeUpBudgetServiceExtReqBo.class);
            extReqBo.setSaleOrderItemList(JSONArray.parseArray((String)JSON.toJSONString((Object)saleOrderDetail.getSaleOrderDetailServiceRspItemBoList()), DycUocOrderTakeUpBudgetCommodityInfoBO.class));
            extReqBo.setPayStatus("2");
            this.generalExtParam(saleOrderDetail, extReqBo);
            log.info("\u62d2\u6536\u534f\u8bae\u8ba2\u5355\u91ca\u653e\u9884\u7b97\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)extReqBo));
            Date callTime = new Date();
            DycUocOrderTakeUpBudgetServiceExtRspBo extRspBo = this.dycUocOrderTakeUpBudgetServiceExtPt.takeUpBudget(extReqBo);
            Date retTime = new Date();
            log.info("\u62d2\u6536\u534f\u8bae\u8ba2\u5355\u91ca\u653e\u9884\u7b97\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)extRspBo));
            this.intsertInterLog(saleOrderDetail.getOrderId(), saleOrderDetail.getSaleOrderId(), callTime, retTime, "\u91ca\u653e\u9884\u7b97", "com.tydic.dyc.saas.uoc.api.DycUocOrderTakeUpBudgetServiceExtPt.takeUpBudget", JSON.toJSONString((Object)extReqBo), JSON.toJSONString((Object)extRspBo));
        }
        return (DycUocRefuseSaleOrderServiceRspBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)dycBusiProcessFlowFuncRspBO), DycUocRefuseSaleOrderServiceRspBO.class));
    }

    private void generalExtParam(UocGetSaleOrderDetailServiceRspBo salOrderDetail, DycUocOrderTakeUpBudgetServiceExtReqBo extReqBo) {
        List extendFieldBoList = salOrderDetail.getExtFields();
        Map<String, BaseExtendFieldBo> extendFieldBoMap = extendFieldBoList.stream().collect(Collectors.toMap(BaseExtendFieldBo::getFieldCode, e -> e));
        if (null != extendFieldBoMap.get("budgetProjectName")) {
            extReqBo.setBudgetProjectName(extendFieldBoMap.get("budgetProjectName").getFieldValue());
        }
        if (null != extendFieldBoMap.get("budgetProjectId")) {
            extReqBo.setBudgetProjectId(extendFieldBoMap.get("budgetProjectId").getFieldValue());
        }
        if (null != extendFieldBoMap.get("relevantDeptId")) {
            extReqBo.setRelevantDeptId(extendFieldBoMap.get("relevantDeptId").getFieldValue());
        }
        if (null != extendFieldBoMap.get("relevantDeptName")) {
            extReqBo.setRelevantDeptName(extendFieldBoMap.get("relevantDeptName").getFieldValue());
        }
        if (null != extendFieldBoMap.get("financialOrgId")) {
            extReqBo.setFinancialOrgId(extendFieldBoMap.get("financialOrgId").getFieldValue());
        }
        if (null != extendFieldBoMap.get("financialOrgName")) {
            extReqBo.setFinancialOrgName(extendFieldBoMap.get("financialOrgName").getFieldValue());
        }
        if (null != extendFieldBoMap.get("costCenterId")) {
            extReqBo.setCostCenterId(extendFieldBoMap.get("costCenterId").getFieldValue());
        }
        if (null != extendFieldBoMap.get("costCenterName")) {
            extReqBo.setCostCenterName(extendFieldBoMap.get("costCenterName").getFieldValue());
        }
        if (null != extendFieldBoMap.get("extCustId")) {
            extReqBo.setExtCustId(extendFieldBoMap.get("extCustId").getFieldValue());
        }
        for (DycUocOrderTakeUpBudgetCommodityInfoBO item : extReqBo.getSaleOrderItemList()) {
            List itemExtFields = item.getExtFields();
            Map<String, BaseExtendFieldBo> itemExtFieldMap = itemExtFields.stream().collect(Collectors.toMap(BaseExtendFieldBo::getFieldCode, e -> e));
            if (null != itemExtFieldMap.get("incomeAndExpProjectId")) {
                item.setIncomeAndExpProjectId(itemExtFieldMap.get("incomeAndExpProjectId").getFieldValue());
            }
            if (null == itemExtFieldMap.get("incomeAndExpProjectName")) continue;
            item.setIncomeAndExpProjectName(itemExtFieldMap.get("incomeAndExpProjectName").getFieldValue());
        }
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(1));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }

    private void validateParam(DycUocRefuseSaleOrderServiceReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getSaleOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u9500\u552e\u5355id\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u8ba2\u5355id\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

