/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.busicommon.order.api.CrcUocMapTrackQryService;
import com.tydic.dyc.busicommon.order.bo.DycUocMapTrackInfoDataBO;
import com.tydic.dyc.busicommon.order.bo.DycUocMapTrackQryReqBO;
import com.tydic.dyc.busicommon.order.bo.DycUocMapTrackQryRspBO;
import com.tydic.dyc.busicommon.order.bo.Kd100MapTrackInfoDataBo;
import com.tydic.dyc.busicommon.order.bo.Kd100MapTrackInfoRspBo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.CrcUocMapTrackQryService"})
public class CrcUocMapTrackQryServiceImpl
implements CrcUocMapTrackQryService {
    private static final Logger log = LoggerFactory.getLogger(CrcUocMapTrackQryServiceImpl.class);
    private static final String COM_CODE = "comCode";
    private static final String COM_NAME = "name";
    @Value(value="${ulc.simulate.data:false}")
    private Boolean isSimulate;
    @Value(value="${kd100.find.code.by.num.url:http://10.200.207.68/OSN/api/autoNum/v1}")
    private String autoNumPath;
    @Value(value="${kd100.map.track.info.url:http://10.200.207.68/json/maptrack/v1}")
    private String queryMapTrackInfoPath;

    @Override
    @PostMapping(value={"getMapTrack"})
    public DycUocMapTrackQryRspBO getMapTrack(@RequestBody DycUocMapTrackQryReqBO reqBo) {
        String mapTrackInfo;
        String autoNumReturn;
        this.validateReqArgs(reqBo);
        DycUocMapTrackQryRspBO rspBO = new DycUocMapTrackQryRspBO();
        if (this.isSimulate.booleanValue()) {
            log.info("\u6a21\u62df\u6570\u636e");
            return this.doSimulate(reqBo);
        }
        JSONObject autoNumJson = new JSONObject();
        autoNumJson.put("num", (Object)reqBo.getMailNo());
        log.info("\u8bf7\u6c42\u5feb\u9012100\u667a\u80fd\u5224\u65ad\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a" + autoNumJson.toJSONString());
        if (StringUtils.isEmpty((Object)this.autoNumPath)) {
            log.error("\u5feb\u9012100\u667a\u80fd\u8bc6\u522b\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\uff1a'kd100.find.code.by.num.url'");
            throw new ZTBusinessException("\u5feb\u9012100\u667a\u80fd\u8bc6\u522b\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\uff1a'kd100.find.code.by.num.url'");
        }
        log.info("\u8bf7\u6c42\u5feb\u9012100\u667a\u80fd\u5224\u65ad\u63a5\u53e3\u5730\u5740\u4e3a\uff1a" + this.autoNumPath);
        try {
            autoNumReturn = HttpUtil.post((String)this.autoNumPath, (String)autoNumJson.toJSONString());
        }
        catch (Exception e) {
            log.error("\u7269\u6d41\u4e2d\u5fc3\u63a5\u53e3\uff0c\u8c03\u7528\u5feb\u9012100\u667a\u80fd\u5224\u65ad\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u7269\u6d41\u4e2d\u5fc3\u63a5\u53e3\uff0c\u8c03\u7528\u5feb\u9012100\u667a\u80fd\u5224\u65ad\u63a5\u53e3\u5f02\u5e38:" + e.getMessage());
        }
        log.info("\u5feb\u9012100\u667a\u80fd\u5224\u65ad\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:" + autoNumReturn);
        JSONArray jsonArray = JSON.parseArray((String)autoNumReturn);
        JSONObject jsonObject = jsonArray.getJSONObject(0);
        String comCode = jsonObject.getString(COM_CODE);
        String comName = jsonObject.getString(COM_NAME);
        JSONObject queryRouteReqJson = new JSONObject(true);
        queryRouteReqJson.put("com", (Object)comCode);
        queryRouteReqJson.put("num", (Object)reqBo.getMailNo());
        queryRouteReqJson.put("phone", (Object)"");
        queryRouteReqJson.put("from", (Object)reqBo.getFrom());
        queryRouteReqJson.put("to", (Object)reqBo.getTo());
        queryRouteReqJson.put("resultv2", (Object)"3");
        queryRouteReqJson.put("mapConfigKey", (Object)"");
        queryRouteReqJson.put("show", (Object)"0");
        queryRouteReqJson.put("order", (Object)"desc");
        queryRouteReqJson.put("orderTime", (Object)"");
        if (StringUtils.isEmpty((Object)this.queryMapTrackInfoPath)) {
            log.error("\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\uff1a'kd100.map.track.info.url'");
            throw new ZTBusinessException("\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u5730\u5740\u672a\u914d\u7f6e\uff0c\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u914d\u7f6e\uff1a'kd100.map.track.info.url'");
        }
        log.info("\u8bf7\u6c42\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u5730\u5740\u4e3a\uff1a{}", (Object)this.queryMapTrackInfoPath);
        try {
            mapTrackInfo = HttpUtil.post((String)this.queryMapTrackInfoPath, (String)queryRouteReqJson.toJSONString(), (int)9000);
        }
        catch (Exception e) {
            log.error("\u7269\u6d41\u4e2d\u5fc3\u63a5\u53e3\uff0c\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u7269\u6d41\u4e2d\u5fc3\u63a5\u53e3\uff0c\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u63a5\u53e3\u5f02\u5e38\uff1a" + e.getMessage());
        }
        log.debug("\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u63a5\u53e3\u8fd4\u56de\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)mapTrackInfo);
        JSONObject routeInfoJsonObject = JSON.parseObject((String)mapTrackInfo);
        Kd100MapTrackInfoRspBo kdMapTrackInfoRspBo = (Kd100MapTrackInfoRspBo)JSONObject.toJavaObject((JSON)routeInfoJsonObject, Kd100MapTrackInfoRspBo.class);
        if (!"200".equals(kdMapTrackInfoRspBo.getStatus())) {
            log.error("\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)kdMapTrackInfoRspBo.getMessage());
            throw new ZTBusinessException("\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u4fe1\u606f\u5931\u8d25\uff0c" + kdMapTrackInfoRspBo.getMessage());
        }
        ArrayList<DycUocMapTrackInfoDataBO> traceList = new ArrayList<DycUocMapTrackInfoDataBO>();
        rspBO.setBusiCode(reqBo.getBusiCode());
        rspBO.setCourierComName(comName);
        rspBO.setMailNo(reqBo.getMailNo());
        rspBO.setTotalTime(kdMapTrackInfoRspBo.getTotalTime());
        rspBO.setArrivalTime(kdMapTrackInfoRspBo.getArrivalTime());
        rspBO.setRemainTime(kdMapTrackInfoRspBo.getRemainTime());
        rspBO.setTrailUrl(kdMapTrackInfoRspBo.getTrailUrl());
        rspBO.setTraceList(traceList);
        List<Kd100MapTrackInfoDataBo> dataBos = kdMapTrackInfoRspBo.getData();
        for (Kd100MapTrackInfoDataBo item : dataBos) {
            DycUocMapTrackInfoDataBO dataBo = new DycUocMapTrackInfoDataBO();
            dataBo.setSignDesc(item.getStatus());
            dataBo.setStatusDesc(item.getContext());
            dataBo.setStatusTime(item.getFtime());
            traceList.add(dataBo);
        }
        return rspBO;
    }

    private DycUocMapTrackQryRspBO doSimulate(DycUocMapTrackQryReqBO reqBo) {
        DycUocMapTrackQryRspBO retBo = new DycUocMapTrackQryRspBO();
        String str = "{\"message\":\"ok\",\"nu\":\"773160798407742\",\"ischeck\":\"1\",\"com\":\"shentong\",\"status\":\"200\",\"data\":[{\"time\":\"2022-05-19 23:38:34\",\"context\":\"\u5df2\u7b7e\u6536\uff0c\u7b7e\u6536\u4eba\u51ed\u53d6\u8d27\u7801\u7b7e\u6536\u3002\",\"ftime\":\"2022-05-19 23:38:34\",\"areaCode\":null,\"areaName\":null,\"status\":\"\u7b7e\u6536\"},{\"time\":\"2022-05-19 13:20:02\",\"context\":\"\u5feb\u4ef6\u5df2\u6682\u5b58\u81f3\u91cd\u5e86\u5bcc\u60a6\u9633\u5149\u60a6\u5149\u5e97\u83dc\u9e1f\u9a7f\u7ad9\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb15307947613\",\"ftime\":\"2022-05-19 13:20:02\",\"areaCode\":\"CN500100000000\",\"areaName\":\"\u91cd\u5e86,\u91cd\u5e86\",\"status\":\"\u6d3e\u4ef6\"},{\"time\":\"2022-05-19 13:01:20\",\"context\":\"\u3010\u91cd\u5e86\u5927\u77f3\u575d\u516c\u53f8\u3011\u7684\u6d3e\u4ef6\u5458\u3010\u5cb3\u6210\u9633\u3011\u6b63\u5728\u4e3a\u60a8\u6d3e\u4ef6\uff0c\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u6d3e\u4ef6\u5458\uff0c\u8054\u7cfb\u7535\u8bdd\u301015523950353\u3011\uff0c\u5feb\u4ef6\u5df2\u6d88\u6bd2\uff0c\u7533\u901a\u5c0f\u54e5\u5df2\u6d4b\u4f53\u6e29\uff0c\u8bf7\u653e\u5fc3\u6536\u5bc4\u5feb\u9012\uff0895132\u4e3a\u7533\u901a\u4e1a\u52a1\u5458\u5916\u547c\u4e13\u5c5e\u53f7\u7801\uff0c\u53ef\u653e\u5fc3\u63a5\u542c\uff09\",\"ftime\":\"2022-05-19 13:01:20\",\"areaCode\":\"CN500100000000\",\"areaName\":\"\u91cd\u5e86,\u91cd\u5e86\",\"status\":\"\u6d3e\u4ef6\"},{\"time\":\"2022-05-19 08:10:26\",\"context\":\"\u5feb\u4ef6\u5df2\u5230\u8fbe\u3010\u91cd\u5e86\u5927\u77f3\u575d\u516c\u53f8\u3011\u626b\u63cf\u5458\u662f\u3010\u5230\u4ef6\u626b\u63cf\u3011\",\"ftime\":\"2022-05-19 08:10:26\",\"areaCode\":\"CN500100000000\",\"areaName\":\"\u91cd\u5e86,\u91cd\u5e86\",\"status\":\"\u5728\u9014\"},{\"time\":\"2022-05-19 01:33:32\",\"context\":\"\u5feb\u4ef6\u7531\u3010\u91cd\u5e86\u8f6c\u8fd0\u4e2d\u5fc3\u3011\u53d1\u5f80\u3010\u91cd\u5e86\u5927\u77f3\u575d\u516c\u53f8\u3011\uff0c\u5305\u88f9\u5df2\u6d88\u6740\",\"ftime\":\"2022-05-19 01:33:32\",\"areaCode\":\"CN500100000000\",\"areaName\":\"\u91cd\u5e86,\u91cd\u5e86\",\"status\":\"\u5728\u9014\"},{\"time\":\"2022-05-19 01:21:32\",\"context\":\"\u5feb\u4ef6\u5df2\u5230\u8fbe\u3010\u91cd\u5e86\u8f6c\u8fd0\u4e2d\u5fc3\u3011\u626b\u63cf\u5458\u662f\u3010\u81ea\u52a8\u5316\u4e09\u3011\",\"ftime\":\"2022-05-19 01:21:32\",\"areaCode\":\"CN500100000000\",\"areaName\":\"\u91cd\u5e86,\u91cd\u5e86\",\"status\":\"\u5728\u9014\"},{\"time\":\"2022-05-18 03:51:22\",\"context\":\"\u5feb\u4ef6\u7531\u3010\u5e7f\u4e1c\u4e2d\u5c71\u8f6c\u8fd0\u4e2d\u5fc3\u3011\u53d1\u5f80\u3010\u91cd\u5e86\u8f6c\u8fd0\u4e2d\u5fc3\u3011\uff0c\u5305\u88f9\u5df2\u6d88\u6740\",\"ftime\":\"2022-05-18 03:51:22\",\"areaCode\":\"CN442000000000\",\"areaName\":\"\u5e7f\u4e1c,\u4e2d\u5c71\u5e02\",\"status\":\"\u5728\u9014\"},{\"time\":\"2022-05-18 03:44:09\",\"context\":\"\u5feb\u4ef6\u5df2\u5230\u8fbe\u3010\u5e7f\u4e1c\u4e2d\u5c71\u8f6c\u8fd0\u4e2d\u5fc3\u3011\u626b\u63cf\u5458\u662f\u3010\u4e2d\u5c71\u51fa\u6e2f\u81ea\u52a8\u5316\u3011\",\"ftime\":\"2022-05-18 03:44:09\",\"areaCode\":\"CN442000000000\",\"areaName\":\"\u5e7f\u4e1c,\u4e2d\u5c71\u5e02\",\"status\":\"\u5728\u9014\"},{\"time\":\"2022-05-18 01:30:44\",\"context\":\"\u5feb\u4ef6\u7531\u3010\u5e7f\u4e1c\u4e2d\u5c71\u6a2a\u680f\u516c\u53f8\u3011\u53d1\u5f80\u3010\u5e7f\u4e1c\u4e2d\u5c71\u8f6c\u8fd0\u4e2d\u5fc3\u3011\",\"ftime\":\"2022-05-18 01:30:44\",\"areaCode\":\"CN442000110000\",\"areaName\":\"\u5e7f\u4e1c,\u4e2d\u5c71\u5e02,\u6a2a\u680f\u9547\",\"status\":\"\u5728\u9014\"},{\"time\":\"2022-05-17 19:30:05\",\"context\":\"\u3010\u5e7f\u4e1c\u4e2d\u5c71\u6a2a\u680f\u516c\u53f8\u3011\u7684\u6536\u4ef6\u5458\u3010\u9648\u5148\u751f\u3011\u5df2\u6536\u4ef6\",\"ftime\":\"2022-05-17 19:30:05\",\"areaCode\":\"CN442000110000\",\"areaName\":\"\u5e7f\u4e1c,\u4e2d\u5c71\u5e02,\u6a2a\u680f\u9547\",\"status\":\"\u63fd\u6536\"}],\"state\":\"3\",\"condition\":\"F00\",\"routeInfo\":{\"from\":{\"number\":\"CN440100000000\",\"name\":\"\u5e7f\u4e1c,\u5e7f\u5dde\u5e02\"},\"cur\":{\"number\":\"CN500100000000\",\"name\":\"\u91cd\u5e86,\u91cd\u5e86\"},\"to\":{\"number\":\"CN500100000000\",\"name\":\"\u91cd\u5e86,\u91cd\u5e86\"}},\"isLoop\":false,\"trailUrl\":\"https://api.kuaidi100.com/tools/map/c7c9b44291c4c64699c2dcfeda84cb78_106.551556,29.563009_6\",\"arrivalTime\":\"2022-05-19 23\",\"totalTime\":\"2\u592914\u5c0f\u65f6\",\"remainTime\":\"0\u59290\u5c0f\u65f6\"}";
        retBo.setBusiCode("DYC");
        JSONObject similateJson = JSON.parseObject((String)str);
        Kd100MapTrackInfoRspBo kdMapTrackInfoRspBo = (Kd100MapTrackInfoRspBo)JSONObject.toJavaObject((JSON)similateJson, Kd100MapTrackInfoRspBo.class);
        if (!"200".equals(kdMapTrackInfoRspBo.getStatus())) {
            log.error("\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)kdMapTrackInfoRspBo.getMessage());
            throw new ZTBusinessException("\u5feb\u9012100\u5b9e\u65f6\u5730\u56fe\u8f68\u8ff9\u4fe1\u606f\u5931\u8d25\uff0c" + kdMapTrackInfoRspBo.getMessage());
        }
        ArrayList<DycUocMapTrackInfoDataBO> traceList = new ArrayList<DycUocMapTrackInfoDataBO>();
        retBo.setBusiCode(reqBo.getBusiCode());
        retBo.setCourierComName("\u7533\u901a");
        retBo.setMailNo(reqBo.getMailNo());
        retBo.setTotalTime(kdMapTrackInfoRspBo.getTotalTime());
        retBo.setArrivalTime(kdMapTrackInfoRspBo.getArrivalTime());
        retBo.setRemainTime(kdMapTrackInfoRspBo.getRemainTime());
        retBo.setTrailUrl(kdMapTrackInfoRspBo.getTrailUrl());
        retBo.setTraceList(traceList);
        List<Kd100MapTrackInfoDataBo> dataBos = kdMapTrackInfoRspBo.getData();
        for (Kd100MapTrackInfoDataBo item : dataBos) {
            DycUocMapTrackInfoDataBO dataBo = new DycUocMapTrackInfoDataBO();
            dataBo.setSignDesc(item.getStatus());
            dataBo.setStatusDesc(item.getContext());
            dataBo.setStatusTime(item.getFtime());
            traceList.add(dataBo);
        }
        return retBo;
    }

    private void validateReqArgs(DycUocMapTrackQryReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getBusiCode())) {
            throw new ZTBusinessException("\u4e1a\u52a1\u7cfb\u7edf\u7f16\u7801[busiCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getMailNo())) {
            throw new ZTBusinessException("\u7269\u6d41\u8fd0\u5355\u53f7[mailNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getFrom())) {
            throw new ZTBusinessException("\u51fa\u53d1\u5730[from]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getTo())) {
            throw new ZTBusinessException("\u76ee\u7684\u5730[to]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

