/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.supplier.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.authority.service.organization.AuthOrgInfoSyncTempDealService;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoSyncTempDealServiceReqBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgInfoSyncTempDealServiceRspBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.service.organization.bo.AuthUmcOrgInfoSyncTempDealBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.busicommon.supplier.api.DycOrgInfoSyncTaskService;
import com.tydic.dyc.busicommon.supplier.bo.DycOrgInfoSyncServiceReqBo;
import com.tydic.dyc.busicommon.supplier.bo.DycOrgInfoSyncServiceRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.constants.UmcStatusConstant;
import com.tydic.dyc.umc.service.enterprise.UmcOrgInfoSyncTempDeleteService;
import com.tydic.dyc.umc.service.enterprise.UmcOrgInfoSyncTempUpdateService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoListPageService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoSyncTempDealService;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgInfoSyncTempListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoSyncTempDeleteServiceReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoSyncTempUpdateServiceReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoSyncTmpBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListPageReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoListPageRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoSyncTempDealRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoSyncTempDealServiceReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoSyncTempDealServiceRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoSyncTempListServiceReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgInfoSyncTempListServiceRspBo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.supplier.api.DycOrgInfoSyncTaskService"})
public class DycOrgInfoSyncTaskServiceImpl
implements DycOrgInfoSyncTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycOrgInfoSyncTaskServiceImpl.class);
    private final Object $lock = new Object[0];
    @Autowired
    private UmcQryOrgInfoSyncTempListService umcQryOrgInfoSyncTempListService;
    @Autowired
    private UmcQryOrgInfoListPageService umcQryOrgInfoListPageService;
    @Autowired
    private UmcQryOrgInfoSyncTempDealService umcQryOrgInfoSyncTempDealService;
    @Autowired
    private UmcOrgInfoSyncTempUpdateService umcOrgInfoSyncTempUpdateService;
    @Autowired
    private AuthOrgInfoSyncTempDealService authOrgInfoSyncTempDealService;
    @Autowired
    private UmcOrgInfoSyncTempDeleteService umcOrgInfoSyncTempDeleteService;
    @Value(value="${syncOrg.increment:100}")
    private Integer increment;
    @Value(value="${syncOrg.foreach.count:1000}")
    private int total;
    @Autowired
    private CacheClient cacheClient;
    private static final String SYNC_ORG_INFO_KEY = "SYNC_ORG_INFO_KEY";
    private static final String SYNC_ORG_INFO_KEY_THREAD_COUNT = "SYNC_ORG_INFO_KEY_THREAD_COUNT";
    private static final String SYNC_ORG_INFO_KEY_SUP = "SYNC_ORG_INFO_KEY_SUP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PostMapping(value={"syncOrgInfoTask"})
    public DycOrgInfoSyncServiceRspBo syncOrgInfoTask(@RequestBody DycOrgInfoSyncServiceReqBo reqBo) {
        int threadCount;
        DycOrgInfoSyncServiceRspBo dycOrgInfoSyncServiceRspBo = new DycOrgInfoSyncServiceRspBo();
        Long setnxThreadCountResult = this.cacheClient.setnx(SYNC_ORG_INFO_KEY_THREAD_COUNT, (Object)reqBo.getSHARDING_SHARDNUM());
        if (setnxThreadCountResult < 1L && (threadCount = Integer.parseInt(this.cacheClient.get(SYNC_ORG_INFO_KEY_THREAD_COUNT).toString())) != reqBo.getSHARDING_SHARDNUM()) {
            dycOrgInfoSyncServiceRspBo.setMessage("\u4e0a\u6b21\u53d1\u8d77\u7684\u4efb\u52a1\u672a\u5904\u7406\u5b8c\u6210\uff0c\u8bf7\u7a0d\u540e\u53d1\u8d77");
            return dycOrgInfoSyncServiceRspBo;
        }
        Long setnxThreadNumResult = this.cacheClient.setnx(SYNC_ORG_INFO_KEY + reqBo.getSHARDING_PARAMETER(), (Object)reqBo.getSHARDING_PARAMETER());
        if (setnxThreadNumResult < 1L) {
            dycOrgInfoSyncServiceRspBo.setMessage("\u5206\u7247" + reqBo.getSHARDING_PARAMETER() + "\u6b63\u5728\u5904\u7406\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77");
            return dycOrgInfoSyncServiceRspBo;
        }
        try {
            List rows;
            int i;
            for (i = 1; i <= this.total && !CollectionUtils.isEmpty((Collection)(rows = this.getUmcQryOrgInfoSyncTempListServiceRspBo(reqBo, 1, this.increment, Collections.singletonList(UmcStatusConstant.SyncDealResult.TO_DEAL)).getRows())); ++i) {
                this.deal(rows);
            }
            for (i = 1; i <= this.total; ++i) {
                rows = this.getUmcQryOrgInfoSyncTempListServiceRspBo(reqBo, 1, this.increment, Collections.singletonList(UmcStatusConstant.SyncDealResult.NEXT_PROCESSING)).getRows();
                if (CollectionUtils.isEmpty((Collection)rows)) {
                    break;
                }
                this.deal(rows);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            log.debug("\u673a\u6784\u540c\u6b65\u5b9a\u65f6\u4efb\u52a1\u5206\u7247" + reqBo.getSHARDING_PARAMETER() + "\u5904\u7406\u5b8c\u6210");
            this.dealRedisValue(reqBo);
            log.info("\u673a\u6784\u5b9a\u65f6\u4efb\u52a1\u5206\u7247\u6267\u884c\u5b8c\u6210" + reqBo.getSHARDING_PARAMETER() + "\u7f13\u5b58keys {}", (Object)this.cacheClient.getkeys("SYNC_ORG_INFO_KEY*"));
        }
        return dycOrgInfoSyncServiceRspBo;
    }

    private void deal(List<UmcOrgInfoSyncTmpBo> rows) {
        if (!CollectionUtils.isEmpty(rows)) {
            List<UmcOrgInfoSyncTmpBo> updateUmcOrgInfoSyncTmpBos;
            this.updateTempDataState(UmcStatusConstant.SyncDealResult.DEALING, rows.stream().map(UmcOrgInfoSyncTmpBo::getId).collect(Collectors.toList()));
            Map<String, UmcOrgInfoBo> umcOrgInfoBoMap = this.getStringUmcOrgInfoBoMap(rows);
            List<UmcOrgInfoSyncTmpBo> addUmcOrgInfoSyncTmpBos = rows.stream().filter(umcOrgInfoSyncTmpBo -> !umcOrgInfoBoMap.containsKey(umcOrgInfoSyncTmpBo.getOrgCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(addUmcOrgInfoSyncTmpBos)) {
                this.dealAdd(addUmcOrgInfoSyncTmpBos);
            }
            if (!CollectionUtils.isEmpty(updateUmcOrgInfoSyncTmpBos = rows.stream().filter(umcOrgInfoSyncTmpBo -> umcOrgInfoBoMap.containsKey(umcOrgInfoSyncTmpBo.getOrgCode())).peek(umcOrgInfoSyncTmpBo -> umcOrgInfoSyncTmpBo.setOrgId(((UmcOrgInfoBo)umcOrgInfoBoMap.get(umcOrgInfoSyncTmpBo.getOrgCode())).getOrgId())).collect(Collectors.toList()))) {
                this.dealUpdate(updateUmcOrgInfoSyncTmpBos);
            }
        }
    }

    private void updateTempDataState(Integer state, List<Long> ids) {
        UmcOrgInfoSyncTempUpdateServiceReqBo umcOrgInfoSyncTempUpdateServiceReqBo = new UmcOrgInfoSyncTempUpdateServiceReqBo();
        umcOrgInfoSyncTempUpdateServiceReqBo.setSyncDealResult(state);
        umcOrgInfoSyncTempUpdateServiceReqBo.setTempIds(ids);
        this.umcOrgInfoSyncTempUpdateService.updateOrgInfoSyncTempState(umcOrgInfoSyncTempUpdateServiceReqBo);
    }

    private void dealUpdate(List<UmcOrgInfoSyncTmpBo> updateUmcOrgInfoSyncTmpBos) {
        UmcQryOrgInfoSyncTempDealServiceReqBo umcQryOrgInfoSyncTempDealServiceReqBo = new UmcQryOrgInfoSyncTempDealServiceReqBo();
        umcQryOrgInfoSyncTempDealServiceReqBo.setDealType(UmcCommConstant.SyncDealType.UPDATE);
        umcQryOrgInfoSyncTempDealServiceReqBo.setUmcOrgInfoSyncTmpBos(updateUmcOrgInfoSyncTmpBos);
        UmcQryOrgInfoSyncTempDealServiceRspBo rspBo = this.umcQryOrgInfoSyncTempDealService.dealOrgInfoSync(umcQryOrgInfoSyncTempDealServiceReqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            AuthOrgInfoSyncTempDealServiceReqBo authOrgInfoSyncTempDealServiceReqBo = new AuthOrgInfoSyncTempDealServiceReqBo();
            authOrgInfoSyncTempDealServiceReqBo.setDealType(UmcCommConstant.SyncDealType.UPDATE);
            authOrgInfoSyncTempDealServiceReqBo.setDealRspBoList(JUtil.jsl((List)rspBo.getDealRspBoList(), AuthUmcOrgInfoSyncTempDealBo.class));
            authOrgInfoSyncTempDealServiceReqBo.setOrgTagRels(JUtil.jsl((List)rspBo.getOrgTagRels(), AuthOrgTagRelBo.class));
            AuthOrgInfoSyncTempDealServiceRspBo authOrgInfoSyncTempDealServiceRspBo = this.authOrgInfoSyncTempDealService.dealAuthOrgInfoSync(authOrgInfoSyncTempDealServiceReqBo);
            if ("0000".equals(authOrgInfoSyncTempDealServiceRspBo.getRespCode())) {
                this.deleteTempData(rspBo);
            }
        }
    }

    private void deleteTempData(UmcQryOrgInfoSyncTempDealServiceRspBo rspBo) {
        UmcOrgInfoSyncTempDeleteServiceReqBo umcOrgInfoSyncTempDeleteServiceReqBo = new UmcOrgInfoSyncTempDeleteServiceReqBo();
        umcOrgInfoSyncTempDeleteServiceReqBo.setTempIds(rspBo.getDealRspBoList().stream().map(UmcQryOrgInfoSyncTempDealRspBo::getTempId).collect(Collectors.toList()));
        this.umcOrgInfoSyncTempDeleteService.deleteSyncOrgTemp(umcOrgInfoSyncTempDeleteServiceReqBo);
    }

    private void dealAdd(List<UmcOrgInfoSyncTmpBo> addUmcOrgInfoSyncTmpBos) {
        UmcQryOrgInfoSyncTempDealServiceReqBo umcQryOrgInfoSyncTempDealServiceReqBo = new UmcQryOrgInfoSyncTempDealServiceReqBo();
        umcQryOrgInfoSyncTempDealServiceReqBo.setDealType(UmcCommConstant.SyncDealType.ADD);
        umcQryOrgInfoSyncTempDealServiceReqBo.setUmcOrgInfoSyncTmpBos(addUmcOrgInfoSyncTmpBos);
        UmcQryOrgInfoSyncTempDealServiceRspBo rspBo = this.umcQryOrgInfoSyncTempDealService.dealOrgInfoSync(umcQryOrgInfoSyncTempDealServiceReqBo);
        if ("0000".equals(rspBo.getRespCode())) {
            AuthOrgInfoSyncTempDealServiceReqBo authOrgInfoSyncTempDealServiceReqBo = new AuthOrgInfoSyncTempDealServiceReqBo();
            authOrgInfoSyncTempDealServiceReqBo.setDealType(UmcCommConstant.SyncDealType.ADD);
            authOrgInfoSyncTempDealServiceReqBo.setDealRspBoList(JUtil.jsl((List)rspBo.getDealRspBoList(), AuthUmcOrgInfoSyncTempDealBo.class));
            authOrgInfoSyncTempDealServiceReqBo.setOrgTagRels(JUtil.jsl((List)rspBo.getOrgTagRels(), AuthOrgTagRelBo.class));
            AuthOrgInfoSyncTempDealServiceRspBo authOrgInfoSyncTempDealServiceRspBo = this.authOrgInfoSyncTempDealService.dealAuthOrgInfoSync(authOrgInfoSyncTempDealServiceReqBo);
            if ("0000".equals(authOrgInfoSyncTempDealServiceRspBo.getRespCode())) {
                this.deleteTempData(rspBo);
            }
        }
    }

    private Map<String, UmcOrgInfoBo> getStringUmcOrgInfoBoMap(List<UmcOrgInfoSyncTmpBo> rows) {
        List orgCodes = rows.stream().map(UmcOrgInfoSyncTmpBo::getOrgCode).collect(Collectors.toList());
        UmcQryOrgInfoListPageReqBo umcQryOrgInfoListPageReqBo = new UmcQryOrgInfoListPageReqBo();
        umcQryOrgInfoListPageReqBo.setPageNo(-1);
        umcQryOrgInfoListPageReqBo.setPageSize(-1);
        umcQryOrgInfoListPageReqBo.setOrgCodes(orgCodes);
        UmcQryOrgInfoListPageRspBo umcQryOrgInfoListPageRspBo = this.umcQryOrgInfoListPageService.qryOrgInfoListPage(umcQryOrgInfoListPageReqBo);
        if (CollectionUtils.isEmpty((Collection)umcQryOrgInfoListPageRspBo.getRows())) {
            return new HashMap<String, UmcOrgInfoBo>(0);
        }
        return umcQryOrgInfoListPageRspBo.getRows().stream().collect(Collectors.toMap(UmcOrgInfoBo::getOrgCode, o -> o));
    }

    private UmcQryOrgInfoSyncTempListServiceRspBo getUmcQryOrgInfoSyncTempListServiceRspBo(DycOrgInfoSyncServiceReqBo reqBo, Integer pageNo, Integer pageSize, List<Integer> stateList) {
        UmcQryOrgInfoSyncTempListServiceReqBo umcQryOrgInfoSyncTempListServiceReqBo = new UmcQryOrgInfoSyncTempListServiceReqBo();
        umcQryOrgInfoSyncTempListServiceReqBo.setPageNo(pageNo.intValue());
        umcQryOrgInfoSyncTempListServiceReqBo.setPageSize(pageSize.intValue());
        umcQryOrgInfoSyncTempListServiceReqBo.setDealResultList(stateList);
        umcQryOrgInfoSyncTempListServiceReqBo.setOrderBy("sync_time asc");
        umcQryOrgInfoSyncTempListServiceReqBo.setSHARDING_SHARDNUM(reqBo.getSHARDING_SHARDNUM());
        umcQryOrgInfoSyncTempListServiceReqBo.setSHARDING_PARAMETER(reqBo.getSHARDING_PARAMETER());
        UmcQryOrgInfoSyncTempListServiceRspBo qryOrgInfoSyncTempListServiceRspBo = this.umcQryOrgInfoSyncTempListService.qryOrgInfoSyncTempList(umcQryOrgInfoSyncTempListServiceReqBo);
        if (!"0000".equals(qryOrgInfoSyncTempListServiceRspBo.getRespCode())) {
            throw new ZTBusinessException(qryOrgInfoSyncTempListServiceRspBo.getRespDesc());
        }
        return qryOrgInfoSyncTempListServiceRspBo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealRedisValue(DycOrgInfoSyncServiceReqBo reqBo) {
        Object object = this.$lock;
        synchronized (object) {
            this.cacheClient.setnx(SYNC_ORG_INFO_KEY_SUP, (Object)reqBo.getSHARDING_SHARDNUM());
            int surplus = Integer.parseInt(this.cacheClient.get(SYNC_ORG_INFO_KEY_SUP).toString());
            if (surplus == 1) {
                this.cacheClient.delete(SYNC_ORG_INFO_KEY_SUP);
                this.cacheClient.delete(SYNC_ORG_INFO_KEY_THREAD_COUNT);
                Set threadNumSet = this.cacheClient.getkeys("SYNC_ORG_INFO_KEY*");
                if (!CollectionUtils.isEmpty((Collection)threadNumSet)) {
                    threadNumSet.forEach(key -> this.cacheClient.delete(key));
                } else {
                    log.error("redis\u7f13\u5b58\u6e05\u695a\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u5bf9\u5e94key");
                }
            } else {
                this.cacheClient.set(SYNC_ORG_INFO_KEY_SUP, (Object)(surplus - 1));
            }
        }
    }
}

