/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycGeneralTabsCountQueryFunction;
import com.tydic.dyc.atom.common.bo.DycCommonTabsCountBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralTabsCountQueryFuncRspBO;
import com.tydic.dyc.base.bo.DycCommonButtonRspBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabButtonConfBo;
import com.tydic.dyc.base.bo.DycCommonUmcTabIdConfBo;
import com.tydic.dyc.base.bo.DycCommonUocTabCountsBO;
import com.tydic.dyc.base.conf.CommonListQueryProperties;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.busicommon.order.api.DycUocAfterServiceInfoListQryService;
import com.tydic.dyc.busicommon.order.bo.DycUocAfterInfoListQryServiceRspPageDataBo;
import com.tydic.dyc.busicommon.order.bo.DycUocAfterServiceInfoListQryServiceReqBo;
import com.tydic.dyc.busicommon.order.bo.DycUocAfterServiceInfoListQryServiceRspBo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.order.api.DycUocAfterServiceInfoListQryService"})
public class DycUocAfterServiceInfoListQryServiceImpl
implements DycUocAfterServiceInfoListQryService {
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private DycGeneralTabsCountQueryFunction dycGeneralTabsCountQueryFunction;
    @Autowired
    private CommonListQueryProperties properties;

    @Override
    @PostMapping(value={"qryAfterInfoList"})
    public DycUocAfterServiceInfoListQryServiceRspBo qryAfterInfoList(@RequestBody DycUocAfterServiceInfoListQryServiceReqBo reqBo) {
        this.validateArg(reqBo);
        this.setAuth(reqBo);
        DycUocAfterServiceInfoListQryServiceRspBo rspBO = this.qryEsData(reqBo);
        this.setButtons(reqBo, rspBO);
        this.setTabCount(reqBo, rspBO);
        return rspBO;
    }

    private void validateArg(DycUocAfterServiceInfoListQryServiceReqBo reqBo) {
        List<DycCommonUmcTabIdConfBo> theTabConf;
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new BaseBusinessException("B00001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty(reqBo.getTabIdConfList())) {
            throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (DycCommonUmcTabIdConfBo tabIdConfBo : reqBo.getTabIdConfList()) {
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getTabId())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[tabId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getTabName())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[tabName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getDefaultFlag())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[defaultFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getQuantityFlag())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[quantityFlag]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getSort())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[sort]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtil.isEmpty((Object)tabIdConfBo.getParamJson())) {
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[paramJson]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!ObjectUtil.isNotEmpty((Object)tabIdConfBo.getUmcTacheButtonList())) continue;
            for (DycCommonUmcTabButtonConfBo btn : tabIdConfBo.getUmcTacheButtonList()) {
                if (ObjectUtil.isEmpty((Object)btn)) {
                    throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[umcTacheButtonList]\u4e2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtil.isEmpty((Object)btn.getBtnCode())) {
                    throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[umcTacheButtonList]\u4e2d\u5bf9\u8c61[btnCode]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtil.isEmpty((Object)btn.getBtnName())) continue;
                throw new BaseBusinessException("B00001", "\u5165\u53c2[tabIdConfList]\u4e2d\u5bf9\u8c61[umcTacheButtonList]\u4e2d\u5bf9\u8c61[btnName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        List defaultTabList = reqBo.getTabIdConfList().stream().filter(item -> CommonListQueryProperties.DEFAULT_FLAG_YES.equals(item.getDefaultFlag())).collect(Collectors.toList());
        if (ObjectUtil.isEmpty(defaultTabList)) {
            throw new BaseBusinessException("B00002", "\u8be5\u83dc\u5355\u4e0b\uff0c\u6ca1\u6709\u914d\u7f6e\u9ed8\u8ba4\u9875\u7b7e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (defaultTabList.size() > 1) {
            throw new BaseBusinessException("B00002", "\u8be5\u83dc\u5355\u4e0b\uff0c\u914d\u7f6e\u4e86\u591a\u4e2a\u9ed8\u8ba4\u9875\u7b7e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTabId())) {
            reqBo.setTabId(((DycCommonUmcTabIdConfBo)defaultTabList.get(0)).getTabId());
        }
        if (ObjectUtil.isEmpty(theTabConf = reqBo.getTabIdConfList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId()))) {
            throw new BaseBusinessException("B00002", "\u8be5\u9875\u7b7eid(" + reqBo.getTabId() + ")\u672a\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    private void setTabCount(DycUocAfterServiceInfoListQryServiceReqBo reqBo, DycUocAfterServiceInfoListQryServiceRspBo rspBO) {
        ArrayList<DycGeneralTabsCountQueryBO> countList = new ArrayList<DycGeneralTabsCountQueryBO>();
        List<DycCommonUmcTabIdConfBo> tabIdConfList = reqBo.getTabIdConfList();
        for (DycCommonUmcTabIdConfBo tab : tabIdConfList) {
            if (!CommonListQueryProperties.QUANTITY_FLAG_YES.equals(tab.getQuantityFlag())) continue;
            DycGeneralTabsCountQueryBO cBo = new DycGeneralTabsCountQueryBO();
            cBo.setTabId(tab.getTabId());
            cBo.setTabName(tab.getTabName());
            if (reqBo.getTabId().equals(tab.getTabId())) {
                JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)));
                reqBoJsonObj.putAll((Map)JSONObject.parseObject((String)tab.getParamJson()));
                cBo.setParamJsonStr(reqBoJsonObj.toJSONString());
            } else {
                cBo.setParamJsonStr(tab.getParamJson());
            }
            countList.add(cBo);
        }
        DycGeneralTabsCountQueryFuncReqBO countReqBo = new DycGeneralTabsCountQueryFuncReqBO();
        countReqBo.setDycGeneralTabsCountQueryBOS(countList);
        DycGeneralTabsCountQueryFuncRspBO tabsCountRsp = this.dycGeneralTabsCountQueryFunction.getTabsCount(countReqBo);
        if ("0000".equals(tabsCountRsp.getRespCode())) {
            ArrayList<DycCommonUocTabCountsBO> tabCountList = new ArrayList<DycCommonUocTabCountsBO>();
            for (DycCommonTabsCountBO dycCommonTabsCountBO : tabsCountRsp.getTabCountList()) {
                DycCommonUocTabCountsBO rspCountBo = new DycCommonUocTabCountsBO();
                rspCountBo.setTabCount(dycCommonTabsCountBO.getTabCount());
                rspCountBo.setTabNameCount(dycCommonTabsCountBO.getTabNameCount());
                rspCountBo.setTabId(Long.valueOf(dycCommonTabsCountBO.getTabId().intValue()));
                rspCountBo.setTabName(dycCommonTabsCountBO.getTabName());
                tabCountList.add(rspCountBo);
            }
            rspBO.setTabCountList(tabCountList);
        }
    }

    private void setButtons(DycUocAfterServiceInfoListQryServiceReqBo reqBo, DycUocAfterServiceInfoListQryServiceRspBo rspBO) {
        List theTabBtnList = reqBo.getTabIdConfList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId()).get(0).getUmcTacheButtonList();
        if (ObjectUtil.isNotEmpty((Object)theTabBtnList)) {
            Map<String, List<DycCommonUmcTabButtonConfBo>> afStatusMap = theTabBtnList.stream().collect(Collectors.groupingBy(DycCommonUmcTabButtonConfBo::getDataStatus));
            for (DycUocAfterInfoListQryServiceRspPageDataBo afOrder : rspBO.getRows()) {
                HashSet<DycCommonButtonRspBo> buttons = new HashSet<DycCommonButtonRspBo>();
                List<DycCommonUmcTabButtonConfBo> uocButtonFuncBos = afStatusMap.get(afOrder.getProcState());
                if (ObjectUtil.isNotEmpty(uocButtonFuncBos)) {
                    for (DycCommonUmcTabButtonConfBo uocButtonFuncBo : uocButtonFuncBos) {
                        DycCommonButtonRspBo btn = new DycCommonButtonRspBo();
                        buttons.add(btn);
                        btn.setBtnCode(uocButtonFuncBo.getBtnCode());
                        btn.setBtnName(uocButtonFuncBo.getBtnName());
                        if (!ObjectUtil.isNotEmpty((Object)afOrder.getFormUrl()) || !ObjectUtil.isNotEmpty((Object)afOrder.getProcState()) || !afOrder.getProcState().equals(uocButtonFuncBo.getFormTacheCode())) continue;
                        btn.setUri(this.getBtnUrl(reqBo.getReflected(), afOrder.getFormUrl(), uocButtonFuncBo.getFormParam()));
                    }
                }
                afOrder.setButtons(new ArrayList<DycCommonButtonRspBo>(buttons));
            }
        }
    }

    private String getBtnUrl(Boolean reflected, String dataFormUrl, String formParam) {
        String url = "";
        if (reflected != null && reflected.booleanValue()) {
            url = this.properties.getButtonUrlPrefix() + dataFormUrl;
        } else {
            String fromUrl = dataFormUrl;
            if (fromUrl.endsWith(".html")) {
                fromUrl = fromUrl.substring(0, fromUrl.length() - 5);
            }
            url = this.properties.getButtonUrlPrefixReal() + fromUrl;
        }
        if (StringUtils.isNotBlank((CharSequence)formParam)) {
            return url + "?" + formParam;
        }
        return url;
    }

    private DycUocAfterServiceInfoListQryServiceRspBo qryEsData(DycUocAfterServiceInfoListQryServiceReqBo reqBo) {
        JSONObject reqBoJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)));
        List<DycCommonUmcTabIdConfBo> theTabConfList = reqBo.getTabIdConfList().stream().collect(Collectors.groupingBy(DycCommonUmcTabIdConfBo::getTabId)).get(reqBo.getTabId());
        if (ObjectUtil.isNotEmpty((Object)theTabConfList.get(0).getParamJson())) {
            reqBoJsonObj.putAll((Map)JSON.parseObject((String)theTabConfList.get(0).getParamJson()));
        }
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqBoJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        return (DycUocAfterServiceInfoListQryServiceRspBo)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocAfterServiceInfoListQryServiceRspBo.class));
    }

    private void setAuth(DycUocAfterServiceInfoListQryServiceReqBo reqBo) {
        if ("1".equals(reqBo.getIsProfessionalOrgExt())) {
            reqBo.setSubmitterOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? "" : String.valueOf(reqBo.getUserId()));
        } else if ("2".equals(reqBo.getIsProfessionalOrgExt())) {
            reqBo.setSupplierId(ObjectUtil.isEmpty((Object)reqBo.getSupId()) ? "" : String.valueOf(reqBo.getSupId()));
        } else if ("0".equals(reqBo.getIsProfessionalOrgExt())) {
            // empty if block
        }
    }
}

