/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.busicommon.ics.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.busicommon.ics.api.DycIcsQrySaleOrderListService;
import com.tydic.dyc.busicommon.ics.bo.DycIcsQrySaleOrderInfoChildRspBO;
import com.tydic.dyc.busicommon.ics.bo.DycIcsQrySaleOrderInfoRspBO;
import com.tydic.dyc.busicommon.ics.bo.DycIcsQrySaleOrderItemInfoRspBO;
import com.tydic.dyc.busicommon.ics.bo.DycIcsQrySaleOrderListReqBO;
import com.tydic.dyc.busicommon.ics.bo.DycIcsQrySaleOrderListRspBO;
import com.tydic.dyc.busicommon.ics.bo.DycUocSalOrderListQryRspBO;
import com.tydic.dyc.busicommon.ics.bo.DycUocSaleOrderCommodityInfoBO;
import com.tydic.dyc.busicommon.ics.bo.DycUocSaleOrderInfoBO;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.busicommon.ics.api.DycIcsQrySaleOrderListService"})
public class DycIcsQrySaleOrderListServiceImpl
implements DycIcsQrySaleOrderListService {
    private static final Logger log = LoggerFactory.getLogger(DycIcsQrySaleOrderListServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;

    @Override
    @PostMapping(value={"queryMyOrderList"})
    public DycIcsQrySaleOrderListRspBO queryMyOrderList(@RequestBody DycIcsQrySaleOrderListReqBO reqBO) {
        JSONObject reqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqJsonObj.toJSONString());
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocSalOrderListQryRspBO dycUocSalOrderListQryRspBO = (DycUocSalOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocSalOrderListQryRspBO.class));
        return this.buildRsp(dycUocSalOrderListQryRspBO);
    }

    private DycIcsQrySaleOrderListRspBO buildRsp(DycUocSalOrderListQryRspBO dycUocSalOrderListQryRspBO) {
        DycIcsQrySaleOrderListRspBO rspBO = new DycIcsQrySaleOrderListRspBO();
        ArrayList<DycIcsQrySaleOrderInfoRspBO> rspRows = new ArrayList<DycIcsQrySaleOrderInfoRspBO>(dycUocSalOrderListQryRspBO.getRows().size());
        for (DycUocSaleOrderInfoBO row : dycUocSalOrderListQryRspBO.getRows()) {
            DycIcsQrySaleOrderInfoRspBO infoRspBO = new DycIcsQrySaleOrderInfoRspBO();
            infoRspBO.setSaleVoucherNo(row.getSaleOrderNo());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String createTime = dateFormat.format(row.getCreateTime());
            infoRspBO.setCreateTime(createTime);
            infoRspBO.setOrderSource(row.getOrderSource());
            DycIcsQrySaleOrderInfoChildRspBO childRspBO = new DycIcsQrySaleOrderInfoChildRspBO();
            childRspBO.setSaleVoucherNo(row.getSaleOrderNo());
            childRspBO.setSaleStateStr(row.getSaleOrderStateStr());
            DecimalFormat decimalFormat = new DecimalFormat("0.00");
            childRspBO.setSaleFeeMoney(decimalFormat.format(row.getSaleOrderTotal()));
            childRspBO.setCreateTime(createTime);
            childRspBO.setOrderId(row.getOrderId());
            childRspBO.setSaleVoucherId(row.getSaleOrderId());
            ArrayList<DycIcsQrySaleOrderInfoChildRspBO> childRspBOS = new ArrayList<DycIcsQrySaleOrderInfoChildRspBO>(1);
            ArrayList<DycIcsQrySaleOrderItemInfoRspBO> itemInfoRspBOS = new ArrayList<DycIcsQrySaleOrderItemInfoRspBO>();
            for (DycUocSaleOrderCommodityInfoBO commodityInfo : row.getCommodityInfos()) {
                DycIcsQrySaleOrderItemInfoRspBO orderItemInfoRspBO = new DycIcsQrySaleOrderItemInfoRspBO();
                orderItemInfoRspBO.setPicUlr(commodityInfo.getSkuMainPicUrl());
                orderItemInfoRspBO.setSkuName(commodityInfo.getSkuName());
                orderItemInfoRspBO.setSellingPrice(decimalFormat.format(commodityInfo.getSalePrice()));
                orderItemInfoRspBO.setPurchaseCount(decimalFormat.format(commodityInfo.getPurchaseCount()));
                itemInfoRspBOS.add(orderItemInfoRspBO);
            }
            childRspBO.setOrderItemList(itemInfoRspBOS);
            childRspBOS.add(childRspBO);
            infoRspBO.setChildOrderList(childRspBOS);
            childRspBOS.add(childRspBO);
            infoRspBO.setChildOrderList(childRspBOS);
            rspRows.add(infoRspBO);
        }
        rspBO.setRows(rspRows);
        return rspBO;
    }
}

