/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.user.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.api.DycUmcCustServiceTenantUpdateFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycUmcCustServiceTenantUpdateFuncReqBo;
import com.tydic.dyc.authority.constants.AuthConstant;
import com.tydic.dyc.authority.service.domainservice.AuthEnterpriseUserRegisterRefillService;
import com.tydic.dyc.authority.service.domainservice.bo.AuthDistributeBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRefillReqBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthEnterpriseUserRegisterRefillRspBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRegisterRefillOrgInfoBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRegisterRefillUserInfoBo;
import com.tydic.dyc.authority.service.domainservice.bo.AuthRegisterRefillUserRoleInfoBo;
import com.tydic.dyc.authority.service.organization.bo.AuthOrgTagRelBo;
import com.tydic.dyc.authority.service.user.bo.AuthCustInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserTagRelBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.base.utils.SaltUtils;
import com.tydic.dyc.common.member.user.api.DycUmcUserOrEnterpriseRegistReFillService;
import com.tydic.dyc.common.member.user.bo.DycUmcUserOrEnterpriseRegistReFillReqBo;
import com.tydic.dyc.common.member.user.bo.DycUmcUserOrEnterpriseRegistReFillRspBo;
import com.tydic.dyc.common.member.vfcode.api.VerifyCodeService;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeReqBo;
import com.tydic.dyc.common.member.vfcode.bo.VerifyCodeRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.service.domainservice.UmcEnterpriseUserRegisterRefillService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterRefillReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcEnterpriseUserRegisterRefillRspBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcRegisterRefillOrgInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcRegisterRefillUserInfoBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcUserRegisterApplyInfoBo;
import com.tydic.dyc.umc.service.enterprise.UmcDycCheckEnterpriseExistService;
import com.tydic.dyc.umc.service.enterprise.UmcRegistDetailQryService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDycCheckEnterpriseExistReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDycCheckEnterpriseExistRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseContactBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgTagRelBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcRegistDetailBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcRegistDetailQryReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcRegistDetailQryRspBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcEnterpriseContactApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgInfoApplyBo;
import com.tydic.dyc.umc.service.enterpriseapply.bo.UmcOrgTagRelApplyBo;
import com.tydic.dyc.umc.service.user.UmcUserInfoCheckService;
import com.tydic.dyc.umc.service.user.bo.UmcCustInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoCheckReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoCheckRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserTagRelBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcCustInfoApplyBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcUserRoleRelApplyBo;
import com.tydic.dyc.umc.service.userapply.bo.UmcUserTagRelApplyBo;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umc.security.utils.EncryptUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.user.api.DycUmcUserOrEnterpriseRegistReFillService"})
public class DycUmcUserOrEnterpriseRegistReFillServiceImpl
implements DycUmcUserOrEnterpriseRegistReFillService {
    private static final String personal = "1";
    private static final String org = "2";
    private static final Integer AVAILABLE = 1;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${CHECK_EMAIL_CODE:false}")
    private Boolean CHECK_EMAIL_CODE;
    @Value(value="${CHECK_MOBILE_CODE:false}")
    private Boolean CHECK_MOBILE_CODE;
    @Autowired
    private UmcUserInfoCheckService umcUserInfoCheckService;
    @Autowired
    private UmcDycCheckEnterpriseExistService umcDycCheckEnterpriseExistService;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${register_default_enterprise_role:405395039912734721}")
    private String registerDefaultEnterpriseRole;
    @Value(value="${register_default_personal_role:405395039912734722}")
    private String registerDefaultPersonalRole;
    @Value(value="${register_audit_flag:false}")
    private Boolean register_audit_flag;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Value(value="${password_eff:90}")
    private Integer password_eff;
    @Value(value="${ext.regist.audit.key:supplier_baseinfo_audit}")
    private String extRegistAuditKey;
    @Value(value="${custServiceEnable:false}")
    private boolean custServiceEnable;
    @Autowired
    private DycUmcCustServiceTenantUpdateFunction dycUmcCustServiceTenantUpdateFunction;
    @Value(value="${emaiRegisterVfcode:login_vf_code_emaiRegisterVfcode}")
    private String emaiRegisterVfcode;
    @Value(value="${mobileRegistVfcode:login_vf_code_mobileRegistVfcode}")
    private String mobileRegistVfcode;
    @Autowired
    private VerifyCodeService verifyCodeService;
    private static final Long DEFAULT_TANENT_ID = 10000L;
    @Autowired
    private UmcRegistDetailQryService umcRegistDetailQryService;
    private static final String NEED_AUDIT_FLAG = "0";
    private static final String NO_AUDIT_FLAG = "1";
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private AuthEnterpriseUserRegisterRefillService authEnterpriseUserRegisterRefillService;
    @Autowired
    private UmcEnterpriseUserRegisterRefillService umcEnterpriseUserRegisterRefillService;
    private static final Integer ORG_DEEP = 3;
    private static final Long DEFAULT_ROLE_ID = 5L;

    @Override
    @PostMapping(value={"registReFillAccount"})
    public DycUmcUserOrEnterpriseRegistReFillRspBo registReFillAccount(@RequestBody DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        this.checkInitReq(reqBo);
        this.codeCheck(reqBo);
        this.checkUserInfo(reqBo);
        if (null == reqBo.getTenantId()) {
            reqBo.setTenantId(DEFAULT_TANENT_ID);
        }
        this.checkOrgExist(reqBo);
        UmcRegistDetailBo applyInfo = this.getApplyInfo(reqBo.getOrgIdIn());
        Long applyId = applyInfo.getApplyId();
        String taskId = applyInfo.getTaskId();
        String encrypt = this.encryptUtils.encryptByType(AesUtil.decryptStr((String)reqBo.getPasswd(), (String)this.ORIGINAL_KEY), this.encryptType);
        String salt = SaltUtils.getSerialNo((int)8);
        String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
        AuthEnterpriseUserRegisterRefillRspBo authEnterpriseUserRegisterRefillRspBo = this.updateOrgUserAuth(reqBo, pwd, salt);
        this.updateOrgInfo(reqBo, authEnterpriseUserRegisterRefillRspBo, applyId, pwd);
        this.flowBusiProcess(applyId, taskId, reqBo);
        this.syncCs(reqBo);
        return this.getRsp(reqBo, authEnterpriseUserRegisterRefillRspBo);
    }

    private void flowBusiProcess(Long applyId, String taskId, DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(taskId);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("applyId", applyId);
        variables.put("orderId", applyId);
        variables.put("auditObjId", applyId);
        variables.put("userId", reqBo.getUserIdIn());
        variables.put("userName", reqBo.getMemName2());
        variables.put("name", reqBo.getMemName2());
        variables.put("orgName", reqBo.getOrgNameWeb());
        variables.put("auditStartFlag", 1);
        if (this.register_audit_flag.booleanValue()) {
            variables.put("auditFlag", 1);
        } else {
            variables.put("auditFlag", 0);
        }
        variables.put("auditCompleteFlag", 1);
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546\u6ce8\u518c\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private DycUmcUserOrEnterpriseRegistReFillRspBo getRsp(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, AuthEnterpriseUserRegisterRefillRspBo authModifyUserInfoRspBo) {
        DycUmcUserOrEnterpriseRegistReFillRspBo rspBo = new DycUmcUserOrEnterpriseRegistReFillRspBo();
        if (this.register_audit_flag.booleanValue()) {
            rspBo.setAuditStatus("1");
        } else {
            rspBo.setAuditStatus(NEED_AUDIT_FLAG);
        }
        rspBo.setUserId(authModifyUserInfoRspBo.getUserInfoBo().getUserId());
        rspBo.setCustId(authModifyUserInfoRspBo.getUserInfoBo().getCustId());
        rspBo.setOrgId(authModifyUserInfoRspBo.getUserInfoBo().getOrgId());
        rspBo.setRegAccount(reqBo.getRegAccount());
        return rspBo;
    }

    private void syncCs(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        if (this.custServiceEnable) {
            DycUmcCustServiceTenantUpdateFuncReqBo dycUmcCustServiceTenantUpdateFuncReqBo = new DycUmcCustServiceTenantUpdateFuncReqBo();
            dycUmcCustServiceTenantUpdateFuncReqBo.setTenantId(Convert.toStr((Object)reqBo.getOrgIdIn()));
            dycUmcCustServiceTenantUpdateFuncReqBo.setTenantName(reqBo.getOrgNameWeb());
            this.dycUmcCustServiceTenantUpdateFunction.tenantUpdate(dycUmcCustServiceTenantUpdateFuncReqBo);
        }
    }

    public void checkInitReq(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdIn()) {
            throw new ZTBusinessException("\u5165\u53c2\u673a\u6784ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserIdIn()) {
            throw new ZTBusinessException("\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getCustIdIn()) {
            throw new ZTBusinessException("\u5165\u53c2\u5ba2\u6237ID\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegisterType())) {
            throw new ZTBusinessException("\u6ce8\u518c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegAccount())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPasswd())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getConfirmPasswd())) {
            throw new ZTBusinessException("\u786e\u8ba4\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getMemName2())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u8054\u7cfb\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgNameWeb())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getAliasWeb())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u7b80\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getOrgCodeWeb())) {
            throw new ZTBusinessException("\u7ec4\u7ec7\u673a\u6784\u7b80\u79f0\u9996\u5b57\u6bcd\u7f29\u5199\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCertNo())) {
            throw new ZTBusinessException("\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTradeCapacity())) {
            throw new ZTBusinessException("\u4f01\u4e1a\u8d38\u6613\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getTradeType())) {
            throw new ZTBusinessException("\u884c\u4e1a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCertNo())) {
            throw new ZTBusinessException("\u8eab\u4efd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegEmail())) {
            throw new ZTBusinessException("\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"1".equals(reqBo.getRegisterType()) && StringUtils.isBlank((CharSequence)reqBo.getEmailCheck())) {
            throw new ZTBusinessException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRegMobile())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getSmsCheck())) {
            throw new ZTBusinessException("\u624b\u673a\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getEnterpriseContactId()) {
            throw new ZTBusinessException("\u4f01\u4e1a\u8054\u7cfb\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public void checkUserInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        if (!AesUtil.decryptStr((String)reqBo.getPasswd(), (String)this.ORIGINAL_KEY).equals(AesUtil.decryptStr((String)reqBo.getConfirmPasswd(), (String)this.ORIGINAL_KEY))) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u4e00\u81f4");
        }
        UmcUserInfoCheckReqBo checkAccountReqBo = new UmcUserInfoCheckReqBo();
        checkAccountReqBo.setRegAccount(reqBo.getRegAccount());
        checkAccountReqBo.setCustId(reqBo.getCustIdIn());
        UmcUserInfoCheckRspBo checkAccountRspBo = this.umcUserInfoCheckService.checkUserInfo(checkAccountReqBo);
        if (!"0000".equals(checkAccountRspBo.getRespCode())) {
            throw new ZTBusinessException(checkAccountRspBo.getRespDesc());
        }
        if (!AVAILABLE.equals(checkAccountRspBo.getCheckResult())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u5df2\u5b58\u5728");
        }
        UmcUserInfoCheckReqBo checkMobileReqBo = new UmcUserInfoCheckReqBo();
        checkMobileReqBo.setRegMobile(reqBo.getRegMobile());
        checkMobileReqBo.setCustId(reqBo.getCustIdIn());
        UmcUserInfoCheckRspBo checkMobileRspBo = this.umcUserInfoCheckService.checkUserInfo(checkMobileReqBo);
        if (!"0000".equals(checkMobileRspBo.getRespCode())) {
            throw new ZTBusinessException(checkMobileRspBo.getRespDesc());
        }
        if (!AVAILABLE.equals(checkMobileRspBo.getCheckResult())) {
            throw new ZTBusinessException("\u624b\u673a\u53f7\u5df2\u5b58\u5728");
        }
        UmcUserInfoCheckReqBo checkCertNoReqBo = new UmcUserInfoCheckReqBo();
        checkCertNoReqBo.setRegMobile(reqBo.getRegMobile());
        checkCertNoReqBo.setCustId(reqBo.getCustIdIn());
        UmcUserInfoCheckRspBo checkCertNoRspBo = this.umcUserInfoCheckService.checkUserInfo(checkCertNoReqBo);
        if (!"0000".equals(checkCertNoRspBo.getRespCode())) {
            throw new ZTBusinessException(checkCertNoRspBo.getRespDesc());
        }
        if (!AVAILABLE.equals(checkCertNoRspBo.getCheckResult())) {
            throw new ZTBusinessException("\u8bc1\u4ef6\u53f7\u5df2\u5b58\u5728");
        }
    }

    public void codeCheck(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        VerifyCodeRspBo verifyCodeRspBo;
        VerifyCodeReqBo verifyCodeReqBo;
        if (this.CHECK_EMAIL_CODE.booleanValue() && org.equals(reqBo.getRegisterType())) {
            verifyCodeReqBo = new VerifyCodeReqBo();
            verifyCodeReqBo.setVerifyCode(reqBo.getEmailCheck());
            verifyCodeReqBo.setVerifyValue(reqBo.getRegEmail());
            verifyCodeReqBo.setBusiKey(this.emaiRegisterVfcode);
            verifyCodeRspBo = this.verifyCodeService.checkVerifyCodeForTemp(verifyCodeReqBo);
            if (!"0000".equals(verifyCodeRspBo.getRespCode())) {
                throw new ZTBusinessException("\u90ae\u7bb1\u9a8c\u8bc1\u7801\u5931\u6548");
            }
        }
        if (this.CHECK_MOBILE_CODE.booleanValue()) {
            verifyCodeReqBo = new VerifyCodeReqBo();
            verifyCodeReqBo.setVerifyCode(reqBo.getSmsCheck());
            verifyCodeReqBo.setVerifyValue(reqBo.getRegMobile());
            verifyCodeReqBo.setBusiKey(this.mobileRegistVfcode);
            verifyCodeRspBo = this.verifyCodeService.checkVerifyCodeForTemp(verifyCodeReqBo);
            if (!"0000".equals(verifyCodeRspBo.getRespCode())) {
                throw new ZTBusinessException("\u624b\u673a\u9a8c\u8bc1\u7801\u5931\u6548");
            }
        }
    }

    public void checkOrgExist(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        UmcDycCheckEnterpriseExistReqBo existReqBo = new UmcDycCheckEnterpriseExistReqBo();
        existReqBo.setTenantId(reqBo.getTenantId());
        existReqBo.setOrgCode(reqBo.getOrgCodeWeb());
        existReqBo.setOrgName(reqBo.getOrgNameWeb());
        existReqBo.setCreditNo(reqBo.getOrgCertificateCode());
        existReqBo.setOrgIdWeb(reqBo.getOrgIdIn());
        UmcDycCheckEnterpriseExistRspBo rspBo = this.umcDycCheckEnterpriseExistService.checkEnterprise(existReqBo);
        if (!"0000".equals(rspBo.getRespCode())) {
            throw new ZTBusinessException("\u6821\u9a8c\u673a\u6784\u4fe1\u606f\u5931\u8d25");
        }
        Map map = rspBo.getMap();
        if (this.getValue(map, reqBo.getOrgNameWeb()) > 0) {
            throw new ZTBusinessException("\u673a\u6784\u5df2\u5b58\u5728");
        }
        if (this.getValue(map, reqBo.getCertNo()) > 0) {
            throw new ZTBusinessException("\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5df2\u5b58\u5728");
        }
        if (this.getValue(map, reqBo.getOrgCodeWeb()) > 0) {
            throw new ZTBusinessException("\u673a\u6784\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    private int getValue(Map<String, Integer> map, String str) {
        if (null == map.get(str)) {
            return 0;
        }
        return map.get(str);
    }

    public void updateOrgInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, AuthEnterpriseUserRegisterRefillRspBo authEnterpriseUserRegisterRefillRspBo, Long applyId, String pwd) {
        Date now = new Date();
        UmcRegisterRefillOrgInfoBo umcRegisterRefillOrgInfoBo = this.buildUmcOrgInfo(reqBo, authEnterpriseUserRegisterRefillRspBo.getOrgInfoBo().getOrgId(), authEnterpriseUserRegisterRefillRspBo.getUserInfoBo(), now);
        UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo = this.buildUmcOrgApplyInfo(reqBo, applyId, now, umcRegisterRefillOrgInfoBo);
        UmcRegisterRefillUserInfoBo umcRegisterRefillUserInfoBo = this.buildUmcUserInfo(reqBo, authEnterpriseUserRegisterRefillRspBo, pwd, now);
        UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo = this.buildUmcUserApplyInfo(reqBo, applyId, now, umcRegisterRefillUserInfoBo);
        UmcEnterpriseUserRegisterRefillReqBo umcEnterpriseUserRegisterRefillReqBo = new UmcEnterpriseUserRegisterRefillReqBo();
        umcEnterpriseUserRegisterRefillReqBo.setUmcRegisterRefillOrgInfoBo(umcRegisterRefillOrgInfoBo);
        umcEnterpriseUserRegisterRefillReqBo.setUmcEnterpriseRegisterApplyInfoBo(umcEnterpriseRegisterApplyInfoBo);
        umcEnterpriseUserRegisterRefillReqBo.setUmcRegisterRefillUserInfoBo(umcRegisterRefillUserInfoBo);
        umcEnterpriseUserRegisterRefillReqBo.setUmcUserRegisterApplyInfoBo(umcUserRegisterApplyInfoBo);
        UmcEnterpriseUserRegisterRefillRspBo umcEnterpriseUserRegisterRefillRspBo = this.umcEnterpriseUserRegisterRefillService.dealEnterpriseUserRegisterRefill(umcEnterpriseUserRegisterRefillReqBo);
        if (!"0000".equals(umcEnterpriseUserRegisterRefillRspBo.getRespCode())) {
            throw new ZTBusinessException("\u4fee\u6539\u673a\u6784\u3001\u7528\u6237\u5931\u8d25");
        }
    }

    private UmcUserRegisterApplyInfoBo buildUmcUserApplyInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, Long applyId, Date now, UmcRegisterRefillUserInfoBo umcRegisterRefillUserInfoBo) {
        UmcUserRegisterApplyInfoBo umcUserRegisterApplyInfoBo = (UmcUserRegisterApplyInfoBo)JUtil.js((Object)umcRegisterRefillUserInfoBo, UmcUserRegisterApplyInfoBo.class);
        UmcCustInfoApplyBo applyBo = (UmcCustInfoApplyBo)JUtil.js((Object)umcRegisterRefillUserInfoBo.getCustInfoBo(), UmcCustInfoApplyBo.class);
        applyBo.setApplyId(applyId);
        applyBo.setUpdateOperId(reqBo.getUserIdIn());
        applyBo.setUpdateOperName(reqBo.getMemName2());
        applyBo.setUpdateTime(now);
        List applyBos = JUtil.jsl((List)umcRegisterRefillUserInfoBo.getUserTagRelBoList(), UmcUserTagRelApplyBo.class);
        applyBos.forEach(UmcUserTagRelApplyBo2 -> {
            UmcUserTagRelApplyBo2.setApplyId(applyId);
            UmcUserTagRelApplyBo2.setUpdateOperId(reqBo.getUserIdIn());
            UmcUserTagRelApplyBo2.setUpdateOperName(reqBo.getMemName2());
            UmcUserTagRelApplyBo2.setUpdateTime(now);
        });
        List umcUserRoleRelApplyBos = JUtil.jsl((List)umcRegisterRefillUserInfoBo.getUserRoleRelBoList(), UmcUserRoleRelApplyBo.class);
        umcUserRoleRelApplyBos.forEach(UmcUserRoleRelApplyBo2 -> {
            UmcUserRoleRelApplyBo2.setApplyId(applyId);
            UmcUserRoleRelApplyBo2.setUpdateOperId(reqBo.getUserIdIn());
            UmcUserRoleRelApplyBo2.setUpdateOperName(reqBo.getMemName2());
            UmcUserRoleRelApplyBo2.setUpdateTime(now);
        });
        umcUserRegisterApplyInfoBo.setCustInfoApplyBo(applyBo);
        umcUserRegisterApplyInfoBo.setUserTagRelApplyBoList(applyBos);
        umcUserRegisterApplyInfoBo.setUserRoleRelApplyBoList(umcUserRoleRelApplyBos);
        umcUserRegisterApplyInfoBo.setApplyId(applyId);
        umcUserRegisterApplyInfoBo.setCompanyId(umcUserRegisterApplyInfoBo.getOrgId());
        umcUserRegisterApplyInfoBo.setStopStatus("01");
        umcUserRegisterApplyInfoBo.setApplyType("1");
        if (!this.register_audit_flag.booleanValue()) {
            umcUserRegisterApplyInfoBo.setApplyStatus("1");
        } else {
            umcUserRegisterApplyInfoBo.setApplyStatus(NEED_AUDIT_FLAG);
        }
        umcUserRegisterApplyInfoBo.setUpdateOperId(reqBo.getUserIdIn());
        umcUserRegisterApplyInfoBo.setUpdateOperName(reqBo.getMemName2());
        umcUserRegisterApplyInfoBo.setUpdateTime(now);
        return umcUserRegisterApplyInfoBo;
    }

    private UmcRegisterRefillUserInfoBo buildUmcUserInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, AuthEnterpriseUserRegisterRefillRspBo authEnterpriseUserRegisterRefillRspBo, String pwd, Date now) {
        UmcRegisterRefillUserInfoBo umcRegisterRefillUserInfoBo = new UmcRegisterRefillUserInfoBo();
        UmcCustInfoBo custInfoBo = new UmcCustInfoBo();
        Long userId = authEnterpriseUserRegisterRefillRspBo.getUserInfoBo().getUserId();
        umcRegisterRefillUserInfoBo.setUserId(userId);
        umcRegisterRefillUserInfoBo.setCustId(reqBo.getCustIdIn());
        umcRegisterRefillUserInfoBo.setMainCustId(reqBo.getCustIdIn());
        umcRegisterRefillUserInfoBo.setTenantId(reqBo.getTenantId());
        umcRegisterRefillUserInfoBo.setCompanyId(reqBo.getOrgIdIn());
        umcRegisterRefillUserInfoBo.setOrgId(reqBo.getOrgIdIn());
        umcRegisterRefillUserInfoBo.setIsMain("1");
        umcRegisterRefillUserInfoBo.setDelFlag(NEED_AUDIT_FLAG);
        umcRegisterRefillUserInfoBo.setUpdateOperId(userId);
        umcRegisterRefillUserInfoBo.setUpdateOperName(reqBo.getMemName2());
        umcRegisterRefillUserInfoBo.setUpdateTime(now);
        umcRegisterRefillUserInfoBo.setStopStatus("01");
        custInfoBo.setCustId(reqBo.getCustIdIn());
        custInfoBo.setStopStatus(umcRegisterRefillUserInfoBo.getStopStatus());
        custInfoBo.setCustType(umcRegisterRefillUserInfoBo.getUserType());
        custInfoBo.setRegAccount(reqBo.getRegAccount());
        custInfoBo.setRegMobile(reqBo.getRegMobile());
        custInfoBo.setRegEmail(reqBo.getRegEmail());
        custInfoBo.setCustStatus("1");
        custInfoBo.setPasswd(pwd);
        custInfoBo.setIsPasswdValid("1");
        custInfoBo.setCustName(reqBo.getMemName2());
        custInfoBo.setCertNo(reqBo.getCertNo());
        custInfoBo.setCertType(UmcCommConstant.CertType.ID_CARD);
        custInfoBo.setCompanyId(authEnterpriseUserRegisterRefillRspBo.getOrgInfoBo().getOrgId());
        custInfoBo.setUpdateOperId(userId);
        custInfoBo.setUpdateOperName(reqBo.getMemName2());
        custInfoBo.setUpdateTime(now);
        List<UmcUserTagRelBo> userTag = this.createUserTag(reqBo, userId);
        List<UmcUserRoleRelBo> umcUserRoleRelBos = this.createUserRole(reqBo, userId);
        umcRegisterRefillUserInfoBo.setCustInfoBo(custInfoBo);
        umcRegisterRefillUserInfoBo.setUserTagRelBoList(userTag);
        umcRegisterRefillUserInfoBo.setUserRoleRelBoList(umcUserRoleRelBos);
        return umcRegisterRefillUserInfoBo;
    }

    private UmcEnterpriseRegisterApplyInfoBo buildUmcOrgApplyInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, Long applyId, Date now, UmcRegisterRefillOrgInfoBo umcRegisterRefillOrgInfoBo) {
        UmcEnterpriseRegisterApplyInfoBo umcEnterpriseRegisterApplyInfoBo = (UmcEnterpriseRegisterApplyInfoBo)JUtil.js((Object)umcRegisterRefillOrgInfoBo, UmcEnterpriseRegisterApplyInfoBo.class);
        if (!this.register_audit_flag.booleanValue()) {
            umcEnterpriseRegisterApplyInfoBo.setApplyStatus("1");
        } else {
            umcEnterpriseRegisterApplyInfoBo.setApplyStatus(NEED_AUDIT_FLAG);
        }
        umcEnterpriseRegisterApplyInfoBo.setApplyId(applyId);
        umcEnterpriseRegisterApplyInfoBo.setApplyType("1");
        UmcOrgInfoApplyBo umcOrgInfoApplyBo = (UmcOrgInfoApplyBo)JUtil.js((Object)umcRegisterRefillOrgInfoBo.getOrgInfoBo(), UmcOrgInfoApplyBo.class);
        umcOrgInfoApplyBo.setOrgTagRelApplyBoList(JUtil.jsl((List)umcRegisterRefillOrgInfoBo.getOrgInfoBo().getOrgTagRelList(), UmcOrgTagRelApplyBo.class));
        umcOrgInfoApplyBo.getOrgTagRelApplyBoList().forEach(umcOrgTagRelApplyBo -> {
            umcOrgTagRelApplyBo.setApplyId(applyId);
            umcOrgTagRelApplyBo.setDelFlag(NEED_AUDIT_FLAG);
            umcOrgTagRelApplyBo.setUpdateOperId(reqBo.getUserIdIn());
            umcOrgTagRelApplyBo.setUpdateOperName(reqBo.getMemName2());
            umcOrgTagRelApplyBo.setUpdateTime(now);
        });
        umcOrgInfoApplyBo.setEffTime(new Date());
        umcOrgInfoApplyBo.setApplyId(applyId);
        umcOrgInfoApplyBo.setUpdateOperId(reqBo.getUserIdIn());
        umcOrgInfoApplyBo.setUpdateOperName(reqBo.getMemName2());
        umcOrgInfoApplyBo.setUpdateTime(now);
        umcEnterpriseRegisterApplyInfoBo.setOrgInfoApplyBo(umcOrgInfoApplyBo);
        List umcEnterpriseContactApplyBos = JUtil.jsl((List)umcRegisterRefillOrgInfoBo.getEnterpriseContactBoList(), UmcEnterpriseContactApplyBo.class);
        umcEnterpriseContactApplyBos.forEach(umcEnterpriseContactApplyBo -> {
            umcEnterpriseContactApplyBo.setApplyId(applyId);
            umcEnterpriseContactApplyBo.setDelFlag(NEED_AUDIT_FLAG);
            umcEnterpriseContactApplyBo.setUpdateOperId(reqBo.getUserIdIn());
            umcEnterpriseContactApplyBo.setUpdateOperName(reqBo.getMemName2());
            umcEnterpriseContactApplyBo.setUpdateTime(now);
        });
        umcEnterpriseRegisterApplyInfoBo.setEnterpriseContactApplyBoList(umcEnterpriseContactApplyBos);
        umcEnterpriseRegisterApplyInfoBo.setUpdateOperId(reqBo.getUserIdIn());
        umcEnterpriseRegisterApplyInfoBo.setUpdateOperName(reqBo.getMemName2());
        umcEnterpriseRegisterApplyInfoBo.setUpdateTime(now);
        return umcEnterpriseRegisterApplyInfoBo;
    }

    private UmcRegisterRefillOrgInfoBo buildUmcOrgInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, Long orgId, AuthUserInfoBo userInfoBo, Date now) {
        UmcRegisterRefillOrgInfoBo umcRegisterRefillOrgInfoBo = new UmcRegisterRefillOrgInfoBo();
        UmcOrgInfoBo umcOrgInfoBo = new UmcOrgInfoBo();
        umcOrgInfoBo.setOrgId(orgId);
        umcOrgInfoBo.setTenantId(reqBo.getTenantId());
        umcOrgInfoBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        umcOrgInfoBo.setCompanyId(orgId);
        umcOrgInfoBo.setOrgCode(reqBo.getOrgCodeWeb());
        umcOrgInfoBo.setDeep(ORG_DEEP);
        umcOrgInfoBo.setOrgName(reqBo.getOrgNameWeb());
        umcOrgInfoBo.setOrgAlias(reqBo.getAliasWeb());
        umcOrgInfoBo.setIsVirtual("1");
        umcOrgInfoBo.setOrgStatus("1");
        umcOrgInfoBo.setUpdateOperId(userInfoBo.getUserId());
        umcOrgInfoBo.setUpdateOperName(reqBo.getMemName2());
        umcOrgInfoBo.setUpdateTime(now);
        ArrayList<UmcOrgTagRelBo> orgTagRelList = new ArrayList<UmcOrgTagRelBo>();
        for (String tag : reqBo.getTradeCapacity().split(",")) {
            UmcOrgTagRelBo umcOrgTagRelBo = new UmcOrgTagRelBo();
            umcOrgTagRelBo.setTagStatus("1");
            umcOrgTagRelBo.setOrgId(orgId);
            umcOrgTagRelBo.setTenantId(reqBo.getTenantId());
            umcOrgTagRelBo.setTagId(tag);
            umcOrgTagRelBo.setUpdateOperId(userInfoBo.getUserId());
            umcOrgTagRelBo.setUpdateOperName(reqBo.getMemName2());
            umcOrgTagRelBo.setUpdateTime(now);
            umcOrgTagRelBo.setEffTime(now);
            orgTagRelList.add(umcOrgTagRelBo);
        }
        umcOrgInfoBo.setOrgTagRelList(orgTagRelList);
        umcRegisterRefillOrgInfoBo.setOrgId(orgId);
        umcRegisterRefillOrgInfoBo.setTenantId(reqBo.getTenantId());
        umcRegisterRefillOrgInfoBo.setOrgShortName(reqBo.getAliasWeb());
        umcRegisterRefillOrgInfoBo.setIsAbroad(NEED_AUDIT_FLAG);
        umcRegisterRefillOrgInfoBo.setIsMerchant(NEED_AUDIT_FLAG);
        umcRegisterRefillOrgInfoBo.setIndustry(reqBo.getTradeType());
        umcRegisterRefillOrgInfoBo.setTelephone(reqBo.getRegMobile());
        umcRegisterRefillOrgInfoBo.setMailBox(reqBo.getRegEmail());
        umcRegisterRefillOrgInfoBo.setLegalPerson(reqBo.getMemName2());
        umcRegisterRefillOrgInfoBo.setOrgCertificateCode(reqBo.getOrgCertificateCode());
        umcRegisterRefillOrgInfoBo.setCreditNo(reqBo.getOrgCertificateCode());
        if (!CollectionUtils.isEmpty(reqBo.getBusinessLicense())) {
            umcRegisterRefillOrgInfoBo.setBusinessLicense(JSON.toJSONString(reqBo.getBusinessLicense()));
        }
        umcRegisterRefillOrgInfoBo.setOrgInfoBo(umcOrgInfoBo);
        umcRegisterRefillOrgInfoBo.setUpdateOperId(userInfoBo.getUserId());
        umcRegisterRefillOrgInfoBo.setUpdateOperName(reqBo.getMemName2());
        ArrayList<UmcEnterpriseContactBo> umcEnterpriseContactBos = new ArrayList<UmcEnterpriseContactBo>();
        UmcEnterpriseContactBo umcEnterpriseContactBo = new UmcEnterpriseContactBo();
        umcEnterpriseContactBo.setContactId(reqBo.getEnterpriseContactId());
        umcEnterpriseContactBo.setOrgId(reqBo.getOrgIdIn());
        umcEnterpriseContactBo.setUpdateOperId(reqBo.getUserIdIn());
        umcEnterpriseContactBo.setUpdateOperName(reqBo.getMemName2());
        umcEnterpriseContactBo.setContactName(reqBo.getMemName2());
        umcEnterpriseContactBo.setCardNum(reqBo.getCertNo());
        umcEnterpriseContactBo.setEmail(reqBo.getRegEmail());
        umcEnterpriseContactBo.setPhoneNumber(reqBo.getRegMobile());
        umcEnterpriseContactBo.setCustId(reqBo.getCustIdIn());
        umcEnterpriseContactBo.setTenantId(reqBo.getTenantId());
        umcEnterpriseContactBo.setDelFlag(NEED_AUDIT_FLAG);
        umcEnterpriseContactBo.setExtField1("1");
        umcEnterpriseContactBos.add(umcEnterpriseContactBo);
        umcRegisterRefillOrgInfoBo.setEnterpriseContactBoList(umcEnterpriseContactBos);
        return umcRegisterRefillOrgInfoBo;
    }

    public AuthEnterpriseUserRegisterRefillRspBo updateOrgUserAuth(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, String pwd, String salt) {
        Date now = new Date();
        AuthRegisterRefillOrgInfoBo authRegisterRefillOrgInfoBo = this.buildAuthOrgInfo(reqBo, now);
        AuthRegisterRefillUserInfoBo authRegisterRefillUserInfoBo = this.buildAuthUserInfo(reqBo, pwd, salt, now, authRegisterRefillOrgInfoBo);
        AuthRegisterRefillUserRoleInfoBo authRegisterRefillUserRoleInfoBo = this.buildAuthUserRoleInfo(reqBo);
        AuthEnterpriseUserRegisterRefillReqBo authEnterpriseUserRegisterRefillReqBo = new AuthEnterpriseUserRegisterRefillReqBo();
        authEnterpriseUserRegisterRefillReqBo.setAuthRegisterRefillOrgInfoBo(authRegisterRefillOrgInfoBo);
        authEnterpriseUserRegisterRefillReqBo.setAuthRegisterRefillUserInfoBo(authRegisterRefillUserInfoBo);
        authEnterpriseUserRegisterRefillReqBo.setAuthRegisterRefillUserRoleInfoBo(authRegisterRefillUserRoleInfoBo);
        AuthEnterpriseUserRegisterRefillRspBo authEnterpriseUserRegisterRefillRspBo = this.authEnterpriseUserRegisterRefillService.dealEnterpriseUserRegisterRefill(authEnterpriseUserRegisterRefillReqBo);
        if (!"0000".equals(authEnterpriseUserRegisterRefillRspBo.getRespCode())) {
            throw new ZTBusinessException("\u4fee\u6539\u6743\u9650\u673a\u6784\u3001\u7528\u6237\u5931\u8d25");
        }
        return authEnterpriseUserRegisterRefillRspBo;
    }

    private AuthRegisterRefillUserRoleInfoBo buildAuthUserRoleInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo) {
        AuthRegisterRefillUserRoleInfoBo authRegisterRefillUserRoleInfoBo = new AuthRegisterRefillUserRoleInfoBo();
        authRegisterRefillUserRoleInfoBo.setUserId(reqBo.getUserIdIn());
        List authDistributeBos = JUtil.jsl(this.createUserRole(reqBo, reqBo.getUserIdIn()), AuthDistributeBo.class);
        authDistributeBos.forEach(AuthDistributeBo2 -> AuthDistributeBo2.setDisFlag(AuthConstant.ROLE_DIS_FLAG.USER));
        authRegisterRefillUserRoleInfoBo.setAuthDistributeList(authDistributeBos);
        return authRegisterRefillUserRoleInfoBo;
    }

    private AuthRegisterRefillUserInfoBo buildAuthUserInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, String pwd, String salt, Date now, AuthRegisterRefillOrgInfoBo authRegisterRefillOrgInfoBo) {
        AuthRegisterRefillUserInfoBo authRegisterRefillUserInfoBo = new AuthRegisterRefillUserInfoBo();
        authRegisterRefillUserInfoBo.setTenantId(reqBo.getTenantId());
        authRegisterRefillUserInfoBo.setUserId(reqBo.getUserIdIn());
        authRegisterRefillUserInfoBo.setOrgId(authRegisterRefillOrgInfoBo.getOrgId());
        authRegisterRefillUserInfoBo.setCustId(reqBo.getCustIdIn());
        authRegisterRefillUserInfoBo.setOrgTreePath(authRegisterRefillOrgInfoBo.getOrgTreePath());
        authRegisterRefillUserInfoBo.setAuthorityType("auth:default:manage");
        authRegisterRefillUserInfoBo.setIsMain("1");
        AuthCustInfoBo authCustInfoBo = new AuthCustInfoBo();
        authCustInfoBo.setLoginName(reqBo.getRegAccount());
        authCustInfoBo.setCustId(reqBo.getCustIdIn());
        authCustInfoBo.setTenantId(reqBo.getTenantId());
        authCustInfoBo.setCustPassword(pwd);
        authCustInfoBo.setPasswordSalt(salt);
        authCustInfoBo.setPasswordEffDate(now);
        authCustInfoBo.setPasswordEffDateStart(DateUtils.addDays((Date)now, (int)this.password_eff));
        authCustInfoBo.setCustName(reqBo.getMemName2());
        authCustInfoBo.setCellPhone(reqBo.getRegMobile());
        authCustInfoBo.setCustEmail(reqBo.getRegEmail());
        authCustInfoBo.setCustStatus("1");
        authCustInfoBo.setCustSource("1");
        authCustInfoBo.setUpdateOperId(reqBo.getUserIdIn());
        authCustInfoBo.setUpdateOperName(reqBo.getMemName2());
        authCustInfoBo.setUpdateTime(now);
        authRegisterRefillUserInfoBo.setCustInfo(authCustInfoBo);
        ArrayList<AuthUserTagRelBo> userTagRelList = new ArrayList<AuthUserTagRelBo>();
        for (String s : reqBo.getTradeCapacity().split(",")) {
            AuthUserTagRelBo umcUserTagRelBo = new AuthUserTagRelBo();
            umcUserTagRelBo.setIsDefalt(NEED_AUDIT_FLAG);
            umcUserTagRelBo.setUserId(reqBo.getUserIdIn());
            umcUserTagRelBo.setTagId(Convert.toLong((Object)s));
            umcUserTagRelBo.setUpdateOperId(reqBo.getUserIdIn());
            umcUserTagRelBo.setUpdateTime(now);
            umcUserTagRelBo.setUpdateOperName(reqBo.getMemName2());
            userTagRelList.add(umcUserTagRelBo);
        }
        if (!CollectionUtils.isEmpty(userTagRelList)) {
            ((AuthUserTagRelBo)userTagRelList.get(0)).setIsDefalt("1");
        }
        authRegisterRefillUserInfoBo.setUserTagRelList(userTagRelList);
        return authRegisterRefillUserInfoBo;
    }

    private AuthRegisterRefillOrgInfoBo buildAuthOrgInfo(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, Date now) {
        AuthRegisterRefillOrgInfoBo authRegisterRefillOrgInfoBo = new AuthRegisterRefillOrgInfoBo();
        authRegisterRefillOrgInfoBo.setTenantId(reqBo.getTenantId());
        authRegisterRefillOrgInfoBo.setOrgId(reqBo.getOrgIdIn());
        authRegisterRefillOrgInfoBo.setOrgCode(reqBo.getOrgCodeWeb());
        authRegisterRefillOrgInfoBo.setOrgName(reqBo.getOrgNameWeb());
        authRegisterRefillOrgInfoBo.setOrgAlias(reqBo.getAliasWeb());
        authRegisterRefillOrgInfoBo.setOrgType(UmcCommConstant.EnterpriseOrgType.TYPE_COMPANY);
        authRegisterRefillOrgInfoBo.setIsVirtual("1");
        authRegisterRefillOrgInfoBo.setOrgStatus("1");
        authRegisterRefillOrgInfoBo.setUpdateTime(now);
        authRegisterRefillOrgInfoBo.setUpdateOperId(reqBo.getUserIdIn());
        authRegisterRefillOrgInfoBo.setUpdateOperName(reqBo.getMemName2());
        ArrayList<AuthOrgTagRelBo> orgTagRelList = new ArrayList<AuthOrgTagRelBo>();
        for (String tag : reqBo.getTradeCapacity().split(",")) {
            AuthOrgTagRelBo authOrgTagRelBo = new AuthOrgTagRelBo();
            authOrgTagRelBo.setTagStatus("1");
            authOrgTagRelBo.setTagId(Convert.toLong((Object)tag));
            authOrgTagRelBo.setOrgId(reqBo.getOrgIdIn());
            authOrgTagRelBo.setUpdateOperId(reqBo.getUserIdIn());
            authOrgTagRelBo.setUpdateOperName(reqBo.getMemName2());
            orgTagRelList.add(authOrgTagRelBo);
        }
        authRegisterRefillOrgInfoBo.setOrgTagList(orgTagRelList);
        return authRegisterRefillOrgInfoBo;
    }

    public List<UmcUserTagRelBo> createUserTag(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, Long userId) {
        ArrayList<UmcUserTagRelBo> userTagRelList = new ArrayList<UmcUserTagRelBo>();
        boolean flag = true;
        int orderBy = 0;
        for (String s : reqBo.getTradeCapacity().split(",")) {
            UmcUserTagRelBo umcUserTagRelBo = new UmcUserTagRelBo();
            umcUserTagRelBo.setUserId(userId);
            umcUserTagRelBo.setTenantId(reqBo.getTenantId());
            if (flag) {
                umcUserTagRelBo.setIsDefalt("1");
                flag = false;
            } else {
                umcUserTagRelBo.setIsDefalt(NEED_AUDIT_FLAG);
            }
            umcUserTagRelBo.setTagId(s);
            umcUserTagRelBo.setCreateOperId(userId);
            umcUserTagRelBo.setCreateOperName(reqBo.getMemName2());
            umcUserTagRelBo.setOrderBy(Integer.toString(orderBy));
            ++orderBy;
            userTagRelList.add(umcUserTagRelBo);
        }
        return userTagRelList;
    }

    public List<UmcUserRoleRelBo> createUserRole(DycUmcUserOrEnterpriseRegistReFillReqBo reqBo, Long createId) {
        String role;
        Date now = new Date();
        ArrayList<UmcUserRoleRelBo> userRoleRelList = new ArrayList<UmcUserRoleRelBo>();
        if ("1".equals(reqBo.getRegisterType())) {
            role = this.registerDefaultPersonalRole;
        } else if (org.equals(reqBo.getRegisterType())) {
            role = this.registerDefaultEnterpriseRole;
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u6ce8\u518c\u7c7b\u578b");
        }
        String[] personRole = role.split(",");
        if (personRole.length > 0) {
            for (String value : personRole) {
                UmcUserRoleRelBo umcUserRoleRelBo = new UmcUserRoleRelBo();
                umcUserRoleRelBo.setTenantId(reqBo.getTenantId());
                umcUserRoleRelBo.setRoleId(Long.valueOf(Long.parseLong(value)));
                umcUserRoleRelBo.setTagId("9");
                umcUserRoleRelBo.setCreateOperId(createId);
                umcUserRoleRelBo.setCreateTime(now);
                umcUserRoleRelBo.setCreateOperName(reqBo.getMemName2());
                userRoleRelList.add(umcUserRoleRelBo);
            }
        }
        UmcUserRoleRelBo umcUserRoleRelBo = new UmcUserRoleRelBo();
        umcUserRoleRelBo.setTenantId(reqBo.getTenantId());
        umcUserRoleRelBo.setRoleId(DEFAULT_ROLE_ID);
        umcUserRoleRelBo.setTagId("9");
        umcUserRoleRelBo.setCreateOperId(createId);
        umcUserRoleRelBo.setCreateTime(now);
        umcUserRoleRelBo.setCreateOperName(reqBo.getMemName2());
        userRoleRelList.add(umcUserRoleRelBo);
        return userRoleRelList.stream().distinct().collect(Collectors.toList());
    }

    private UmcRegistDetailBo getApplyInfo(Long orgId) {
        UmcRegistDetailQryReqBo umcRegistDetailQryReqBo = new UmcRegistDetailQryReqBo();
        umcRegistDetailQryReqBo.setOrgIdWeb(orgId);
        UmcRegistDetailQryRspBo umcRegistDetailQryRspBo = this.umcRegistDetailQryService.qryRegistDetail(umcRegistDetailQryReqBo);
        if (!"0000".equals(umcRegistDetailQryRspBo.getRespCode()) || null == umcRegistDetailQryRspBo.getUmcEnterpriseOrgAudit()) {
            throw new ZTBusinessException("\u67e5\u8be2\u6ce8\u518c\u4fe1\u606f\u5931\u8d25");
        }
        return umcRegistDetailQryRspBo.getUmcEnterpriseOrgAudit();
    }
}

