/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.glutton.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.utils.ComHttpUtil;
import com.tydic.dyc.common.member.glutton.api.DycGluttonTaskService;
import com.tydic.dyc.common.member.glutton.bo.DycGluttonTaskReqBO;
import com.tydic.dyc.common.member.glutton.bo.DycGluttonTaskRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.glutton.api.DycGluttonTaskService"})
public class DycGluttonTaskServiceImpl
implements DycGluttonTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycGluttonTaskServiceImpl.class);
    @Value(value="${glutton.host:http://127.0.0.1:10340}")
    private String gluttonHost;
    @Value(value="${glutton.task.trigger.url:/glutton/task/api/trigger}")
    private String gluttonTaskTriggerUrl;
    @Value(value="${glutton.task.interrupt.url:/glutton/task/interrupt}")
    private String gluttonTaskInterruptUrl;
    @Value(value="${glutton.task.retrigger.url:/glutton/task/api/reTrigger}")
    private String gluttonTaskReTriggerUrl;

    @Override
    @PostMapping(value={"trigger"})
    public DycGluttonTaskRspBO trigger(@RequestBody DycGluttonTaskReqBO reqBO) {
        String result;
        JSONObject gluttonReqJson = this.getGluttonReqJson(reqBO);
        String url = this.gluttonHost + this.gluttonTaskTriggerUrl;
        try {
            log.info("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u5730\u5740\uff1a{}\uff0c\u94fe\u63a5\u5165\u53c2\uff1a{}", (Object)url, (Object)gluttonReqJson);
            result = ComHttpUtil.sendPost((String)url, (String)gluttonReqJson.toJSONString());
            log.info("\u5bfc\u5165\u4e2d\u5fc3\u8fd4\u56de\uff1a" + result);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u5bfc\u5165\u5f02\u5e38" + e);
        }
        if (StringUtils.isEmpty((Object)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return this.getGluttonRsp(result);
    }

    @Override
    @PostMapping(value={"interrupt"})
    public DycGluttonTaskRspBO interrupt(@RequestBody DycGluttonTaskReqBO reqBO) {
        String result;
        JSONObject gluttonReqJson = this.getGluttonReqJson(reqBO);
        String url = this.gluttonHost + this.gluttonTaskInterruptUrl;
        try {
            log.info("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u5730\u5740\uff1a{}\uff0c\u94fe\u63a5\u5165\u53c2\uff1a{}", (Object)url, (Object)gluttonReqJson);
            result = ComHttpUtil.sendPost((String)url, (String)gluttonReqJson.toJSONString());
            log.info("\u5bfc\u5165\u4e2d\u5fc3\u8fd4\u56de\uff1a" + result);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u53d6\u6d88\u5bfc\u5165\u5f02\u5e38" + e);
        }
        if (StringUtils.isEmpty((Object)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return this.getGluttonRsp(result);
    }

    @Override
    @PostMapping(value={"reTrigger"})
    public DycGluttonTaskRspBO reTrigger(@RequestBody DycGluttonTaskReqBO reqBO) {
        String result;
        JSONObject gluttonReqJson = this.getGluttonReqJson(reqBO);
        String url = this.gluttonHost + this.gluttonTaskReTriggerUrl;
        try {
            log.info("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u5730\u5740\uff1a{}\uff0c\u94fe\u63a5\u5165\u53c2\uff1a{}", (Object)url, (Object)gluttonReqJson);
            result = ComHttpUtil.sendPost((String)url, (String)gluttonReqJson.toJSONString());
            log.info("\u5bfc\u5165\u4e2d\u5fc3\u8fd4\u56de\uff1a" + result);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u91cd\u65b0\u5bfc\u5165\u5f02\u5e38" + e);
        }
        if (StringUtils.isEmpty((Object)result)) {
            throw new ZTBusinessException("\u8c03\u7528\u5bfc\u5165\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return this.getGluttonRsp(result);
    }

    private JSONObject getGluttonReqJson(DycGluttonTaskReqBO reqBO) {
        JSONObject gluttonReqJson = new JSONObject();
        gluttonReqJson.put("userId", (Object)reqBO.getUserId());
        gluttonReqJson.put("userName", (Object)reqBO.getUsername());
        gluttonReqJson.put("functionCode", (Object)reqBO.getFunctionCode());
        gluttonReqJson.put("requestParam", (Object)reqBO.getRequestParam());
        gluttonReqJson.put("attachmentName", (Object)reqBO.getAttachmentName());
        gluttonReqJson.put("fileUrl", (Object)reqBO.getFileUrl());
        gluttonReqJson.put("fileName", (Object)reqBO.getFileName());
        gluttonReqJson.put("taskId", (Object)reqBO.getTaskId());
        gluttonReqJson.put("sign", (Object)reqBO.getSign());
        gluttonReqJson.put("executionWay", (Object)reqBO.getExecutionWay());
        return gluttonReqJson;
    }

    public DycGluttonTaskRspBO getGluttonRsp(String result) {
        DycGluttonTaskRspBO rspBO = new DycGluttonTaskRspBO();
        JSONObject resultJson = JSON.parseObject((String)result);
        JSONObject dataJson = resultJson.getJSONObject("data");
        rspBO.setCode(dataJson.getString("respCode"));
        rspBO.setMessage(dataJson.getString("respDesc"));
        if (!"0000".equals(rspBO.getCode())) {
            throw new ZTBusinessException(rspBO.getMessage());
        }
        rspBO = (DycGluttonTaskRspBO)((Object)JSON.parseObject((String)dataJson.toJSONString(), DycGluttonTaskRspBO.class));
        return rspBO;
    }
}

