/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.invoice.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.common.member.invoice.api.DycUmcExternalJdAddQualificationService;
import com.tydic.dyc.common.member.invoice.api.DycUmcInvoiceInfoAddService;
import com.tydic.dyc.common.member.invoice.bo.DycBizQualifications;
import com.tydic.dyc.common.member.invoice.bo.DycUmcExternalJdAddQualificationReqBO;
import com.tydic.dyc.common.member.invoice.bo.DycUmcExternalJdQualificationRspBO;
import com.tydic.dyc.common.member.invoice.bo.DycUmcInvoiceInfoAddReqBo;
import com.tydic.dyc.common.member.invoice.bo.DycUmcInvoiceInfoAddRspBo;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.service.enterprise.UmcOrgInfoCheckService;
import com.tydic.dyc.umc.service.enterprise.UmcQryEnterpriseInfoDetailService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoCheckReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcOrgInfoCheckRspBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryEnterpriseInfoDetailRspBo;
import com.tydic.dyc.umc.service.enterpriseaccount.UmcGetEnterpriseAccountDetailsService;
import com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoAddService;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoAddReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoAddRspBo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.invoice.api.DycUmcInvoiceInfoAddService"})
public class DycUmcInvoiceInfoAddServiceImpl
implements DycUmcInvoiceInfoAddService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcInvoiceInfoAddServiceImpl.class);
    @Autowired
    private UmcInvoiceInfoAddService umcInvoiceInfoAddService;
    @Autowired
    private UmcGetEnterpriseAccountDetailsService umcGetEnterpriseAccountDetailsService;
    @Autowired
    private UmcQryEnterpriseInfoDetailService umcQryEnterpriseInfoDetailService;
    @Autowired
    private UmcOrgInfoCheckService umcOrgInfoCheckService;
    @Autowired
    private DycUmcExternalJdAddQualificationService dycUmcExternalJdAddQualificationService;
    @Value(value="${CHECK_JD_INVOICE:false}")
    private boolean CHECK_JD_INVOICE;

    @Override
    @PostMapping(value={"createInvoiceInfo"})
    public DycUmcInvoiceInfoAddRspBo createInvoiceInfo(@RequestBody DycUmcInvoiceInfoAddReqBo reqBo) {
        UmcInvoiceInfoAddRspBo invoiceInfo;
        DycUmcInvoiceInfoAddRspBo rspBO = new DycUmcInvoiceInfoAddRspBo();
        if ("COMPANY".equals(reqBo.getAccountOwner())) {
            this.validationConpanyParams(reqBo);
        } else if ("PERSON".equals(reqBo.getInvoiceType())) {
            this.validationPersonParams(reqBo);
        }
        UmcOrgInfoCheckReqBo checkReqBo = new UmcOrgInfoCheckReqBo();
        checkReqBo.setOrgId(reqBo.getOrgIdWeb());
        UmcOrgInfoCheckRspBo umcOrgInfoCheckRspBo = this.umcOrgInfoCheckService.checkOrgInfo(checkReqBo);
        if (umcOrgInfoCheckRspBo == null || umcOrgInfoCheckRspBo.getResult() == null || umcOrgInfoCheckRspBo.getResult() <= 0) {
            rspBO.setRespCode("163027");
            rspBO.setRespDesc("\u8d26\u5957\u53d1\u7968\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBo.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
            return rspBO;
        }
        UmcInvoiceInfoAddReqBo invoiceInfoAddReqBo = new UmcInvoiceInfoAddReqBo();
        BeanUtils.copyProperties((Object)((Object)reqBo), (Object)invoiceInfoAddReqBo);
        invoiceInfoAddReqBo.setOrgIdWeb(reqBo.getOrgIdWeb());
        invoiceInfoAddReqBo.setTenantId(reqBo.getTenantIdIn());
        invoiceInfoAddReqBo.setCreateOperId(reqBo.getUserIdIn());
        invoiceInfoAddReqBo.setCreateOperName(reqBo.getCustNameIn());
        if (this.CHECK_JD_INVOICE && StringUtils.isBlank((CharSequence)reqBo.getTitleType())) {
            UmcQryEnterpriseInfoDetailReqBo busiReqBO = new UmcQryEnterpriseInfoDetailReqBo();
            busiReqBO.setOrgId(reqBo.getOrgIdWeb());
            UmcQryEnterpriseInfoDetailRspBo orgDetailBusiRspBO = this.umcQryEnterpriseInfoDetailService.qryEnterpriseInfoDetail(busiReqBO);
            if (!orgDetailBusiRspBO.getRespCode().equals("0000")) {
                throw new ZTBusinessException(orgDetailBusiRspBO.getRespDesc());
            }
            if (reqBo.getInvoiceType().equals("00") && !orgDetailBusiRspBO.getOrgInfoBo().getOrgType().equals(Convert.toLong((Object)"03"))) {
                DycUmcExternalJdAddQualificationReqBO umcExternalJdAddQualificationReqBO = this.initalAddQualificationReqBO(reqBo, orgDetailBusiRspBO);
                DycUmcExternalJdQualificationRspBO jdQualificationRspBO = this.dycUmcExternalJdAddQualificationService.jdAccountInvoiceAddQualification(umcExternalJdAddQualificationReqBO);
                if (jdQualificationRspBO.getResultCode().equals("0000")) {
                    DycBizQualifications bizQualifications = (DycBizQualifications)JSON.parseObject((String)jdQualificationRspBO.getResult(), DycBizQualifications.class);
                    invoiceInfoAddReqBo.setExtinvoiceSource("00");
                    invoiceInfoAddReqBo.setExtinvoiceStatusStr("01");
                    invoiceInfoAddReqBo.setExtinvoiceStatus(bizQualifications.getApproveStatus().toString());
                    invoiceInfoAddReqBo.setExtinvoiceQuaId(bizQualifications.getVatId().toString());
                    invoiceInfoAddReqBo.setDelStatus("01");
                } else {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc(jdQualificationRspBO.getRespDesc());
                    return rspBO;
                }
            }
        }
        if (!"0000".equals((invoiceInfo = this.umcInvoiceInfoAddService.createInvoiceInfo(invoiceInfoAddReqBo)).getRespCode())) {
            throw new ZTBusinessException(invoiceInfo.getRespDesc());
        }
        rspBO.setInvoiceId(invoiceInfo.getInvoiceId());
        rspBO.setRespCode(invoiceInfo.getRespCode());
        rspBO.setRespDesc(invoiceInfo.getRespDesc());
        return rspBO;
    }

    private void validationConpanyParams(DycUmcInvoiceInfoAddReqBo reqBo) {
        if (null == reqBo.getAccountId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u5957ID[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerIdConfim())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerIdConfim]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getTaxpayerId().equals(reqBo.getTaxpayerIdConfim())) {
            throw new BaseBusinessException("201001", "\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u4e00\u81f4");
        }
        if ("00".equals(reqBo.getInvoiceType())) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getAccount())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u6237[account]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getBank())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u5f00\u6237\u884c[bank]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getPhone())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7535\u8bdd[phone]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getAddress())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u5730\u5740[address]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private void validationPersonParams(DycUmcInvoiceInfoAddReqBo reqBo) {
        if (null == reqBo.getAccountId()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u8d26\u5957ID[accountId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceType())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u578b[invoiceType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceTitle())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u62ac\u5934[invoiceTitle]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getInvoiceClass())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u53d1\u7968\u7c7b\u522b[invoiceClass]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.EntInvMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.EntInvMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("201001", "\u53d1\u7968\u4fee\u6539\u670d\u52a1\u5165\u53c2\u662f\u5426\u9ed8\u8ba4\u53d1\u7968[mainFlag]\u53c2\u6570\u503c\u53ea\u80fd\u4e3a0\u62161");
        }
        if ("COMPANY".equals(reqBo.getTitleType())) {
            if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerId())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBo.getTaxpayerIdConfim())) {
                throw new BaseBusinessException("201001", "\u53d1\u7968\u65b0\u589e\u670d\u52a1\u5165\u53c2\u786e\u8ba4\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7[taxpayerIdConfim]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }

    private DycUmcExternalJdAddQualificationReqBO initalAddQualificationReqBO(DycUmcInvoiceInfoAddReqBo reqBO, UmcQryEnterpriseInfoDetailRspBo busiRspBO) {
        DycUmcExternalJdAddQualificationReqBO umcExternalJdAddQualificationReqBO = new DycUmcExternalJdAddQualificationReqBO();
        umcExternalJdAddQualificationReqBO.setRegPhone(reqBO.getPhone());
        umcExternalJdAddQualificationReqBO.setTaxpayerId(reqBO.getTaxpayerId());
        umcExternalJdAddQualificationReqBO.setDepositBank(reqBO.getBank());
        umcExternalJdAddQualificationReqBO.setBankAccout(reqBO.getAccount());
        umcExternalJdAddQualificationReqBO.setRegAddr(reqBO.getAddress());
        umcExternalJdAddQualificationReqBO.setOrgId(reqBO.getOrgIdWeb().toString());
        umcExternalJdAddQualificationReqBO.setUnitName(busiRspBO.getOrgInfoBo().getOrgName());
        if (StringUtils.isBlank((CharSequence)busiRspBO.getBusinessLicense())) {
            throw new ZTBusinessException("\u8be5\u673a\u6784\u4e0d\u5b58\u5728\u6709\u6548\u7684\u8425\u4e1a\u6267\u7167!");
        }
        umcExternalJdAddQualificationReqBO.setBusinessChangeFile(busiRspBO.getBusinessLicense());
        return umcExternalJdAddQualificationReqBO;
    }
}

