/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.menu.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.authority.service.menu.AuthGetMenuListService;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListReqBo;
import com.tydic.dyc.authority.service.menu.bo.AuthGetMenuListRspBo;
import com.tydic.dyc.authority.service.menu.bo.AuthMenuInfoBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.member.menu.api.DycAuthGetMenuListService;
import com.tydic.dyc.common.member.menu.bo.DycAuthGetMenuListReqBo;
import com.tydic.dyc.common.member.menu.bo.DycAuthGetMenuListRspBo;
import com.tydic.dyc.common.member.menu.bo.DycAuthMenuInfoBo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.menu.api.DycAuthGetMenuListService"})
public class DycAuthGetMenuListServiceImpl
implements DycAuthGetMenuListService {
    @Autowired
    private AuthGetMenuListService authGetMenuListService;

    @Override
    @PostMapping(value={"getMenuList"})
    public DycAuthGetMenuListRspBo getMenuList(@RequestBody DycAuthGetMenuListReqBo reqBo) {
        this.validateArg(reqBo);
        AuthGetMenuListReqBo authReqBo = (AuthGetMenuListReqBo)JUtil.js((Object)((Object)reqBo), AuthGetMenuListReqBo.class);
        AuthGetMenuListRspBo authRspBo = this.authGetMenuListService.getMenuList(authReqBo);
        if (!"0000".equals(authRspBo.getRespCode())) {
            throw new ZTBusinessException("\u83dc\u5355\u5217\u8868\u5931\u8d25\uff1a" + authRspBo.getRespDesc());
        }
        List menuInfos = JUtil.jsl((List)authRspBo.getMenuInfoBoList(), AuthMenuInfoBo.class);
        DycAuthGetMenuListRspBo rspBo = new DycAuthGetMenuListRspBo();
        if (menuInfos.size() > 0) {
            List<AuthMenuInfoBo> buildByRecursive = this.buildByRecursive(menuInfos);
            rspBo.setMenuInfoBoList(JUtil.jsl(buildByRecursive, DycAuthMenuInfoBo.class));
        }
        rspBo.setCode("0");
        rspBo.setMessage("\u6210\u529f");
        return rspBo;
    }

    private void validateArg(DycAuthGetMenuListReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[DycAuthGetMenuListReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getApplicationCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[ApplicationCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<AuthMenuInfoBo> buildByRecursive(List<AuthMenuInfoBo> treeNodes) {
        Collections.sort(treeNodes);
        ArrayList<AuthMenuInfoBo> trees = new ArrayList<AuthMenuInfoBo>();
        for (AuthMenuInfoBo treeNode : treeNodes) {
            if (treeNode.getParentId() != null) continue;
            trees.add(this.findChildren(treeNode, treeNodes));
        }
        Collections.sort(trees);
        return trees;
    }

    private AuthMenuInfoBo findChildren(AuthMenuInfoBo root, List<AuthMenuInfoBo> allMenus) {
        for (AuthMenuInfoBo it : allMenus) {
            if (!root.getMenuId().equals(it.getParentId())) continue;
            if (root.getChildren() == null) {
                root.setChildren(new ArrayList());
            }
            root.getChildren().add(this.findChildren(it, allMenus));
        }
        return root;
    }
}

