/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.role.impl;

import com.tydic.dyc.authority.service.role.AuthDealRolePowerService;
import com.tydic.dyc.authority.service.role.bo.AuthDealRolePowerReqBo;
import com.tydic.dyc.authority.service.role.bo.AuthDealRolePowerRspBo;
import com.tydic.dyc.authority.service.role.bo.AuthRolePowerBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.common.member.role.api.DycAuthDealRolePowerService;
import com.tydic.dyc.common.member.role.bo.DycAuthDealRolePowerReqBo;
import com.tydic.dyc.common.member.role.bo.DycAuthDealRolePowerRspBo;
import com.tydic.dyc.common.member.role.bo.DycAuthRolePowerBo;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.role.api.DycAuthDealRolePowerService"})
public class DycAuthDealRolePowerServiceImpl
implements DycAuthDealRolePowerService {
    @Autowired
    private AuthDealRolePowerService authDealRolePowerService;

    @Override
    @PostMapping(value={"dealRolePower"})
    public DycAuthDealRolePowerRspBo dealRolePower(@RequestBody DycAuthDealRolePowerReqBo reqBo) {
        this.validateArg(reqBo);
        AuthDealRolePowerReqBo authReqBo = (AuthDealRolePowerReqBo)JUtil.js((Object)((Object)reqBo), AuthDealRolePowerReqBo.class);
        authReqBo.setCreateOperId(reqBo.getUserIdIn());
        authReqBo.setCreateOperName(reqBo.getCustNameIn());
        Date now = new Date();
        authReqBo.setCreateTime(now);
        authReqBo.setUpdateOperId(reqBo.getUserIdIn());
        authReqBo.setUpdateOperName(reqBo.getCustNameIn());
        authReqBo.setUpdateTime(now);
        if (!CollectionUtils.isEmpty((Collection)authReqBo.getRolePowerList())) {
            for (AuthRolePowerBo listBo : authReqBo.getRolePowerList()) {
                listBo.setCreateOperId(authReqBo.getCreateOperId());
                listBo.setCreateOperName(authReqBo.getCreateOperName());
                listBo.setCreateTime(now);
                listBo.setUpdateOperId(authReqBo.getUpdateOperId());
                listBo.setUpdateOperName(authReqBo.getUpdateOperName());
                listBo.setUpdateTime(now);
            }
        }
        AuthDealRolePowerRspBo authRspBo = this.authDealRolePowerService.dealRolePower(authReqBo);
        return (DycAuthDealRolePowerRspBo)((Object)JUtil.js((Object)authRspBo, DycAuthDealRolePowerRspBo.class));
    }

    private void validateArg(DycAuthDealRolePowerReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[DycAuthDealRolePowerReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getRoleId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBo.getRolePowerList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[\u53d8\u66f4\u5217\u8868]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty(reqBo.getRolePowerList())) {
            for (DycAuthRolePowerBo bo : reqBo.getRolePowerList()) {
                if (bo.getPowerRoleId() != null) continue;
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[PowerRoleId]\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
            }
        }
    }
}

