/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.shoppingcart.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.common.member.shoppingcart.api.DycUccBatchShoppingCartListNewService;
import com.tydic.dyc.common.member.shoppingcart.api.DycUmcGetShoppingCartCacheService;
import com.tydic.dyc.common.member.shoppingcart.bo.DycUccAddShoppingCartBo;
import com.tydic.dyc.common.member.shoppingcart.bo.DycUccBatchShoppingCartListReqBO;
import com.tydic.dyc.common.member.shoppingcart.bo.DycUmcGetShoppingCartCacheReqBo;
import com.tydic.dyc.common.member.shoppingcart.bo.DycUmcGetShoppingCartCacheRspBo;
import com.tydic.dyc.umc.service.shoppingcart.UmcGetShoppingCartPageListService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListRspBo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.shoppingcart.api.DycUmcGetShoppingCartCacheService"})
public class DycUmcGetShoppingCartCacheServiceImpl
implements DycUmcGetShoppingCartCacheService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcGetShoppingCartCacheServiceImpl.class);
    @Autowired
    private UmcGetShoppingCartPageListService umcGetShoppingCartPageListService;
    @Autowired
    private DycUccBatchShoppingCartListNewService dycUccBatchShoppingCartListNewService;
    @Value(value="${shopping.cart.cache.enable:true}")
    public Boolean cartCacheEnable;
    public static final Integer SOURCE_ECOM = 2;

    @Override
    @PostMapping(value={"getShoppingCartPageList"})
    public DycUmcGetShoppingCartCacheRspBo getShoppingCartPageList(@RequestBody DycUmcGetShoppingCartCacheReqBo reqBO) {
        Map<Integer, Map<Long, List<UmcAddShoppingCartBo>>> userShoppingCartMap;
        Map<Long, List<UmcAddShoppingCartBo>> ecomSkuMap;
        DycUmcGetShoppingCartCacheRspBo rspBo = new DycUmcGetShoppingCartCacheRspBo();
        if (this.cartCacheEnable.booleanValue() && !CollectionUtils.isEmpty(ecomSkuMap = (userShoppingCartMap = this.getUserShoppingCart(reqBO)).get(SOURCE_ECOM))) {
            for (Map.Entry<Long, List<UmcAddShoppingCartBo>> entry : ecomSkuMap.entrySet()) {
                Long supplierId = entry.getKey();
                DycUccBatchShoppingCartListReqBO dycUccBatchShoppingCartListReqBO = (DycUccBatchShoppingCartListReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUccBatchShoppingCartListReqBO.class));
                dycUccBatchShoppingCartListReqBO.setSkuSource(SOURCE_ECOM);
                dycUccBatchShoppingCartListReqBO.setSupplierIds(Collections.singletonList(supplierId));
                dycUccBatchShoppingCartListReqBO.setShopInfoList(JSON.parseArray((String)JSON.toJSONString(entry.getValue()), DycUccAddShoppingCartBo.class));
                this.dycUccBatchShoppingCartListNewService.qryUccBatchShoppingCartList(dycUccBatchShoppingCartListReqBO);
            }
        }
        return rspBo;
    }

    private Map<Integer, Map<Long, List<UmcAddShoppingCartBo>>> getUserShoppingCart(DycUmcGetShoppingCartCacheReqBo reqBO) {
        UmcGetShoppingCartPageListReqBo uscReqBo1 = (UmcGetShoppingCartPageListReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UmcGetShoppingCartPageListReqBo.class);
        uscReqBo1.setUserId(reqBO.getUserIdIn());
        uscReqBo1.setUserName(reqBO.getRegAccountIn());
        uscReqBo1.setPageNo(-1);
        uscReqBo1.setPageSize(-1);
        UmcGetShoppingCartPageListRspBo uscRspbo = this.umcGetShoppingCartPageListService.getShoppingCartPageList(uscReqBo1);
        if (!"0000".equals(uscRspbo.getRespCode())) {
            throw new ZTBusinessException(uscRspbo.getRespDesc());
        }
        Map<Integer, List<UmcAddShoppingCartBo>> detailsMap01 = uscRspbo.getRows().stream().collect(Collectors.groupingBy(UmcAddShoppingCartBo::getOrderSource));
        HashMap<Integer, Map<Long, List<UmcAddShoppingCartBo>>> mapMap = new HashMap<Integer, Map<Long, List<UmcAddShoppingCartBo>>>();
        for (Integer integer : detailsMap01.keySet()) {
            List<UmcAddShoppingCartBo> cartBos = detailsMap01.get(integer);
            Map<Long, List<UmcAddShoppingCartBo>> shopMap = cartBos.stream().collect(Collectors.groupingBy(UmcAddShoppingCartBo::getSupplierId));
            mapMap.put(integer, shopMap);
        }
        return mapMap;
    }
}

