/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.login.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.common.member.login.api.PermissionServcie;
import com.tydic.dyc.common.member.login.bo.PermissionReqBo;
import com.tydic.dyc.common.member.login.bo.PermissionRspBo;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.service.LoginTimeServcie;
import com.tydic.umc.security.service.bo.LoginExpTimeReqBO;
import com.tydic.umc.security.service.bo.LoginExpTimeRspBO;
import java.util.Map;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.login.api.PermissionServcie"})
public class PermissionServcieImpl
implements PermissionServcie {
    private static final Logger log = LoggerFactory.getLogger(PermissionServcieImpl.class);
    @Autowired
    private LoginTimeServcie loginTimeServcie;
    private static final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private CacheClient cacheTemplate;

    @Override
    @PostMapping(value={"authentication"})
    public PermissionRspBo authentication(@RequestBody PermissionReqBo reqBo) {
        PermissionRspBo rspBo = new PermissionRspBo();
        if (StringUtils.isBlank((CharSequence)reqBo.getToken())) {
            rspBo.setRespDesc("\u65e0\u6548token");
            rspBo.setRespCode("AE401");
            return rspBo;
        }
        JSONObject payload = UmcJwt.getPayload((String)reqBo.getToken());
        if (null == payload || payload.isEmpty()) {
            rspBo.setRespDesc("\u65e0\u6548token");
            rspBo.setRespCode("AE401");
            return rspBo;
        }
        String userId = payload.getAsString("userId");
        String loginSource = payload.getAsString("loginSource");
        LoginExpTimeReqBO loginExpTimeReqBO = new LoginExpTimeReqBO();
        loginExpTimeReqBO.setLoginSource(loginSource);
        loginExpTimeReqBO.setUserId(Convert.toLong((Object)userId));
        Long loginExpTime = 0L;
        loginExpTimeReqBO.setToken(reqBo.getToken());
        LoginExpTimeRspBO rspBO = this.loginTimeServcie.getLoginExpTime(loginExpTimeReqBO);
        if ("0000".equals(rspBO.getRespCode())) {
            loginExpTime = rspBO.getExpTime();
            log.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
        }
        try {
            Map resultMap = UmcJwt.validToken((String)reqBo.getToken(), (Long)loginExpTime, null);
            log.debug("\u89e3\u6790\u5b8c\u6210\u540e\u53c2\u6570\uff1a" + mapper.writeValueAsString((Object)resultMap));
            UmcTokenState state = UmcTokenState.getTokenState((String)((String)resultMap.get("state")));
            log.debug("\u67e5\u770bstate\uff1a" + mapper.writeValueAsString((Object)state));
            if (UmcTokenState.VALID.equals((Object)state)) {
                this.loginTimeServcie.updateLoginExpTime(loginExpTimeReqBO);
                rspBo.setSuccess(true);
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                String tokenMsg = (String)this.cacheTemplate.get(reqBo.getToken());
                UmcMemInfoBO umcMemInfoBO = (UmcMemInfoBO)JSON.parseObject((String)tokenMsg, UmcMemInfoBO.class);
                if (null != umcMemInfoBO) {
                    rspBo.setUserId(umcMemInfoBO.getUserId());
                    rspBo.setName(umcMemInfoBO.getName());
                }
                return rspBo;
            }
            if (UmcTokenState.EXPIRED.equals((Object)state)) {
                rspBo.setRespDesc("\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                rspBo.setRespCode("AE401");
            } else {
                rspBo.setRespDesc("\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                rspBo.setRespCode("AE401");
            }
        }
        catch (Exception e) {
            rspBo.setRespDesc("\u65e0\u6548token");
            rspBo.setRespCode("AE401");
        }
        return rspBo;
    }
}

