/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.shoppingcart.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallQrySkuInfoAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuInfoReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallQrySkuInfoRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuBo;
import com.tydic.dyc.atom.common.member.shoppingcart.api.DycUmcAddShoppingCartFunction;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycMallImportRecordFunctionBO;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionBo;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionReqBo;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionRspBo;
import com.tydic.dyc.base.constants.UscExternalCommonConstant;
import com.tydic.dyc.base.utils.HttpUtil;
import com.tydic.dyc.common.member.shoppingcart.api.DycUmcImportShoppingCartService;
import com.tydic.dyc.common.member.shoppingcart.bo.DycUmcImportShoppingCartReqBO;
import com.tydic.dyc.common.member.shoppingcart.bo.DycUmcImportShoppingCartRspBO;
import com.tydic.dyc.common.member.utils.ExcelUtils;
import com.tydic.dyc.umc.service.enterprise.UmcFileImpLogService;
import com.tydic.dyc.umc.service.enterprise.bo.BusinessChangeFileAnnoxBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcFileImpLogDetailBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcFileImpLogReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcFileImpLogRspBO;
import com.tydic.dyc.umc.service.shopcart.bo.UmcExportImportResultsReqBO;
import com.tydic.dyc.umc.service.shopcart.bo.UmcExportImportResultsRspBO;
import com.tydic.dyc.umc.service.shopcart.service.UmcExportImportResultService;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.shoppingcart.api.DycUmcImportShoppingCartService"})
public class DycUmcImportShoppingCartServiceImpl
implements DycUmcImportShoppingCartService {
    private static final Logger log = LoggerFactory.getLogger(DycUmcImportShoppingCartServiceImpl.class);
    @Value(value="${maxProductAmount:1000000}")
    private int maxProductAmount;
    @Value(value="${maxCartNum:100}")
    private int maxCartNum;
    private static final List<String> TITLE = new ArrayList<String>();
    private static final String BR = "<br>";
    @Autowired
    private UccMallQrySkuInfoAbilityService uccMallQrySkuInfoAbilityService;
    @Autowired
    private UmcFileImpLogService umcFileImpLogService;
    @Autowired
    private UmcExportImportResultService umcExportImportResultService;
    @Autowired
    private DycUmcAddShoppingCartFunction dycUmcAddShoppingCartFunction;

    private static void initialize() {
        TITLE.add("\u5355\u54c1\u7f16\u7801");
        TITLE.add("\u8d2d\u4e70\u6570\u91cf");
    }

    @Override
    @PostMapping(value={"importGoods"})
    public DycUmcImportShoppingCartRspBO importGoods(@RequestBody DycUmcImportShoppingCartReqBO abilityReqBO) {
        Map objectMap;
        String skuId;
        StringBuilder errorMessage;
        DycUmcImportShoppingCartRspBO rspBO = new DycUmcImportShoppingCartRspBO();
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        DycUmcAddShoppingCartFunctionReqBo busiReqBO = new DycUmcAddShoppingCartFunctionReqBo();
        ArrayList<Map<String, Object>> importDataMaps = new ArrayList<Map<String, Object>>();
        HashMap<String, Map> skuMapping = new HashMap<String, Map>();
        try {
            errorMessage = this.analysisFile(abilityReqBO, busiReqBO, importDataMaps);
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u6a21\u7248\u5f02\u5e38", (Throwable)e);
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u3010\u6a21\u677f\u4e0b\u8f7d\u3011\u6309\u94ae\u4e0b\u8f7d\u7684\u6a21\u677f\u8fdb\u884c\u5bfc\u5165\u5546\u54c1\u64cd\u4f5c\u3002");
        }
        for (Map map : importDataMaps) {
            if (!map.containsKey("skuId")) continue;
            skuMapping.put(map.get("skuId").toString(), map);
        }
        busiReqBO.setIsImport(Boolean.valueOf(true));
        busiReqBO.setLoginSource(abilityReqBO.getLoginSource());
        busiReqBO.setTenantIdIn(Long.valueOf(10000L));
        busiReqBO.setTenantId("10000");
        DycUmcAddShoppingCartFunctionRspBo dycUmcAddShoppingCartFunctionRspBo = this.dycUmcAddShoppingCartFunction.addShoppingCart(busiReqBO);
        if (CollectionUtils.isEmpty((Collection)dycUmcAddShoppingCartFunctionRspBo.getUscImportRecordBOSuccess()) && !CollectionUtils.isEmpty((Collection)dycUmcAddShoppingCartFunctionRspBo.getUscImportRecordBOfail())) {
            throw new ZTBusinessException(((DycMallImportRecordFunctionBO)dycUmcAddShoppingCartFunctionRspBo.getUscImportRecordBOfail().get(0)).getFailedReason());
        }
        BeanUtils.copyProperties((Object)dycUmcAddShoppingCartFunctionRspBo, (Object)((Object)rspBO));
        for (DycMallImportRecordFunctionBO recordBO : dycUmcAddShoppingCartFunctionRspBo.getUscImportRecordBOSuccess()) {
            skuId = recordBO.getSkuId().toString();
            if (skuMapping.get(skuId) == null) continue;
            objectMap = (Map)skuMapping.get(skuId);
            objectMap.put("impResult", UscExternalCommonConstant.ImportStatus.SUCCESS);
            objectMap.put("impRemark", "\u6210\u529f");
        }
        for (DycMallImportRecordFunctionBO recordBO : dycUmcAddShoppingCartFunctionRspBo.getUscImportRecordBOfail()) {
            skuId = recordBO.getSkuId().toString();
            if (skuMapping.get(skuId) == null) continue;
            objectMap = (Map)skuMapping.get(skuId);
            objectMap.put("impResult", UscExternalCommonConstant.ImportStatus.FAILED);
            objectMap.put("impRemark", recordBO.getFailedReason());
            errorMessage.append(recordBO.getFailedReason()).append(BR);
        }
        long l = 0L;
        long failCount = 0L;
        for (Map map : importDataMaps) {
            if (map.get("impResult").equals(UscExternalCommonConstant.ImportStatus.SUCCESS)) {
                ++l;
                continue;
            }
            ++failCount;
        }
        UmcExportImportResultsReqBO uscExportImportResultsBusiReqBO = new UmcExportImportResultsReqBO();
        uscExportImportResultsBusiReqBO.setMemId(abilityReqBO.getUserId());
        uscExportImportResultsBusiReqBO.setImportDataMaps(importDataMaps);
        UmcExportImportResultsRspBO umcExportImportResultsRspBO = this.umcExportImportResultService.importExportLog(uscExportImportResultsBusiReqBO);
        if (!umcExportImportResultsRspBO.getRespCode().equals("0000")) {
            throw new ZTBusinessException("\u5bfc\u51fa\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25");
        }
        UmcFileImpLogReqBO umcFileImpLogReqBO = new UmcFileImpLogReqBO();
        umcFileImpLogReqBO.setSuccessCount(Long.valueOf(l));
        umcFileImpLogReqBO.setFailureCount(Long.valueOf(failCount));
        umcFileImpLogReqBO.setImpCount(Long.valueOf(l + failCount));
        umcFileImpLogReqBO.setMemIdIn(busiReqBO.getMemIdIn());
        umcFileImpLogReqBO.setImpType("USC_CART_IMPORT");
        umcFileImpLogReqBO.setOutImpId(Long.valueOf(10101L));
        umcFileImpLogReqBO.setImpRemark("");
        umcFileImpLogReqBO.setImpResult(Integer.valueOf(0));
        this.createDataJson(umcExportImportResultsRspBO, umcFileImpLogReqBO);
        UmcFileImpLogRspBO umcFileImpLogRspBO = this.umcFileImpLogService.fileImpLogAdd(umcFileImpLogReqBO);
        if (!umcFileImpLogRspBO.getRespCode().equals("0000")) {
            throw new ZTBusinessException("\u8c03\u7528\u4f1a\u5458\u5bfc\u5165\u6587\u4ef6\u8bb0\u5f55\u5931\u8d25");
        }
        if (StringUtils.isNotBlank((CharSequence)errorMessage.toString())) {
            rspBO.setCode("1");
            rspBO.setMessage(errorMessage.toString());
        }
        return rspBO;
    }

    private StringBuilder analysisFile(DycUmcImportShoppingCartReqBO abilityReqBO, DycUmcAddShoppingCartFunctionReqBo busiReqBO, List<Map<String, Object>> importDataMaps) {
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getFileUrl())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010fileUrl\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getUserId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getProvince()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010province\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCity()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010city\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCounty()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010county\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getTown()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010town\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder errorMessage = new StringBuilder();
        ArrayList<String> title = new ArrayList<String>();
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            HttpUtil.deleteFile((String)"temporaryfile/content.xlsx");
            File file = new File(System.getProperty("user.dir") + "/temporaryfile/content.xlsx");
            File fileParent = file.getParentFile();
            if (!fileParent.exists()) {
                fileParent.mkdirs();
            }
            HttpUtil.httpDownload((String)abilityReqBO.getFileUrl(), (String)file.getAbsolutePath());
            FileInputStream fileInputStream = new FileInputStream(file);
            MockMultipartFile multipartFile = new MockMultipartFile(file.getName(), file.getName(), ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
            ExcelUtils.getExcelDate((MultipartFile)multipartFile, data, title);
            HttpUtil.deleteFile((String)("temporaryfile/" + file.getName()));
        }
        catch (Exception e) {
            log.error("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            throw new ZTBusinessException("\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\uff1a" + e);
        }
        if (TITLE.size() != title.size()) {
            log.info("TITLE=" + TITLE.toString());
            log.info("title=" + ((Object)title).toString());
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u3010\u6a21\u677f\u4e0b\u8f7d\u3011\u6309\u94ae\u4e0b\u8f7d\u7684\u6a21\u677f\u8fdb\u884c\u5bfc\u5165\u5546\u54c1\u64cd\u4f5c");
        }
        if (!TITLE.containsAll(title)) {
            throw new ZTBusinessException("\u8bf7\u4f7f\u7528\u3010\u6a21\u677f\u4e0b\u8f7d\u3011\u6309\u94ae\u4e0b\u8f7d\u7684\u6a21\u677f\u8fdb\u884c\u5bfc\u5165\u5546\u54c1\u64cd\u4f5c");
        }
        if (data.size() < 1) {
            throw new ZTBusinessException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
        }
        if (data.size() > this.maxCartNum) {
            throw new ZTBusinessException("\u8d2d\u7269\u8f66\u6700\u591a\u53ef\u4ee5\u6dfb\u52a0" + this.maxCartNum + "\u79cd\u5546\u54c1\uff01");
        }
        ArrayList<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList = new ArrayList<DycUmcAddShoppingCartFunctionBo>();
        HashMap<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap = new HashMap<String, DycUmcAddShoppingCartFunctionBo>();
        HashMap<String, String> skuPurchaseModIdMap = new HashMap<String, String>();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        UccMallQrySkuInfoReqBO uccMallQrySkuInfoReqBO = new UccMallQrySkuInfoReqBO();
        List skuCodes = data.stream().map(lilt -> (String)lilt.get(0)).collect(Collectors.toList());
        uccMallQrySkuInfoReqBO.setSkuCodes(skuCodes);
        log.info("\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3skuId\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccMallQrySkuInfoReqBO));
        UccMallQrySkuInfoRspBO uccMallQrySkuInfoRspBO = this.uccMallQrySkuInfoAbilityService.querySkuInfoByCode(uccMallQrySkuInfoReqBO);
        log.info("\u67e5\u8be2\u5546\u54c1\u4e2d\u5fc3skuId\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)uccMallQrySkuInfoRspBO));
        Map<Object, Object> skuIdMap = new HashMap();
        Map<Object, Object> uccMallSkuMapBos = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)uccMallQrySkuInfoRspBO.getUccMallSkuBos())) {
            skuIdMap = uccMallQrySkuInfoRspBO.getUccMallSkuBos().stream().collect(Collectors.toMap(UccMallSkuBo::getSkuCode, UccMallSkuBo::getSkuId));
            uccMallSkuMapBos = uccMallQrySkuInfoRspBO.getUccMallSkuBos().stream().collect(Collectors.groupingBy(UccMallSkuBo::getSkuId));
        }
        for (List list : data) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            boolean importErrMsgFlag = false;
            StringBuilder importRemark = new StringBuilder();
            if (list.size() != TITLE.size()) {
                importErrMsgFlag = true;
            }
            try {
                if (StringUtils.isBlank((CharSequence)((CharSequence)list.get(0)))) {
                    importErrMsgFlag = true;
                    dataMap.put("skuCode", list.get(0));
                    dataMap.put("productAmount", list.get(1));
                    dataMap.put("impResult", UscExternalCommonConstant.ImportStatus.FAILED);
                    dataMap.put("impRemark", "\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a");
                    errorMessage.append("\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a").append(BR);
                    importDataMaps.add(dataMap);
                    continue;
                }
                if (ObjectUtil.isNull((Object)skuIdMap.get(list.get(0)))) {
                    importErrMsgFlag = true;
                    dataMap.put("skuCode", list.get(0));
                    dataMap.put("productAmount", list.get(1));
                    dataMap.put("impResult", UscExternalCommonConstant.ImportStatus.FAILED);
                    dataMap.put("impRemark", "\u4e0d\u5b58\u5728\u8be5\u5546\u54c1");
                    errorMessage.append("\u5355\u54c1\u7f16\u7801" + (String)list.get(0) + "\u4e0d\u5b58\u5728\u8be5\u5546\u54c1").append(BR);
                    importDataMaps.add(dataMap);
                    continue;
                }
                String skuCode = (String)list.get(0);
                Long skuId = new BigDecimal((Long)skuIdMap.get(list.get(0))).longValue();
                BigDecimal productAmount = new BigDecimal((String)list.get(1));
                String purchaseModId = "2";
                String purchaseModId1 = (String)skuPurchaseModIdMap.get(skuId);
                if (purchaseModId1 != null && purchaseModId1.equals(purchaseModId)) {
                    importErrMsgFlag = true;
                    dataMap.put("skuId", skuId);
                    dataMap.put("skuCode", skuCode);
                    importRemark.append("\u540c\u4e00\u4e2a\u91c7\u8d2d\u6a21\u5f0f\u4e0b\u7684SkuId\u4e0d\u80fd\u91cd\u590d\uff01");
                    errorMessage.append(importRemark.toString()).append(BR);
                }
                skuPurchaseModIdMap.put(String.valueOf(skuId), purchaseModId);
                dataMap.put("skuId", skuId);
                dataMap.put("skuCode", skuCode);
                if (productAmount.compareTo(new BigDecimal(this.maxProductAmount)) > 0) {
                    importErrMsgFlag = true;
                    dataMap.put("productAmount", productAmount);
                    importRemark.append("\u5546\u54c1\u3010").append(skuId).append("\u3011\u7684\u8d2d\u4e70\u6570\u91cf\u8d85\u6807\uff0c\u5355\u79cd\u5546\u54c1\u7684\u6700\u5927\u8d2d\u4e70\u6570\u91cf\u4e3a").append(this.maxProductAmount).append("\uff01");
                    errorMessage.append(importRemark.toString()).append(BR);
                }
                if (productAmount.compareTo(BigDecimal.ZERO) <= 0) {
                    importErrMsgFlag = true;
                    dataMap.put("skuId", skuId);
                    dataMap.put("skuCode", skuCode);
                    dataMap.put("productAmount", productAmount);
                    importRemark.append("\u5546\u54c1\u3010").append(skuId).append("\u3011\u7684\u8d2d\u4e70\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7b49\u4e8e0\uff01");
                    errorMessage.append(importRemark.toString()).append(BR);
                }
                if (new BigDecimal(productAmount.intValue()).compareTo(productAmount) != 0) {
                    importErrMsgFlag = true;
                    dataMap.put("skuId", skuId);
                    dataMap.put("skuCode", skuCode);
                    dataMap.put("productAmount", productAmount);
                    importRemark.append("\u5546\u54c1\u3010").append(skuId).append("\u3011\u7684\u8d2d\u4e70\u6570\u91cf\u9700\u4e3a\u6b63\u6574\u6570\uff01");
                    errorMessage.append(importRemark.toString()).append(BR);
                }
                if (!importErrMsgFlag) {
                    DycUmcAddShoppingCartFunctionBo uscCnncAddGoddsInfoBO = new DycUmcAddShoppingCartFunctionBo();
                    UccMallSkuBo uccMallSkuBo = (UccMallSkuBo)((List)uccMallSkuMapBos.get(skuId)).get(0);
                    uscCnncAddGoddsInfoBO.setSkuId(skuId);
                    uscCnncAddGoddsInfoBO.setProductAmount(productAmount.toString());
                    dataMap.put("productAmount", productAmount);
                    uscCnncAddGoddsInfoBO.setPurchaseModId(purchaseModId);
                    uscCnncAddGoddsInfoBO.setAddAmount(productAmount.toString());
                    if ("1".equals(purchaseModId)) {
                        uscCnncAddGoddsInfoBO.setPurchaseModName("\u8ba1\u5212");
                    } else {
                        uscCnncAddGoddsInfoBO.setPurchaseModName("\u975e\u8ba1\u5212");
                    }
                    uscCnncAddGoddsInfoBO.setSupplierShopId(uccMallSkuBo.getSupplierShopId());
                    uscCnncAddGoddsInfoBO.setSupplierId(uccMallSkuBo.getSupplierShopId());
                    uscCnncAddGoddsInfoBO.setOrderSource(uccMallSkuBo.getSkuSource());
                    uscCnncAddGoddsInfoBO.setJoinPrice("0");
                    uscCnncAddGoddsInfoBO.setUniqueKey(abilityReqBO.getUserId() + "_" + uscCnncAddGoddsInfoBO.getPurchaseModId() + "_" + uscCnncAddGoddsInfoBO.getSkuId());
                    mapUniqueKeyBoMap.put(uscCnncAddGoddsInfoBO.getUniqueKey(), uscCnncAddGoddsInfoBO);
                    uscAddGoddsInfoBOList.add(uscCnncAddGoddsInfoBO);
                    skuIds.add(skuId);
                }
            }
            catch (Exception e) {
                log.error("\u6570\u636e\u975e\u6cd5", (Throwable)e);
                importErrMsgFlag = true;
                dataMap.put("skuId", skuIdMap.get(list.get(0)));
                dataMap.put("skuCode", list.get(0));
                dataMap.put("productAmount", list.get(1));
                dataMap.put("impResult", UscExternalCommonConstant.ImportStatus.FAILED);
                importRemark.append("\u3010").append((String)list.get(0)).append("\u3011\u5546\u54c1\u7531\u4e8e\u3010\u6570\u636e\u975e\u6cd5\u3011\u539f\u56e0\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u5c06\u5176\u5220\u9664\u540e\u91cd\u65b0\u5bfc\u5165!");
                errorMessage.append(importRemark.toString()).append(BR);
            }
            if (importErrMsgFlag) {
                dataMap.put("impResult", UscExternalCommonConstant.ImportStatus.FAILED);
                dataMap.put("impRemark", importRemark.toString());
            } else {
                dataMap.put("impResult", UscExternalCommonConstant.ImportStatus.SUCCESS);
                dataMap.put("impRemark", "\u6210\u529f");
            }
            importDataMaps.add(dataMap);
        }
        BeanUtils.copyProperties((Object)((Object)abilityReqBO), (Object)busiReqBO);
        busiReqBO.setIsCheck(Integer.valueOf(1));
        busiReqBO.setUserIdIn(abilityReqBO.getUserId());
        busiReqBO.setUscAddGoddsInfoBOList(uscAddGoddsInfoBOList);
        return errorMessage;
    }

    private void createDataJson(UmcExportImportResultsRspBO umcExportImportResultsRspBO, UmcFileImpLogReqBO reqBO) {
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setName(umcExportImportResultsRspBO.getFilePath());
        annoxBO.setPath(umcExportImportResultsRspBO.getFullFilePath());
        fileUrlList.add(annoxBO);
        reqBO.setFileUrl(fileUrlList);
        StringBuilder headBuilder = new StringBuilder();
        if (umcExportImportResultsRspBO.getExportData() != null && umcExportImportResultsRspBO.getExportData().size() > 0) {
            boolean firstRow = true;
            ArrayList<UmcFileImpLogDetailBO> logDetailBOS = new ArrayList<UmcFileImpLogDetailBO>();
            for (Map row : umcExportImportResultsRspBO.getExportData()) {
                UmcFileImpLogDetailBO detailBO = new UmcFileImpLogDetailBO();
                StringBuilder builder = new StringBuilder();
                Iterator it = row.entrySet().iterator();
                int size = row.size();
                int count = 1;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    if (firstRow) {
                        if (count == size) {
                            firstRow = false;
                            headBuilder.append(entry.getKey());
                        } else {
                            headBuilder.append(entry.getKey()).append("##");
                        }
                    }
                    builder.append((Object)(StringUtils.isBlank((CharSequence)entry.getValue().toString()) ? " " : entry.getValue()));
                    if (count != size) {
                        builder.append("##");
                    }
                    ++count;
                }
                detailBO.setDataJson(builder.toString());
                if (row.get("\u5bfc\u5165\u7ed3\u679c").toString().equals("\u6210\u529f")) {
                    detailBO.setStatus(UscExternalCommonConstant.ImportStatus.SUCCESS);
                } else {
                    detailBO.setStatus(UscExternalCommonConstant.ImportStatus.FAILED);
                    detailBO.setFailureReasons(row.get("\u5931\u8d25\u539f\u56e0").toString());
                }
                logDetailBOS.add(detailBO);
            }
            reqBO.setLogDetails(logDetailBOS);
            reqBO.setDataColumns(headBuilder.toString());
        }
    }

    static {
        DycUmcImportShoppingCartServiceImpl.initialize();
    }
}

