/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.common.member.user.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.authority.service.user.AuthUpdateCustInfoPasswordService;
import com.tydic.dyc.authority.service.user.bo.AuthUpdateCustInfoPasswordReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUpdateCustInfoPasswordRspBo;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.base.utils.SaltUtils;
import com.tydic.dyc.common.member.user.api.DycAuthUpdateCustInfoPasswordService;
import com.tydic.dyc.common.member.user.bo.DycAuthUpdateCustInfoPasswordReqBo;
import com.tydic.dyc.common.member.user.bo.DycAuthUpdateCustInfoPasswordRspBo;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umc.security.utils.EncryptUtils;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.common.member.user.api.DycAuthUpdateCustInfoPasswordService"})
public class DycAuthUpdateCustInfoPasswordServiceImpl
implements DycAuthUpdateCustInfoPasswordService {
    private static final Logger log = LoggerFactory.getLogger(DycAuthUpdateCustInfoPasswordServiceImpl.class);
    @Autowired
    private AuthUpdateCustInfoPasswordService authUpdateCustInfoPasswordService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Autowired
    private EncryptUtils encryptUtils;
    @Value(value="${password.encryptType:SHA-256}")
    private String encryptType;
    @Value(value="${password_eff:90}")
    private Integer password_eff;

    @Override
    @PostMapping(value={"updateCustInfoPassword"})
    public DycAuthUpdateCustInfoPasswordRspBo updateCustInfoPassword(@RequestBody DycAuthUpdateCustInfoPasswordReqBo reqBo) {
        this.checkInitInfo(reqBo);
        Object object = this.cacheService.get(reqBo.getEncryption());
        if (null == object) {
            throw new ZTBusinessException("\u7f13\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u9a8c\u8bc1\u7801");
        }
        String loginInfo = object.toString();
        String[] arr = loginInfo.split(",");
        if (!AesUtil.decryptStr((String)reqBo.getPassword(), (String)this.ORIGINAL_KEY).equals(AesUtil.decryptStr((String)reqBo.getRePassword(), (String)this.ORIGINAL_KEY))) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u4e00\u81f4,\u8bf7\u91cd\u8f93");
        }
        String encrypt = this.encryptUtils.encryptByType(AesUtil.decryptStr((String)reqBo.getPassword(), (String)this.ORIGINAL_KEY), this.encryptType);
        String salt = SaltUtils.getSerialNo((int)8);
        String pwd = this.encryptUtils.encryptByType(encrypt + salt, this.encryptType);
        AuthUpdateCustInfoPasswordReqBo passwordReqBo = new AuthUpdateCustInfoPasswordReqBo();
        passwordReqBo.setPassword(pwd);
        passwordReqBo.setSalt(salt);
        passwordReqBo.setLoginName(arr[0]);
        if (arr[3].equals("1")) {
            passwordReqBo.setCellPhone(arr[1]);
        } else {
            passwordReqBo.setEmail(arr[1]);
        }
        passwordReqBo.setPasswordEffTime(DateUtils.addDays((Date)new Date(), (int)this.password_eff));
        AuthUpdateCustInfoPasswordRspBo authUpdateCustInfoPasswordRspBo = this.authUpdateCustInfoPasswordService.updateCustInfoPassword(passwordReqBo);
        if (!"0000".equals(authUpdateCustInfoPasswordRspBo.getRespCode())) {
            throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u5931\u8d25");
        }
        return (DycAuthUpdateCustInfoPasswordRspBo)((Object)JUtil.js((Object)authUpdateCustInfoPasswordRspBo, DycAuthUpdateCustInfoPasswordRspBo.class));
    }

    public void checkInitInfo(DycAuthUpdateCustInfoPasswordReqBo reqBo) {
        if (null == reqBo) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getEncryption())) {
            throw new ZTBusinessException("\u52a0\u5bc6\u4e32\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getPassword())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getRePassword())) {
            throw new ZTBusinessException("\u91cd\u8f93\u5bc6\u7801\u4e3a\u7a7a");
        }
    }
}

